/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.monster;

import com.crypticmushroom.minecraft.midnight.common.entity.base.MnFlyingMonster;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.NovaSpikeEntity;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomFlyingTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;

public class NovaEntity
extends MnFlyingMonster<NovaEntity>
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(NovaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected float heightOffset = 0.5f;

    public NovaEntity(EntityType<? extends NovaEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22280_, 0.4);
    }

    public boolean m_5825_() {
        return true;
    }

    protected PathNavigation m_6037_(Level level) {
        return new FlyingPathNavigation((Mob)this, level){
            {
                this.m_26440_(false);
                this.m_26443_(false);
            }
        };
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return super.m_6431_(pose, dimensions) * 0.5f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.CONTINUE)});
    }

    public List<ExtendedSensor<NovaEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyPlayersSensor()});
    }

    public BrainActivityGroup<NovaEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<NovaEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().useMemory(MemoryModuleType.f_148206_), new SetPlayerLookTarget(), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomFlyingTarget().speedModifier(0.9f), new Idle().runFor(e -> e.m_217043_().m_216339_(30, 60))})});
    }

    public BrainActivityGroup<NovaEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(0).whenStarting(e -> e.setAttacking(true)).whenStopping(e -> e.setAttacking(false)), new AnimatableRangedAttack(0).attackRadius(24.0f).attackInterval(e -> 60)});
    }

    public void m_6504_(LivingEntity target, float velocity) {
        NovaSpikeEntity spike = new NovaSpikeEntity((LivingEntity)this, this.m_9236_());
        spike.m_6034_(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_());
        spike.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), -8.0f, velocity, 1.0f);
        this.m_9236_().m_7967_((Entity)spike);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MnSoundEvents.ENTITY_NOVA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MnSoundEvents.ENTITY_NOVA_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MnSoundEvents.ENTITY_NOVA_AMBIENT.get();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return !(source.m_7640_() instanceof NovaSpikeEntity) && super.m_6469_(source, amount);
    }

    public float getHeightOffset() {
        return this.heightOffset;
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)attacking);
    }
}

