/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.monster;

import com.crypticmushroom.minecraft.midnight.client.util.MnAnims;
import com.crypticmushroom.minecraft.midnight.common.entity.base.MnMonster;
import com.crypticmushroom.minecraft.midnight.common.entity.behaviour.ContinuousSequentialBehaviour;
import com.crypticmushroom.minecraft.midnight.common.entity.behaviour.RetaliatePlayerLookingAt;
import com.crypticmushroom.minecraft.midnight.common.entity.behaviour.TeleportTowardsAttackTarget;
import com.crypticmushroom.minecraft.midnight.common.entity.living.ai.BrainActivityGroupMap;
import com.crypticmushroom.minecraft.midnight.common.entity.sensor.NearbyRiftsSensor;
import com.crypticmushroom.minecraft.midnight.common.entity.sensor.PlayerLookedAtBySensor;
import com.crypticmushroom.minecraft.midnight.common.registry.MnAttributes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBrainUtil;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDamageTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnMemoryTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnMobEffects;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRetaliateTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Nightshade
extends MnMonster<Nightshade> {
    private static final EntityDataAccessor<Boolean> IS_ANGRY = SynchedEntityData.m_135353_(Nightshade.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public static AttributeSupplier.Builder attributes() {
        return EnderMan.m_32541_().m_22268_((Attribute)MnAttributes.MALIGNANT_ARMOR.get(), 3.0);
    }

    public Nightshade(EntityType<? extends Nightshade> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Run/Idle/Scream", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.isAngry() ? MnAnims.RUN : MnAnims.WALK);
            }
            return state.setAndContinue(this.isAngry() ? MnAnims.IDLE_ANGRY : MnAnims.IDLE);
        })});
        controllers.add(new AnimationController[]{DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)MnAnims.ATTACK_STRIKE)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Scream", 6, state -> PlayState.STOP).triggerableAnim("scream", MnAnims.SCREAM).triggerableAnim("scream_buildup", MnAnims.SCREAM_BUILDUP)});
    }

    public List<ExtendedSensor<Nightshade>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new HurtBySensor(), new NearbyPlayersSensor(), new NearbyRiftsSensor().setRadius(20.0, 6.0), new PlayerLookedAtBySensor().setScanRate(e -> 2)});
    }

    public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{Activity.f_219851_, Activity.f_37988_, Activity.f_37979_});
    }

    public BrainActivityGroup<Nightshade> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new FloatToSurfaceOfFluid(), new LookAtTarget(), new MoveToWalkTarget(), MnBrainUtil.updateAngry(this), MnBrainUtil.riftBasedHealOrHurt(this, e -> false)});
    }

    public BrainActivityGroup<Nightshade> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetRetaliateTarget().whenStarting(this::setShouldRoar), new RetaliatePlayerLookingAt().whenStarting(this::setShouldRoar), new SetPlayerLookTarget(), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.35f), new Idle().runFor(e -> e.m_217043_().m_216339_(30, 60))})});
    }

    public BrainActivityGroup<Nightshade> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf(MnBrainUtil::attackTargetInvalid).ignoreFailedPathfinding(), new InvalidateMemory(MemoryModuleType.f_26370_).startCondition(e -> !BrainUtils.hasMemory((LivingEntity)e, (MemoryModuleType)MemoryModuleType.f_26372_)), new SetWalkTargetToAttackTarget().speedMod((e, target) -> Float.valueOf(1.5f)), new AnimatableMeleeAttack(2), new TeleportTowardsAttackTarget().minimumDistToTarget(1.0).distTowards((e, target) -> Float.valueOf(e.m_217043_().m_216339_(8, 24))).cooldownFor(e -> e.m_217043_().m_216339_(5, 45)).whenStarting(e -> Nightshade.playSound(e, SoundEvents.f_11852_))});
    }

    public Map<Activity, BrainActivityGroup<? extends Nightshade>> getAdditionalTasks() {
        return new BrainActivityGroupMap(new BrainActivityGroup(Activity.f_219851_).priority(5).onlyStartWithMemoryStatus(MemoryModuleType.f_26372_, MemoryStatus.VALUE_PRESENT).onlyStartWithMemoryStatus((MemoryModuleType)MnMemoryTypes.SHOULD_ROAR.get(), MemoryStatus.VALUE_PRESENT).behaviours(new Behavior[]{new LookAtTarget(), new ContinuousSequentialBehaviour(new TeleportTowardsAttackTarget().maxRandomOffset(3.0).distTowards((e, target) -> Float.valueOf(e.m_20270_((Entity)target) + 3.0f)).whenStarting(e -> e.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f)), new Idle().runFor(e -> e.m_217043_().m_216339_(40, 50)), new Idle().runFor(e -> 5).whenStarting(e -> this.triggerAnim("Scream", "scream")).whenStopping(e -> e.m_5496_(SoundEvents.f_11850_, 2.5f, 0.7f)), new Idle().runFor(e -> 10).whenStopping(this::setAngry))}));
    }

    private <E extends Nightshade> void setShouldRoar(E entity) {
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.SHOULD_ROAR.get()), (Object)Unit.INSTANCE);
    }

    private <E extends Nightshade> void setAngry(E entity) {
        BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.SHOULD_ROAR.get()));
        entity.m_5496_(SoundEvents.f_11851_, 2.5f, 1.0f);
        entity.setAngry(true);
    }

    public static void playSound(LivingEntity entity, SoundEvent event) {
        entity.m_5496_(event, 1.0f, 1.0f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269014_() && source.m_7640_() != null) {
            Entity entity = source.m_7640_();
            boolean flag1 = entity instanceof ThrownPotion ? this.hurtWithCleanWater(source, (ThrownPotion)entity, amount) : false;
            for (int i = 0; i < 64; ++i) {
                if (!this.randomTeleport()) continue;
                return true;
            }
            return flag1;
        }
        boolean flag = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && !(source.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(10) != 0) {
            this.randomTeleport();
        }
        return flag;
    }

    private boolean hurtWithCleanWater(DamageSource source, ThrownPotion p_potion, float amount) {
        ItemStack itemstack = p_potion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
        List list = PotionUtils.m_43547_((ItemStack)itemstack);
        boolean flag = potion == Potions.f_43599_ && list.isEmpty();
        return flag && super.m_6469_(source, amount);
    }

    protected boolean randomTeleport() {
        if (this.m_9236_().m_5776_() || !this.m_6084_()) {
            return false;
        }
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        return this.teleport(x, y, z);
    }

    boolean teleportTowards(Entity target) {
        Vec3 pos = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20227_(0.5) - target.m_20188_(), this.m_20189_() - target.m_20189_());
        pos = pos.m_82541_();
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - pos.f_82479_ * 16.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - pos.f_82480_ * 16.0;
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - pos.f_82481_ * 16.0;
        return this.teleport(x, y, z);
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (pos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)pos).m_280555_()) {
            pos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.m_9236_().m_8055_((BlockPos)pos);
        boolean blocksMotion = blockState.m_280555_();
        boolean isWater = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (!blocksMotion || isWater) {
            return false;
        }
        EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
        if (event.isCanceled()) {
            return false;
        }
        Vec3 origin = this.m_20182_();
        boolean didTeleport = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
        if (didTeleport) {
            this.m_9236_().m_214171_(GameEvent.f_238175_, origin, GameEvent.Context.m_223717_((Entity)this));
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
        return didTeleport;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ANGRY, (Object)false);
    }

    public boolean isAngry() {
        return (Boolean)this.f_19804_.m_135370_(IS_ANGRY);
    }

    public void setAngry(boolean angry) {
        this.f_19804_.m_135381_(IS_ANGRY, (Object)angry);
    }

    public boolean m_6126_() {
        return true;
    }

    public MobType m_6336_() {
        return MnEntityTypes.CORRUPTED;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public float m_6100_() {
        return 0.7f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isAngry() ? (SoundEvent)MnSoundEvents.ENTITY_NIGHTSHADE_SCREAM.get() : (SoundEvent)MnSoundEvents.ENTITY_NIGHTSHADE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MnSoundEvents.ENTITY_NIGHTSHADE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MnSoundEvents.ENTITY_NIGHTSHADE_DEATH.get();
    }

    protected static class NightshadeRoar<E extends Mob>
    extends DelayedBehaviour<E> {
        private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT)});

        public NightshadeRoar(int actionDelayTicks) {
            super(actionDelayTicks);
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
        }

        protected void doDelayedAction(E entity) {
            LivingEntity target = BrainUtils.getTargetOfEntity(entity);
            if (target == null) {
                return;
            }
            float dist = target.m_20270_(entity);
            float roarStrength = Mth.m_184655_((float)dist, (float)24.0f, (float)2.0f);
            if (roarStrength > 0.0f) {
                target.m_6469_(entity.m_9236_().m_269111_().m_269298_(MnDamageTypes.NIGHTSHADE_ROAR, entity), 4.0f * roarStrength);
                int amplifier = 0;
                if (target.m_21023_((MobEffect)MnMobEffects.SHADE_SCREECH.get())) {
                    amplifier = target.m_21124_((MobEffect)MnMobEffects.SHADE_SCREECH.get()).m_19564_() + 1;
                }
                target.m_7292_(new MobEffectInstance((MobEffect)MnMobEffects.SHADE_SCREECH.get(), (int)(240.0f * roarStrength), amplifier, false, false));
            }
            entity.m_20124_(Pose.ROARING);
        }
    }
}

