/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.creature.animal;

import com.crypticmushroom.minecraft.midnight.common.advancement.MnCriteriaTriggers;
import com.crypticmushroom.minecraft.midnight.common.block.plant.UnstableBushBlock;
import com.crypticmushroom.minecraft.midnight.common.entity.animation.AnimationHelper;
import com.crypticmushroom.minecraft.midnight.common.entity.network.MnEntityDataAccessor;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDamageTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBiomeTags;
import com.crypticmushroom.minecraft.midnight.data.tag.MnItemTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NightstagEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int MAX_TEASE_TIME = 200;
    private static final MnEntityDataAccessor<Byte> ANTLER_TYPE = new MnEntityDataAccessor("AntlerType", SynchedEntityData.m_135353_(NightstagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_));
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(NightstagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PERFORMING_CURTSY = SynchedEntityData.m_135353_(NightstagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(NightstagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Predicate<BlockState> CONSUMABLE_FRUIT_BUSH = p -> p.m_60734_() instanceof UnstableBushBlock && (Integer)p.m_61143_((Property)UnstableBushBlock.STAGE) >= 5;
    private int teaseTime = 200;
    public float flicker;
    public float flickerO;
    public int swingTimer;

    public static AttributeSupplier.Builder attributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22281_, 4.0).m_22266_(Attributes.f_22282_);
    }

    public NightstagEntity(EntityType<? extends NightstagEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean m_8036_() {
                return (this.f_25684_.m_9236_().m_46791_() == Difficulty.PEACEFUL || this.f_25684_.m_6162_()) && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ChargeAttackGoal(1.2, 200, 0.25f));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            public boolean m_8036_() {
                return this.f_25540_.m_9236_().m_46791_() != Difficulty.PEACEFUL && !this.f_25540_.m_6162_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(MnItemTags.UNSTABLE_FRUITS), false){

            public boolean m_8036_() {
                boolean valid = super.m_8036_();
                if (valid && !this.f_25925_.m_7500_() && --NightstagEntity.this.teaseTime < 0) {
                    NightstagEntity.this.teaseTime = 200;
                    this.f_25924_.m_6710_((LivingEntity)this.f_25925_);
                }
                return valid;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SearchForBerryBushGoal(0.8, 8));
        this.f_21345_.m_25352_(5, (Goal)new EatFoliageBelowGoal(50, false, CONSUMABLE_FRUIT_BUSH));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7, 0.005f));
        this.f_21345_.m_25352_(7, (Goal)new CurtsyGoal(Player.class, 12.0f, 0.02f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANTLER_TYPE, (Object)((byte)AntlerType.WHITE.ordinal()));
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(PERFORMING_CURTSY, (Object)false);
        this.f_19804_.m_135372_(EATING, (Object)false);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setAntlerType(AntlerType.getFromId(compound.m_128445_(ANTLER_TYPE.getKey())));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_(ANTLER_TYPE.getKey(), (byte)this.getAntlerType().ordinal());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag dataTag) {
        List<Object> types = new ArrayList();
        for (AntlerType type : AntlerType.values()) {
            if (!this.m_9236_().m_204166_(this.m_20183_()).m_203656_(type.tag)) continue;
            types.add((Object)type);
        }
        if (types.isEmpty()) {
            types = Arrays.asList(AntlerType.values());
        }
        this.setAntlerType((AntlerType)((Object)Util.m_214621_(types, (RandomSource)this.f_19796_)));
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.flickerO = this.flicker;
            float targetFlicker = this.f_19796_.m_188501_();
            targetFlicker *= targetFlicker;
            this.flicker += (targetFlicker - this.flicker) * 0.5f;
            if (this.swingTimer > 0) {
                --this.swingTimer;
            }
            if (this.isCharging()) {
                this.m_5618_(this.m_6080_());
                this.m_146922_(this.m_6080_());
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean hit;
        float damage = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        if (this.isCharging()) {
            damage *= 2.0f;
        }
        if ((hit = entity.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), damage)) && !this.m_6162_() && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, this.isCharging() ? 200 : 40, 0, false, true));
        }
        if (!this.isCharging()) {
            this.m_9236_().m_7605_((Entity)this, (byte)4);
        }
        return hit;
    }

    public AntlerType getAntlerType() {
        return AntlerType.getFromId((Byte)this.f_19804_.m_135370_(ANTLER_TYPE));
    }

    public void setAntlerType(AntlerType type) {
        this.f_19804_.m_135381_(ANTLER_TYPE, (Object)((byte)type.ordinal()));
    }

    public boolean isPerformingCurtsy() {
        return (Boolean)this.f_19804_.m_135370_(PERFORMING_CURTSY);
    }

    public void setPerformingCurtsy(boolean flag) {
        this.f_19804_.m_135381_(PERFORMING_CURTSY, (Object)flag);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean flag) {
        this.f_19804_.m_135381_(CHARGING, (Object)flag);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public void setEating(boolean flag) {
        this.f_19804_.m_135381_(EATING, (Object)flag);
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return super.m_142535_(fallDistance, multiplier * 0.2f, source);
    }

    public int m_213860_() {
        int base = 4;
        if (!this.m_6162_()) {
            base += this.f_19796_.m_188503_(3);
        }
        return base;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) ? 10.0f : super.m_5610_(pos, level);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(MnItemTags.UNSTABLE_FRUITS);
    }

    private void consumeFruit() {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200, 0, true, true));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 400, 0, true, true));
        this.m_5496_((SoundEvent)MnSoundEvents.ENTITY_NIGHTSTAG_EAT.get(), this.m_6121_(), this.m_6100_());
        this.m_5634_(2.0f);
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack stack) {
        if (this.m_6898_(stack)) {
            this.teaseTime = 200;
            this.consumeFruit();
        }
        super.m_142075_(player, hand, stack);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MnSoundEvents.ENTITY_NIGHTSTAG_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MnSoundEvents.ENTITY_NIGHTSTAG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MnSoundEvents.ENTITY_NIGHTSTAG_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)MnSoundEvents.ENTITY_NIGHTSTAG_STEP.get(), 0.15f, 1.0f);
    }

    public int m_8100_() {
        return 200;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        NightstagEntity child = (NightstagEntity)((EntityType)MnEntityTypes.NIGHTSTAG.get()).m_20615_((Level)level);
        if (child != null) {
            child.m_146762_(-24000);
            if (otherParent instanceof NightstagEntity) {
                NightstagEntity ns = (NightstagEntity)otherParent;
                child.setAntlerType(ns.getAntlerType());
            }
        }
        return child;
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.swingTimer = 17;
        } else {
            super.m_7822_(id);
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() - (double)0.3f, (double)(this.m_20205_() * 0.6f));
    }

    public void m_8035_() {
        this.m_5634_(1.0f);
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_276093_(MnDamageTypes.BLADESHROOM);
    }

    private float getIdleOffset() {
        return (float)(this.m_19879_() % 5) * 0.1f;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animate)});
    }

    private PlayState animate(AnimationState<NightstagEntity> e) {
        AnimationController controller = e.getController();
        if (this.isCharging()) {
            controller.setAnimation(RawAnimation.begin().thenPlay("ChargeStart").thenLoop("Charge"));
        } else if (AnimationHelper.isCurrentlyAnimating((AnimationController<? extends GeoAnimatable>)controller, "Charge", "ChargeStop")) {
            controller.setAnimation(RawAnimation.begin().thenPlay("ChargeStop").thenLoop("Idle"));
        } else if (this.swingTimer > 0) {
            controller.setAnimation(RawAnimation.begin().thenPlay("Attack").thenLoop("Idle"));
        } else if (this.isEating()) {
            controller.setAnimation(RawAnimation.begin().thenPlay("Eat").thenLoop("Idle"));
        } else if (this.isPerformingCurtsy()) {
            controller.setAnimation(RawAnimation.begin().thenPlay("Curtsy").thenLoop("Idle"));
        } else {
            controller.setAnimation(RawAnimation.begin().thenLoop("Idle"));
        }
        controller.setAnimationSpeed((double)(1.0f + (AnimationHelper.isCurrentlyAnimating((AnimationController<? extends GeoAnimatable>)controller, "Idle") ? (this.m_6162_() ? 1.0f : 0.0f) + this.getIdleOffset() : 0.0f)));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }

    public static boolean spawnConditions(EntityType<? extends Animal> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) && pos.m_123342_() >= level.m_5736_();
    }

    protected class ChargeAttackGoal
    extends Goal {
        private final double speed;
        private final int duration;
        private final float chance;
        protected int tickCounter;
        protected LivingEntity target;
        protected Vec3 direction;
        protected int chargeTime;

        protected ChargeAttackGoal(double speed, int duration, float chance) {
            this.speed = speed;
            this.duration = duration;
            this.chance = chance;
            this.tickCounter = 0;
            this.chargeTime = duration / 18;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (NightstagEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL || NightstagEntity.this.m_6162_()) {
                return false;
            }
            this.target = NightstagEntity.this.m_5448_();
            if (!NightstagEntity.this.m_6162_() && NightstagEntity.this.m_20096_() && this.target != null && this.target.m_6084_() && this.target.m_20186_() <= NightstagEntity.this.m_20186_() && NightstagEntity.this.m_217043_().m_188501_() < this.chance) {
                double distance = NightstagEntity.this.m_20280_((Entity)this.target);
                return distance > 50.0 && distance < 75.0 && NightstagEntity.this.m_21574_().m_148306_((Entity)this.target);
            }
            return false;
        }

        public void m_8056_() {
            this.tickCounter = 0;
            NightstagEntity.this.m_21566_().m_6849_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_(), this.speed);
            NightstagEntity.this.setCharging(true);
        }

        public void m_8041_() {
            this.tickCounter = 0;
            this.target = null;
            this.direction = null;
            NightstagEntity.this.setCharging(false);
        }

        public boolean m_8045_() {
            return this.tickCounter <= this.chargeTime || this.tickCounter < this.duration && !NightstagEntity.this.f_19862_;
        }

        public void m_8037_() {
            ++this.tickCounter;
            if (this.tickCounter == this.chargeTime) {
                this.direction = NightstagEntity.this.m_20182_().m_82549_(this.target.m_20182_().m_82546_(NightstagEntity.this.m_20182_()).m_82490_(1.5));
            } else if (this.direction != null) {
                List hitEntities = NightstagEntity.this.m_9236_().m_6443_(LivingEntity.class, NightstagEntity.this.m_20191_().m_82400_(0.2), p -> !(p instanceof NightstagEntity));
                if (!hitEntities.isEmpty()) {
                    for (LivingEntity hitEntity : hitEntities) {
                        if (!NightstagEntity.this.m_7327_((Entity)this.target)) continue;
                        hitEntity.m_147240_(1.0, (double)Mth.m_14031_((float)(NightstagEntity.this.m_146909_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(NightstagEntity.this.m_146909_() * ((float)Math.PI / 180)))));
                        if (!(hitEntity instanceof ServerPlayer)) continue;
                        ServerPlayer sp = (ServerPlayer)hitEntity;
                        sp.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)hitEntity));
                        hitEntity.f_19864_ = false;
                        Vec3 motion = NightstagEntity.this.m_20184_();
                        hitEntity.m_20256_(new Vec3(motion.f_82479_ * 2.0, 2.0, motion.f_82481_ * 2.0));
                    }
                    this.tickCounter = this.duration;
                } else if (NightstagEntity.this.m_20275_(this.direction.f_82479_, this.direction.f_82480_, this.direction.f_82481_) < 2.0) {
                    this.tickCounter = this.duration;
                } else {
                    NightstagEntity.this.m_21566_().m_6849_(this.direction.f_82479_, this.direction.f_82480_, this.direction.f_82481_, this.speed * 2.0);
                }
            }
            if (this.direction != null) {
                NightstagEntity.this.m_21563_().m_24950_(this.direction.f_82479_, this.direction.f_82480_, this.direction.f_82481_, 0.0f, 0.0f);
            } else {
                NightstagEntity.this.m_21563_().m_24960_((Entity)this.target, 20.0f, (float)NightstagEntity.this.m_8132_());
            }
        }
    }

    protected class SearchForBerryBushGoal
    extends MoveToBlockGoal {
        protected SearchForBerryBushGoal(double speedModifier, int searchRange) {
            super((PathfinderMob)NightstagEntity.this, speedModifier, searchRange, 2);
        }

        public void m_8037_() {
            super.m_8037_();
            if (Mth.m_14116_((float)((float)this.f_25598_.m_20238_(Vec3.m_82539_((Vec3i)this.f_25602_)))) < 2.5f) {
                this.f_25598_.m_21566_().m_6849_((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_() + 0.5, this.f_25599_);
            }
            this.f_25598_.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.f_25602_));
        }

        public double m_8052_() {
            return 0.3f;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            return CONSUMABLE_FRUIT_BUSH.test(level.m_8055_(pos));
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.f_25598_.m_20183_().equals((Object)this.f_25602_)) {
                this.f_25598_.m_21446_(this.f_25602_, 20);
            }
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.m_6465_((LevelReader)this.f_25598_.m_9236_(), this.f_25598_.m_20183_());
        }
    }

    protected class EatFoliageBelowGoal
    extends Goal {
        private final Predicate<BlockState> eatPredicate;
        protected final int maxDuration;
        protected int duration;

        protected EatFoliageBelowGoal(int duration, boolean vanillaBehavior, Predicate<BlockState> eatPredicate) {
            this.eatPredicate = vanillaBehavior ? eatPredicate.or(p -> p.m_60734_() == Blocks.f_50440_) : eatPredicate;
            this.maxDuration = duration;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            BlockPos currentPos = NightstagEntity.this.m_20183_();
            if (currentPos.equals((Object)NightstagEntity.this.m_21534_()) && this.eatPredicate.test(NightstagEntity.this.m_9236_().m_8055_(currentPos))) {
                return true;
            }
            if (NightstagEntity.this.isEating() || NightstagEntity.this.m_217043_().m_188503_(NightstagEntity.this.m_6162_() ? 50 : 500) != 0) {
                return false;
            }
            if (this.eatPredicate.test(NightstagEntity.this.m_9236_().m_8055_(currentPos))) {
                return true;
            }
            Block belowBlock = NightstagEntity.this.m_9236_().m_8055_(currentPos.m_7495_()).m_60734_();
            return belowBlock == Blocks.f_50440_ || belowBlock == MnBlocks.NIGHT_GRASS_BLOCK.get();
        }

        public void m_8056_() {
            this.duration = this.maxDuration;
            NightstagEntity.this.setEating(true);
            NightstagEntity.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            NightstagEntity.this.setEating(false);
        }

        public boolean m_8045_() {
            return this.duration > 0;
        }

        public void m_8037_() {
            if (this.duration == 10) {
                BlockPos currentPos = NightstagEntity.this.m_20183_();
                BlockState currentState = NightstagEntity.this.m_9236_().m_8055_(currentPos);
                if (this.eatPredicate.test(currentState)) {
                    if (ForgeEventFactory.getMobGriefingEvent((Level)NightstagEntity.this.m_9236_(), (Entity)NightstagEntity.this)) {
                        this.eatPlant(currentState, currentPos);
                    }
                    NightstagEntity.this.m_8035_();
                } else {
                    BlockPos belowPos = currentPos.m_7495_();
                    BlockState belowState = NightstagEntity.this.m_9236_().m_8055_(belowPos);
                    Block belowBlock = belowState.m_60734_();
                    if (belowBlock == Blocks.f_50440_ || belowBlock == MnBlocks.NIGHT_GRASS_BLOCK.get()) {
                        if (ForgeEventFactory.getMobGriefingEvent((Level)NightstagEntity.this.m_9236_(), (Entity)NightstagEntity.this)) {
                            NightstagEntity.this.m_9236_().m_46796_(2001, belowPos, Block.m_49956_((BlockState)belowState));
                            NightstagEntity.this.m_9236_().m_7731_(belowPos, (belowBlock == Blocks.f_50440_ ? Blocks.f_50493_ : (Block)MnBlocks.NIGHT_DIRT.get()).m_49966_(), 2);
                        }
                        NightstagEntity.this.m_8035_();
                    }
                }
            }
            if (this.duration > 0) {
                --this.duration;
            }
        }

        public boolean m_183429_() {
            return true;
        }

        protected void eatPlant(BlockState state, BlockPos pos) {
            NightstagEntity.this.m_9236_().m_7731_(pos, (BlockState)((UnstableBushBlock)MnBlocks.UNSTABLE_BUSH.get()).m_49966_().m_61124_((Property)UnstableBushBlock.STAGE, (Comparable)Integer.valueOf(4)), 2);
            NightstagEntity.this.m_9236_().m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (NightstagEntity.this.m_6162_()) {
                NightstagEntity.this.m_146762_(Math.min(NightstagEntity.this.m_146764_() + 5000, 0));
            }
            NightstagEntity.this.consumeFruit();
            NightstagEntity.this.m_147271_();
        }
    }

    protected class CurtsyGoal
    extends LookAtPlayerGoal {
        private int waitTime;

        CurtsyGoal(Class<? extends LivingEntity> watchTargetClass, float maxDistance, float chance) {
            super((Mob)NightstagEntity.this, watchTargetClass, maxDistance, chance);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void m_8056_() {
            super.m_8056_();
            if (!NightstagEntity.this.m_6162_() && NightstagEntity.this.m_5448_() == null && NightstagEntity.this.m_217043_().m_188501_() < 0.1f) {
                ServerPlayer sp;
                this.waitTime = 80;
                NightstagEntity.this.setPerformingCurtsy(true);
                Entity entity = this.f_25513_;
                if (entity instanceof ServerPlayer && !((sp = (ServerPlayer)entity) instanceof FakePlayer)) {
                    MnCriteriaTriggers.RECIEVE_NIGHTSTAG_CURTSY.trigger(sp, NightstagEntity.this.getAntlerType());
                }
            }
        }

        public boolean m_8045_() {
            return super.m_8045_() || this.waitTime > 0;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.waitTime > 0) {
                --this.waitTime;
            }
        }

        public void m_8041_() {
            super.m_8041_();
            NightstagEntity.this.setPerformingCurtsy(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_6767_() {
            return this.waitTime <= 0;
        }
    }

    public static enum AntlerType {
        RED(0xFF6666, MnBiomeTags.HAS_RED_NIGHTSTAG),
        GREEN(0xBBFF99, MnBiomeTags.HAS_GREEN_NIGHTSTAG),
        CYAN(0x99FFFF, MnBiomeTags.HAS_CYAN_NIGHTSTAG),
        ORANGE(16755328, MnBiomeTags.HAS_ORANGE_NIGHTSTAG),
        PINK(14916828, MnBiomeTags.HAS_PINK_NIGHTSTAG),
        LIGHT_PINK(14122192, MnBiomeTags.HAS_LIGHT_PINK_NIGHTSTAG),
        WHITE(0xF2F2F2, MnBiomeTags.HAS_WHITE_NIGHTSTAG),
        BLUE(0x6699FF, MnBiomeTags.HAS_BLUE_NIGHTSTAG),
        PURPLE(8409526, MnBiomeTags.HAS_PURPLE_NIGHTSTAG);

        public final int color;
        public final TagKey<Biome> tag;
        private static AntlerType[] values;

        private AntlerType(int color, TagKey<Biome> tag) {
            this.color = color;
            this.tag = tag;
        }

        public static AntlerType getFromId(byte id) {
            if (values == null) {
                values = AntlerType.values();
            }
            try {
                return values[id];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return WHITE;
            }
        }
    }
}

