/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public abstract class TraditionalAgeableMob
extends AgeableMob {
    private static final EntityDataAccessor<Byte> DATA_TRADITIONAL_AGE = SynchedEntityData.m_135353_(TraditionalAgeableMob.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected final byte maxTraditionalAge;
    private final int ticksPerTraditionalAge;
    private byte traditionalAge;

    protected TraditionalAgeableMob(EntityType<? extends AgeableMob> entityType, Level level, @Range(from=0L, to=255L) int maxTraditionalAge, int ticksPerTraditionalAge) {
        super(entityType, level);
        if (maxTraditionalAge < 0 || maxTraditionalAge > 255) {
            throw new IllegalArgumentException("A traditional ageable mob must have a maximum age within the range [0,255]");
        }
        if (ticksPerTraditionalAge <= 0) {
            throw new IllegalArgumentException("A traditional ageable mob cannot have less than or equal to zero ticks per age!");
        }
        this.maxTraditionalAge = (byte)maxTraditionalAge;
        this.ticksPerTraditionalAge = ticksPerTraditionalAge;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        SpawnGroupData data = super.m_6518_(serverLevelAccessor, difficultyInstance, spawnType, groupData, compoundTag);
        if (this.m_6162_()) {
            this.m_6863_(true);
        }
        return data;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().f_46443_) {
            this.recalculateTraditionalAge();
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_TRADITIONAL_AGE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TRADITIONAL_AGE, (Object)0);
    }

    @Deprecated
    public int m_146764_() {
        return super.m_146764_();
    }

    public int ticksUntilNextTraditionalAge() {
        return -this.m_146764_() % this.ticksPerTraditionalAge;
    }

    @Deprecated
    public void m_146740_(int amount, boolean forced) {
        super.m_146740_(amount, forced);
    }

    @Deprecated
    public void m_146758_(int addToAge) {
        super.m_146758_(addToAge);
    }

    @Deprecated
    public void m_146762_(int age) {
        super.m_146762_(age);
        this.recalculateTraditionalAge();
    }

    public byte getTraditionalAge() {
        return this.m_9236_().f_46443_ ? (Byte)this.f_19804_.m_135370_(DATA_TRADITIONAL_AGE) : this.traditionalAge;
    }

    public byte getMaxTraditionalAge() {
        return this.maxTraditionalAge;
    }

    public void traditionalAgeUp(int addToTraditionalAge) {
        this.setTraditionalAge(this.getTraditionalAge() + addToTraditionalAge);
    }

    public void setTraditionalAge(int traditionalAge) {
        traditionalAge = Mth.m_14045_((int)traditionalAge, (int)0, (int)this.maxTraditionalAge);
        this.m_146762_(this.ticksPerTraditionalAge * (traditionalAge - this.maxTraditionalAge));
    }

    protected final void recalculateTraditionalAge() {
        byte newTraditionalAge;
        int age = this.m_146764_();
        byte oldTraditionalAge = this.getTraditionalAge();
        if (oldTraditionalAge != (newTraditionalAge = (byte)(age >= 0 ? this.maxTraditionalAge : Math.min(age / this.ticksPerTraditionalAge - (age % this.ticksPerTraditionalAge != 0 ? 1 : 0) + this.maxTraditionalAge, this.maxTraditionalAge)))) {
            this.traditionalAge = newTraditionalAge;
            this.f_19804_.m_135381_(DATA_TRADITIONAL_AGE, (Object)newTraditionalAge);
            if (!this.m_9236_().f_46443_) {
                this.onTraditionalAgeChange(newTraditionalAge);
            }
        }
    }

    protected abstract void onTraditionalAgeChange(byte var1);

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsBaby", this.m_6162_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_146764_() >= 0 && compound.m_128471_("IsBaby")) {
            this.m_6863_(true);
        }
    }

    @Deprecated
    protected void m_30232_() {
        super.m_30232_();
    }

    public void m_6863_(boolean baby) {
        this.setTraditionalAge(baby ? (byte)0 : this.maxTraditionalAge);
    }
}

