/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class TeleportTowardsAttackTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT)});
    protected Vec3 destination = null;
    protected BiFunction<E, LivingEntity, Float> distanceTowards = (e, target) -> Float.valueOf(16.0f);
    protected double maxRandomOffset = 8.0;
    protected double minimumDistToTarget = 0.0;

    public TeleportTowardsAttackTarget<E> distTowards(BiFunction<E, LivingEntity, Float> distTowards) {
        this.distanceTowards = distTowards;
        return this;
    }

    public TeleportTowardsAttackTarget<E> maxRandomOffset(double maxRandomOffset) {
        this.maxRandomOffset = maxRandomOffset;
        return this;
    }

    public TeleportTowardsAttackTarget<E> minimumDistToTarget(double minimumDistToTarget) {
        this.minimumDistToTarget = minimumDistToTarget;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean m_6114_(ServerLevel level, E entity) {
        LivingEntity target = (LivingEntity)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26372_);
        Vec3 vectorToTarget = new Vec3(entity.m_20185_() - target.m_20185_(), entity.m_20227_(0.5) - target.m_20188_(), entity.m_20189_() - target.m_20189_());
        if ((double)Mth.m_14154_((float)((float)vectorToTarget.m_82553_())) > this.minimumDistToTarget) {
            vectorToTarget = vectorToTarget.m_82541_();
            double distTowards = this.distanceTowards.apply(entity, target).floatValue();
            double x = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * this.maxRandomOffset - vectorToTarget.f_82479_ * distTowards;
            double y = entity.m_20186_() + ((double)entity.m_217043_().m_188503_((int)this.maxRandomOffset * 2) - this.maxRandomOffset) - vectorToTarget.f_82480_ * distTowards;
            double z = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * this.maxRandomOffset - vectorToTarget.f_82481_ * distTowards;
            return this.shouldTeleport(entity, x, y, z);
        }
        return false;
    }

    private boolean shouldTeleport(E entity, double x, double y, double z) {
        EntityTeleportEvent.EnderEntity event;
        BlockPos.MutableBlockPos destinationPos = new BlockPos.MutableBlockPos(x, y, z);
        while (destinationPos.m_123342_() > entity.m_9236_().m_141937_() && !entity.m_9236_().m_8055_((BlockPos)destinationPos).m_280555_()) {
            destinationPos.m_122173_(Direction.DOWN);
        }
        BlockState destinationBlockState = entity.m_9236_().m_8055_((BlockPos)destinationPos);
        boolean destinationSolid = destinationBlockState.m_280555_();
        boolean destinationWater = destinationBlockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (destinationSolid && !destinationWater && !(event = ForgeEventFactory.onEnderTeleport(entity, (double)x, (double)y, (double)z)).isCanceled()) {
            this.destination = event.getTarget();
            if (entity.m_20984_(this.destination.m_7096_(), this.destination.m_7098_(), this.destination.m_7094_(), true)) {
                entity.m_9236_().m_214171_(GameEvent.f_238175_, entity.m_20182_(), GameEvent.Context.m_223717_(entity));
                return true;
            }
        }
        return false;
    }
}

