/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.config;

import com.crypticmushroom.minecraft.midnight.data.i18n.MnI18n;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class MidnightConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Client CLIENT;
    public static final Common COMMON;
    public static final Server SERVER;

    static {
        ConfigSpecBuilder clientSpecBuilder = new ConfigSpecBuilder();
        CLIENT = new Client(clientSpecBuilder);
        CLIENT_SPEC = clientSpecBuilder.build();
        ConfigSpecBuilder commonSpecBuilder = new ConfigSpecBuilder();
        COMMON = new Common(commonSpecBuilder);
        COMMON_SPEC = commonSpecBuilder.build();
        ConfigSpecBuilder serverSpecBuilder = new ConfigSpecBuilder();
        SERVER = new Server(serverSpecBuilder);
        SERVER_SPEC = serverSpecBuilder.build();
    }

    private static class ConfigSpecBuilder
    extends ForgeConfigSpec.Builder {
        private ConfigSpecBuilder() {
        }

        public ConfigSpecBuilder comment(String translationKey, String name, String comment) {
            String key = MnI18n.stringKey("midnight.configgui." + translationKey, name);
            MnI18n.stringKey(key + ".tooltip", comment);
            this.translation(key);
            return this.comment(comment);
        }

        public ConfigSpecBuilder comment(String translationKey, String name, String ... comment) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < comment.length; ++i) {
                stringBuilder.append(comment[i]);
                if (i >= comment.length - 1) continue;
                stringBuilder.append("\n");
            }
            String key = MnI18n.stringKey("midnight.configgui." + translationKey, name);
            MnI18n.stringKey(key + ".tooltip", stringBuilder.toString());
            this.translation(key);
            return this.comment(comment);
        }

        @Deprecated
        public ConfigSpecBuilder comment(String comment) {
            return (ConfigSpecBuilder)super.comment(comment);
        }

        @Deprecated
        public ConfigSpecBuilder comment(String ... comment) {
            return (ConfigSpecBuilder)super.comment(comment);
        }

        @Deprecated
        public ConfigSpecBuilder translation(String translationKey) {
            return (ConfigSpecBuilder)super.translation(translationKey);
        }

        public ConfigSpecBuilder worldRestart() {
            return (ConfigSpecBuilder)super.worldRestart();
        }

        public ConfigSpecBuilder push(String path) {
            return (ConfigSpecBuilder)super.push(path);
        }

        public ConfigSpecBuilder push(List<String> path) {
            return (ConfigSpecBuilder)super.push(path);
        }

        public ConfigSpecBuilder pop() {
            return (ConfigSpecBuilder)super.pop();
        }

        public ConfigSpecBuilder pop(int count) {
            return (ConfigSpecBuilder)super.pop(count);
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> limitBrightness;

        private Client(ConfigSpecBuilder builder) {
            this.limitBrightness = builder.comment("client.limitBrightness", "Limit Brightness", "Limits gamma/brightness in The Midnight by 50%.").define("limitBrightness", true);
        }
    }

    public static class Common {
        private Common(ConfigSpecBuilder builder) {
        }
    }

    public static class Server {
        private Server(ConfigSpecBuilder builder) {
        }
    }
}

