/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.capability.entity;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.capability.CapabilityProvider;
import com.crypticmushroom.minecraft.midnight.common.capability.IPersistentCapability;
import com.crypticmushroom.minecraft.midnight.common.capability.ISyncedCapability;
import com.crypticmushroom.minecraft.midnight.common.capability.entity.BaseMnEntity;
import com.crypticmushroom.minecraft.midnight.common.network.MnNetwork;
import com.crypticmushroom.minecraft.midnight.common.network.capability.MnPlayerPacket;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public final class MnPlayer
implements BaseMnEntity<Player>,
IPersistentCapability<MnPlayer>,
ISyncedCapability {
    public static final Capability<MnPlayer> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<MnPlayer>(){});
    private final Player player;

    public static void attach(AttachCapabilitiesEvent<? extends Entity> event) {
        Object object = event.getObject();
        if (!(object instanceof Player)) {
            return;
        }
        Player entity = (Player)object;
        event.addCapability(Midnight.id("player"), new CapabilityProvider<MnPlayer>(new MnPlayer(entity)));
    }

    private MnPlayer(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    @Deprecated
    public Player getEntity() {
        return this.getPlayer();
    }

    private void commonTick(LivingEvent.LivingTickEvent event) {
    }

    public void clientTick(LivingEvent.LivingTickEvent event) {
        this.commonTick(event);
    }

    public void serverTick(LivingEvent.LivingTickEvent event) {
        this.commonTick(event);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
    }

    @Override
    public void syncDataToClient() {
        if (this.getPlayer().m_9236_().f_46443_) {
            return;
        }
        MnPlayerPacket packet = new MnPlayerPacket(this);
        MnNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getPlayer), (Object)packet);
    }

    @Override
    public Capability<MnPlayer> getDefaultInstance() {
        return INSTANCE;
    }

    public static boolean isPresent(Player player) {
        if (player == null) {
            return false;
        }
        return player.getCapability(INSTANCE).resolve().isPresent();
    }

    public static void ifPresent(Player player, Consumer<MnPlayer> action) {
        if (player == null) {
            return;
        }
        player.getCapability(INSTANCE).resolve().ifPresent(action);
    }

    public static <R> R getIfPresent(Player player, Function<MnPlayer, R> action, Supplier<@Nullable R> orElse) {
        Optional capability;
        if (player != null && (capability = player.getCapability(INSTANCE).resolve()).isPresent()) {
            return action.apply((MnPlayer)capability.get());
        }
        return orElse.get();
    }
}

