/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface IMnWaterLoggable
extends BucketPickup,
LiquidBlockContainer {
    private boolean canPlaceLiquid(BlockState blockState, Fluid fluid) {
        return (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    default public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return this.canPlaceLiquid(state, fluid);
    }

    default public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!this.canPlaceLiquid(state, fluidState.m_76152_())) {
            return false;
        }
        if (!level.m_5776_()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), 3);
            Fluid fluid = fluidState.m_76152_();
            level.m_186469_(pos, fluid, fluid.m_6718_((LevelReader)level));
        }
        return true;
    }

    default public Fluid takeLiquid(LevelAccessor level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.f_76193_;
        }
        return Fluids.f_76191_;
    }

    default public void tickFluid(LevelAccessor level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            Fluid fluid = level.m_6425_(pos).m_76152_();
            level.m_186469_(pos, fluid, fluid.m_6718_((LevelReader)level));
        }
    }

    default public BlockState waterlog(BlockState state, Level level, BlockPos pos) {
        if (state == null) {
            return null;
        }
        boolean waterlogged = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlogged));
    }

    default public BlockState waterlog(BlockState state, BlockPlaceContext context) {
        return this.waterlog(state, context.m_43725_(), context.m_8083_());
    }

    default public FluidState fluidState(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76145_() : Fluids.f_76191_.m_76145_();
    }

    default public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? new ItemStack((ItemLike)this.fluidState(state).m_76152_().m_6859_()) : ItemStack.f_41583_;
    }

    default public Optional<SoundEvent> m_142298_() {
        return Optional.of(SoundEvents.f_11781_);
    }
}

