/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.type;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.registry.util.Lazy;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.common.util.ForgeSoundType;
import org.jetbrains.annotations.ApiStatus;

public final class MnBlockSetTypes {
    private static final Set<LazyBlockSetType> ALL = new HashSet<LazyBlockSetType>();
    static boolean forceInitialized = false;
    public static final LazyBlockSetType NIGHTSTONE = MnBlockSetTypes.register("nightstone", true, () -> SoundType.f_56742_, () -> SoundEvents.f_12055_, () -> SoundEvents.f_12056_, () -> SoundEvents.f_12011_, () -> SoundEvents.f_12012_, () -> SoundEvents.f_12448_, () -> SoundEvents.f_12449_, () -> SoundEvents.f_12443_, () -> SoundEvents.f_12444_);
    public static final LazyBlockSetType TRENCHSTONE = MnBlockSetTypes.register("trenchstone", false, () -> SoundType.f_56742_, () -> SoundEvents.f_12055_, () -> SoundEvents.f_12056_, () -> SoundEvents.f_12011_, () -> SoundEvents.f_12012_, () -> SoundEvents.f_12448_, () -> SoundEvents.f_12449_, () -> SoundEvents.f_12443_, () -> SoundEvents.f_12444_);
    public static final LazyBlockSetType NAGRILITE = MnBlockSetTypes.register("nagrilite", false, () -> SoundType.f_56743_, () -> SoundEvents.f_12055_, () -> SoundEvents.f_12056_, () -> SoundEvents.f_12011_, () -> SoundEvents.f_12012_, () -> SoundEvents.f_12066_, () -> SoundEvents.f_12067_, () -> SoundEvents.f_12443_, () -> SoundEvents.f_12444_);
    public static final LazyBlockSetType TENEBRUM = MnBlockSetTypes.register("tenebrum", false, () -> SoundType.f_56743_, () -> SoundEvents.f_12055_, () -> SoundEvents.f_12056_, () -> SoundEvents.f_12011_, () -> SoundEvents.f_12012_, () -> SoundEvents.f_12066_, () -> SoundEvents.f_12067_, () -> SoundEvents.f_12443_, () -> SoundEvents.f_12444_);
    public static final LazyBlockSetType SHADOWROOT = MnBlockSetTypes.register("shadowroot");
    public static final LazyBlockSetType DARK_WILLOW = MnBlockSetTypes.register("dark_willow");
    public static final LazyBlockSetType DECAYED_WOOD = MnBlockSetTypes.register("decayed_wood");
    public static final LazyBlockSetType MANGLEWOOD = MnBlockSetTypes.register("manglewood");
    public static final LazyBlockSetType NIGHTSHROOM = MnBlockSetTypes.register("nightshroom");
    public static final LazyBlockSetType DEWSHROOM = MnBlockSetTypes.register("dewshroom");
    public static final LazyBlockSetType VIRIDSHROOM = MnBlockSetTypes.register("viridshroom");
    public static final LazyBlockSetType MOONSHROOM = MnBlockSetTypes.register("moonshroom");
    public static final LazyBlockSetType BOGSHROOM = MnBlockSetTypes.register("bogshroom");

    private static LazyBlockSetType register(String name) {
        LazyBlockSetType type = LazyBlockSetType.of(name, () -> BlockSetType.m_272115_((BlockSetType)new BlockSetType(Midnight.idStr(name))));
        ALL.add(type);
        return type;
    }

    private static LazyBlockSetType register(String name, boolean canOpenByHand, Supplier<? extends SoundType> soundType, Supplier<? extends SoundEvent> doorClose, Supplier<? extends SoundEvent> doorOpen, Supplier<? extends SoundEvent> trapdoorClose, Supplier<? extends SoundEvent> trapdoorOpen, Supplier<? extends SoundEvent> pressurePlateClickOff, Supplier<? extends SoundEvent> pressurePlateClickOn, Supplier<? extends SoundEvent> buttonClickOff, Supplier<? extends SoundEvent> buttonClickOn) {
        LazyBlockSetType type = LazyBlockSetType.of(name, () -> BlockSetType.m_272115_((BlockSetType)new BlockSetType(Midnight.idStr(name), canOpenByHand, (SoundType)soundType.get(), (SoundEvent)doorClose.get(), (SoundEvent)doorOpen.get(), (SoundEvent)trapdoorClose.get(), (SoundEvent)trapdoorOpen.get(), (SoundEvent)pressurePlateClickOff.get(), (SoundEvent)pressurePlateClickOn.get(), (SoundEvent)buttonClickOff.get(), (SoundEvent)buttonClickOn.get())));
        ALL.add(type);
        return type;
    }

    private static LazyBlockSetType register(String name, boolean canOpenByHand, ForgeSoundType soundType, Supplier<? extends SoundEvent> doorClose, Supplier<? extends SoundEvent> doorOpen, Supplier<? extends SoundEvent> trapdoorClose, Supplier<? extends SoundEvent> trapdoorOpen, Supplier<? extends SoundEvent> pressurePlateClickOff, Supplier<? extends SoundEvent> pressurePlateClickOn, Supplier<? extends SoundEvent> buttonClickOff, Supplier<? extends SoundEvent> buttonClickOn) {
        LazyBlockSetType type = LazyBlockSetType.of(name, () -> BlockSetType.m_272115_((BlockSetType)new BlockSetType(Midnight.idStr(name), canOpenByHand, (SoundType)soundType, (SoundEvent)doorClose.get(), (SoundEvent)doorOpen.get(), (SoundEvent)trapdoorClose.get(), (SoundEvent)trapdoorOpen.get(), (SoundEvent)pressurePlateClickOff.get(), (SoundEvent)pressurePlateClickOn.get(), (SoundEvent)buttonClickOff.get(), (SoundEvent)buttonClickOn.get())));
        ALL.add(type);
        return type;
    }

    @ApiStatus.Internal
    public static void forceInit() {
        if (!forceInitialized) {
            ALL.forEach(Supplier::get);
            forceInitialized = true;
        }
    }

    public static class LazyBlockSetType
    extends Lazy.Fast<BlockSetType> {
        public final String name;

        public static LazyBlockSetType of(String name, Supplier<BlockSetType> supplier) {
            return new LazyBlockSetType(name, supplier);
        }

        protected LazyBlockSetType(String name, Supplier<BlockSetType> supplier) {
            super(supplier);
            this.name = name;
        }
    }
}

