/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.plant;

import com.crypticmushroom.minecraft.midnight.common.block.plant.UpwardBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.util.IMnWaterLoggable;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnVoxelShapes;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class NightReedBlock
extends UpwardBushBlock
implements BonemealableBlock,
IMnWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    protected final TagKey<Block> noWaterPlantableBlocks;

    public NightReedBlock(BlockBehaviour.Properties properties, TagKey<Block> noWaterPlantableBlocks) {
        super(properties, MnBlockTags.SOILS, false, MnVoxelShapes.BOX_13_16, MnVoxelShapes.BOX_13_11);
        this.noWaterPlantableBlocks = noWaterPlantableBlocks;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, AGE});
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        this.tickFluid(level, currentPos, state);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.waterlog(super.m_5573_(context), context);
    }

    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos down = pos.m_7495_();
        BlockState stateDown = level.m_8055_(down);
        if (!stateDown.m_60713_((Block)this) && !this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
            return;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 15) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        } else {
            state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
            level.m_46597_(pos, state);
            this.growUp((Level)level, pos, state);
        }
    }

    private boolean canGrowHigher(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.m_122190_((Vec3i)pos);
        int h = 0;
        while (mutablePos.m_123342_() > 0) {
            BlockState state = level.m_8055_((BlockPos)mutablePos);
            if (!state.m_60713_((Block)this)) {
                return true;
            }
            h = state.m_60819_().m_76178_() ? (h += 3) : ++h;
            if (h >= 12) {
                return false;
            }
            mutablePos.m_122173_(Direction.DOWN);
        }
        return false;
    }

    private void growUp(Level level, BlockPos pos, BlockState state) {
        BlockPos up = pos.m_7494_();
        BlockState stateUp = level.m_8055_(up);
        if ((stateUp.m_60795_() || stateUp.m_60819_().m_205070_(FluidTags.f_13131_)) && this.canGrowHigher(level, pos)) {
            level.m_46597_(up, this.waterlog((BlockState)this.m_49966_().m_61124_((Property)END, (Comparable)Boolean.valueOf(true)), level, up));
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)END, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.m_204336_(this.noWaterPlantableBlocks)) {
            return true;
        }
        if (super.m_6266_(state, level, pos)) {
            if (level.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_) {
                return true;
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (level.m_6425_(pos.m_121945_(dir)).m_76152_() != Fluids.f_76193_) continue;
                return true;
            }
        }
        return false;
    }

    public int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 15;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growReedSprout((Level)level, pos, state);
    }

    public void growReedSprout(Level level, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(level);
        if (i > (j = 15)) {
            i = j;
        }
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)));
    }

    protected int getBonemealAgeIncrease(Level level) {
        return Mth.m_216271_((RandomSource)level.f_46441_, (int)2, (int)5);
    }
}

