/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block;

import com.crypticmushroom.minecraft.midnight.common.network.MnNetwork;
import com.crypticmushroom.minecraft.midnight.common.network.level.RockshroomAttackPacket;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDamageTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class RockshroomBlock
extends Block {
    private static final int SPORE_COUNT = 32;
    private static final double SPORE_SPEED = 0.3;
    private static final double DAMAGE_RANGE = 4.0;
    private static final double DAMAGE_RANGE_SQ = 16.0;

    public RockshroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid)) {
            this.handleSporeDamage(level, pos, player);
            return true;
        }
        return false;
    }

    private void handleSporeDamage(Level level, BlockPos pos, Player player) {
        ItemStack heldItem = player.m_21205_();
        if (player.m_7500_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)heldItem) > 0) {
            return;
        }
        if (!level.f_46443_) {
            RockshroomAttackPacket message = new RockshroomAttackPacket(pos);
            MnNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)message);
            this.damagePlayer(level, pos, player);
        }
    }

    private void damagePlayer(Level level, BlockPos pos, Player player) {
        Vec3 origin = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        Vec3 target = player.m_20299_(1.0f);
        if (target.m_82546_(origin).m_82556_() > 16.0) {
            return;
        }
        BlockHitResult result = level.m_45547_(new ClipContext(origin, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (result.m_6662_() == HitResult.Type.MISS) {
            player.m_6469_(level.m_269111_().m_269079_(MnDamageTypes.ROCKSHROOM), level.f_46441_.m_188501_() * 3.5f + 0.5f);
        }
    }

    public static void spawnSpores(Level level, BlockPos pos) {
        if (level == null) {
            return;
        }
        RandomSource rng = level.f_46441_;
        for (int i = 0; i < 32; ++i) {
            Vec3 direction = new Vec3((double)(rng.m_188501_() * 2.0f - 1.0f), (double)(rng.m_188501_() * 2.0f - 1.0f), (double)(rng.m_188501_() * 2.0f - 1.0f)).m_82541_();
            double x = (double)pos.m_123341_() + 0.5 + direction.f_82479_ * 0.4;
            double y = (double)pos.m_123342_() + 0.5 + direction.f_82480_ * 0.4;
            double z = (double)pos.m_123343_() + 0.5 + direction.f_82481_ * 0.4;
            Vec3 vel = direction.m_82490_(0.3);
            level.m_7106_((ParticleOptions)MnParticleTypes.SPORE.get(), x, y, z, vel.f_82479_, vel.f_82480_ + 0.05, vel.f_82481_);
        }
    }
}

