/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.advancement;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class GeodeHitBlockTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = Midnight.id("geode_hit_block");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext deserializationContext) {
        return new Instance(predicate, json.get("only_when_broken").getAsBoolean());
    }

    public void trigger(ServerPlayer player, boolean geodeBroke) {
        this.m_66234_(player, instance -> instance.test(geodeBroke));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final boolean onBreakOnly;

        public Instance(ContextAwarePredicate player, boolean breakOnly) {
            super(ID, player);
            this.onBreakOnly = breakOnly;
        }

        public static Instance withBreakOnly(boolean breakOnly) {
            return new Instance(ContextAwarePredicate.f_285567_, breakOnly);
        }

        public boolean test(boolean geodeBroke) {
            return this.onBreakOnly ? geodeBroke : true;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject json = super.m_7683_(conditions);
            json.addProperty("only_when_broken", Boolean.valueOf(this.onBreakOnly));
            return json;
        }
    }
}

