/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.world.environment;

import com.crypticmushroom.minecraft.midnight.client.MidnightClient;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.client.event.ViewportEvent;
import org.jetbrains.annotations.Nullable;

public final class MnFogTicker {
    private ClientLevel level;
    private LocalPlayer player;
    private ViewportEvent.RenderFog event;
    @Nullable
    private Float nearPlaneDistance = null;
    @Nullable
    private Float farPlaneDistance = null;

    void tick(ViewportEvent.RenderFog event) {
        if (!this.canContinue()) {
            return;
        }
        this.event = event;
        float nearPlaneDistance = this.getNearPlaneDistance();
        float farPlaneDistance = this.getFarPlaneDistance();
        this.nearPlaneDistance = Float.valueOf(this.nearPlaneDistance == null ? nearPlaneDistance : MathUtil.moveTowardValue(this.nearPlaneDistance.floatValue(), nearPlaneDistance, 0.2f));
        this.farPlaneDistance = Float.valueOf(this.farPlaneDistance == null ? farPlaneDistance : MathUtil.moveTowardValue(this.farPlaneDistance.floatValue(), farPlaneDistance, 0.2f));
        this.event.setNearPlaneDistance(this.nearPlaneDistance.floatValue());
        this.event.setFarPlaneDistance(this.farPlaneDistance.floatValue());
        this.event.setCanceled(true);
        this.event = null;
    }

    private boolean canContinue() {
        Minecraft mc = Minecraft.m_91087_();
        this.level = mc.f_91073_;
        this.player = mc.f_91074_;
        return this.player != null && MnDimensions.THE_MIDNIGHT.is((Level)this.level);
    }

    private float getNearPlaneDistance() {
        return -32.0f;
    }

    private float getFarPlaneDistance() {
        float biomeFogDistance = MidnightClient.get().getBiomeModifierManager().get((Holder<Biome>)this.level.m_204166_(this.player.m_20183_())).getFogDistance();
        return Math.min(biomeFogDistance * 16.0f, this.event.getFarPlaneDistance());
    }
}

