/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.renderer.entity;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.model.entity.NovaSpikeModel;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.NovaSpikeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class NovaSpikeRenderer<E extends NovaSpikeEntity>
extends EntityRenderer<E> {
    private static final ResourceLocation TEXTURE = Midnight.id("textures/entity/nova_spike.png");
    private final NovaSpikeModel<NovaSpikeEntity> model;

    public NovaSpikeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new NovaSpikeModel(context);
    }

    public void render(E entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)((NovaSpikeEntity)((Object)entity)).f_19859_, (float)entity.m_146908_()) - 90.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTicks, (float)((NovaSpikeEntity)((Object)entity)).f_19860_, (float)entity.m_146909_()) - 90.0f));
        ResourceLocation texture = this.getTextureLocation(entity);
        VertexConsumer vertexConsumer = buffer.m_6299_(this.model.m_103119_(texture));
        int i = this.getPackedOverlay(entity, 0.0f);
        this.model.m_7695_(matrixStack, vertexConsumer, packedLight, i, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    protected int getPackedOverlay(E entity, float u) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)u), (int)OverlayTexture.m_118096_((boolean)false));
    }

    public ResourceLocation getTextureLocation(E entity) {
        return TEXTURE;
    }
}

