/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.renderer.entity;

import com.crypticmushroom.minecraft.midnight.client.model.entity.NightstagModel;
import com.crypticmushroom.minecraft.midnight.common.entity.living.creature.animal.NightstagEntity;
import com.crypticmushroom.minecraft.midnight.common.util.ColorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class NightstagRenderer<E extends NightstagEntity>
extends GeoEntityRenderer<E> {
    public NightstagRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new NightstagModel());
        this.addRenderLayer((GeoRenderLayer)new NightstagGlowLayer());
    }

    public void preRender(PoseStack poseStack, E animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (animatable.m_6162_()) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public RenderType getRenderType(E animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }

    private class NightstagGlowLayer
    extends AutoGlowingGeoLayer<E> {
        private static final int FLICK_BRIGHT_LOW = 50;
        private static final int FLICK_BRIGHT_UP = 200;
        private static final int PULSE_BRIGHT_LOW = 150;
        private static final int PULSE_BRIGHT_UP = 200;

        private NightstagGlowLayer() {
            super((GeoRenderer)NightstagRenderer.this);
        }

        protected RenderType getRenderType(E animatable) {
            return RenderType.m_234338_((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
        }

        public void render(PoseStack poseStack, E animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            RenderType type = this.getRenderType(animatable);
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, animatable, type, bufferSource.m_6299_(type), partialTick, 0xF00000, OverlayTexture.f_118083_, ColorUtil.redf(((NightstagEntity)((Object)animatable)).getAntlerType().color), ColorUtil.greenf(((NightstagEntity)((Object)animatable)).getAntlerType().color), ColorUtil.bluef(((NightstagEntity)((Object)animatable)).getAntlerType().color), this.getGlowBrightness(animatable, partialTick));
        }

        private float getGlowBrightness(E entity, float partialTicks) {
            double totalTicks = (float)((NightstagEntity)((Object)entity)).f_19797_ + partialTicks;
            float flicker = this.getFlicker(entity, totalTicks, partialTicks);
            float pulse = (float)((Math.sin(totalTicks * 0.125) + 1.0) * 0.5);
            float health = entity.m_21223_() / entity.m_21233_();
            float flickerBrightness = 50.0f + 150.0f * flicker;
            float healthyBrightness = 150.0f + 50.0f * pulse;
            return 0.2f + (float)Mth.m_14143_((float)(flickerBrightness * (1.0f - health) + healthyBrightness * health));
        }

        private float getFlicker(E entity, double totalTicks, float partialTicks) {
            float lerpedFlicker = ((NightstagEntity)((Object)entity)).flickerO + (((NightstagEntity)((Object)entity)).flicker - ((NightstagEntity)((Object)entity)).flickerO) * partialTicks;
            float pulse = (float)(Math.sin(totalTicks * 0.2) + 1.0) * 0.4f;
            return Mth.m_14036_((float)(lerpedFlicker + pulse), (float)0.0f, (float)1.0f);
        }
    }
}

