/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.compatibility.lucent;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.renderer.MidnightRendering;
import com.crypticmushroom.minecraft.midnight.coremod.mixin.accessor.EntityLightingBuilderAccessor;
import com.crypticmushroom.minecraft.midnight.coremod.mixin.accessor.ItemLightingBuilderAccessor;
import com.legacy.lucent.api.data.objects.EmissiveBlockTexture;
import com.legacy.lucent.api.data.objects.EntityLighting;
import com.legacy.lucent.api.data.objects.ItemLighting;
import com.legacy.lucent.api.data.objects.LightLevelProvider;
import com.legacy.lucent.api.plugin.ILucentPlugin;
import com.legacy.lucent.api.plugin.LucentPlugin;
import com.legacy.lucent.api.registry.BlockTextureLightingRegistry;
import com.legacy.lucent.api.registry.EntityLightingRegistry;
import com.legacy.lucent.api.registry.ItemLightingRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

@LucentPlugin
public class MnLucentPlugin
implements ILucentPlugin {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Client/Lucent");
    public static MnLucentPlugin instance;
    private ItemLightings itemLightings;
    private EntityLightings entityLightings;
    private BlockTextureLightings blockTextureLightings;

    public static MnLucentPlugin get() {
        if (instance == null) {
            Midnight.LOGGER.info(MARKER, "Creating dummy instance of MnLucentPlugin for datagen");
            new MnLucentPlugin();
            instance.registerItemLightings(null);
            instance.registerEntityLightings(null);
            instance.registerBlockTextureLightings(null);
        }
        return instance;
    }

    public MnLucentPlugin() {
        if (instance != null) {
            Midnight.LOGGER.warn(MARKER, "Replacing existing MnLucentPlugin instance!");
        }
        instance = this;
    }

    public Map<String, EntityLighting<?>> getEntityLightings() {
        return this.entityLightings.lightings;
    }

    public Map<String, ItemLighting> getItemLightings() {
        return this.itemLightings.lightings;
    }

    public Map<String, EmissiveBlockTexture> getBlockTextureLightings() {
        return this.blockTextureLightings.lightings;
    }

    public String ownerModID() {
        return "midnight";
    }

    public ResourceLocation locate(String path) {
        return Midnight.id(path);
    }

    public void registerItemLightings(@Nullable ItemLightingRegistry registry) {
        Midnight.LOGGER.debug(MARKER, "Registering item lightings");
        this.itemLightings = new ItemLightings(registry);
        MidnightRendering.Items.setupLightings(this.itemLightings);
    }

    public void registerEntityLightings(@Nullable EntityLightingRegistry registry) {
        Midnight.LOGGER.debug(MARKER, "Registering entity lightings");
        this.entityLightings = new EntityLightings(registry);
        MidnightRendering.Entities.setupLightings(this.entityLightings);
    }

    public void registerBlockTextureLightings(BlockTextureLightingRegistry registery) {
        Midnight.LOGGER.debug(MARKER, "Registering emissive block textures");
        this.blockTextureLightings = new BlockTextureLightings();
        MidnightRendering.Blocks.setupTextureLightings(this.blockTextureLightings);
    }

    public final class EntityLightings {
        private final Optional<EntityLightingRegistry> registry;
        private final Map<String, EntityLighting<?>> lightings = new HashMap();

        private EntityLightings(EntityLightingRegistry registry) {
            this.registry = Optional.ofNullable(registry);
        }

        private String extractName(EntityType<?> entity) {
            Objects.requireNonNull(entity, "Cannot register entity lighting with a null entity type! If you must, use the version of the method with String name");
            ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(entity);
            return "%s%s".formatted(id.m_135827_().equals(MnLucentPlugin.this.ownerModID()) ? "" : id.m_135827_() + "_", id.m_135815_());
        }

        private String extractName(EntityLighting<?> lighting) {
            return this.extractName((EntityType)Objects.requireNonNull(lighting, "Cannot register entity lighting with null lighting!").entity().orElseThrow(() -> new IllegalArgumentException("Cannot register entity lighting with null entity type! If you must, use the version of the method with String name")));
        }

        public void register(String name, EntityLighting<?> lighting) {
            if (lighting.provider() instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(lighting));
            } else {
                this.lightings.put(name, lighting);
            }
        }

        public void register(EntityLighting<?> lighting) {
            if (lighting.provider() instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(lighting));
            } else {
                this.lightings.put(this.extractName(lighting), lighting);
            }
        }

        public void register(String name, EntityLighting.Builder entityLightingBuilder) {
            if (((EntityLightingBuilderAccessor)entityLightingBuilder).midnight$provider() instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(entityLightingBuilder));
            } else {
                if (entityLightingBuilder.hasFailed()) {
                    return;
                }
                this.lightings.put(name, entityLightingBuilder.build());
            }
        }

        public void register(EntityLighting.Builder entityLightingBuilder) {
            if (((EntityLightingBuilderAccessor)entityLightingBuilder).midnight$provider() instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(entityLightingBuilder));
            } else {
                if (entityLightingBuilder.hasFailed()) {
                    return;
                }
                this.register(entityLightingBuilder.build());
            }
        }

        public void register(String name, @Nullable EntityType<?> entityType, LightLevelProvider<?> lightLevelProvider) {
            if (lightLevelProvider instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(entityType, lightLevelProvider));
                return;
            }
            this.lightings.put(name, EntityLighting.builder().entity(entityType).light(lightLevelProvider).build());
        }

        public void register(@Nullable EntityType<?> entityType, LightLevelProvider<?> lightLevelProvider) {
            if (lightLevelProvider instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(entityType, lightLevelProvider));
                return;
            }
            this.lightings.put(this.extractName(entityType), EntityLighting.builder().entity(entityType).light(lightLevelProvider).build());
        }

        public void register(String name, LightLevelProvider<?> lightLevelProvider) {
            if (lightLevelProvider instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(lightLevelProvider));
                return;
            }
            this.lightings.put(name, EntityLighting.builder().entity((EntityType)null).light(lightLevelProvider).build());
        }

        public void register(LightLevelProvider<?> lightLevelProvider) {
            if (lightLevelProvider instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(lightLevelProvider));
                return;
            }
            throw new UnsupportedOperationException("Cannot register a non-custom light level provider without a name!");
        }

        public void register(String name, @Nullable EntityType<?> entityType, int lightLevel) {
            this.lightings.put(name, EntityLighting.builder().entity(entityType).light(lightLevel).build());
        }

        public void register(@Nullable EntityType<?> entityType, int lightLevel) {
            this.lightings.put(this.extractName(entityType), EntityLighting.builder().entity(entityType).light(lightLevel).build());
        }

        public <T extends Entity> void register(@Nullable EntityType<T> entityType, @Nullable Function<T, Integer> lightLevel) {
            if (this.registry.isEmpty()) {
                return;
            }
            this.registry.get().register(entityType, lightLevel);
        }

        public <T extends Entity> void register(@Nullable Function<T, Integer> lightFunction) {
            if (this.registry.isEmpty()) {
                return;
            }
            this.registry.get().register(lightFunction);
        }

        public <T extends Entity> void register(ResourceLocation entityTypeId, @Nullable Function<T, Integer> lightFunction) {
            if (this.registry.isEmpty()) {
                return;
            }
            this.registry.get().register(entityTypeId, lightFunction);
        }

        public <T extends Entity> void register(String entityTypeId, @Nullable Function<T, Integer> lightFunction) {
            if (this.registry.isEmpty()) {
                return;
            }
            this.registry.get().register(entityTypeId, lightFunction);
        }
    }

    public final class ItemLightings {
        private final Optional<ItemLightingRegistry> registry;
        private final Map<String, ItemLighting> lightings = new HashMap<String, ItemLighting>();

        private ItemLightings(ItemLightingRegistry registry) {
            this.registry = Optional.ofNullable(registry);
        }

        private String extractName(Item item) {
            Objects.requireNonNull(item, "Cannot register entity lighting with a null entity type! If you must, use the version of the method with String name");
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
            return "%s%s".formatted(id.m_135827_().equals(MnLucentPlugin.this.ownerModID()) ? "" : id.m_135827_() + "_", id.m_135815_());
        }

        private String extractName(ItemLighting lighting) {
            return this.extractName((Item)Objects.requireNonNull(lighting, "Cannot register entity lighting with null lighting!").item().orElseThrow(() -> new IllegalArgumentException("Cannot register item lighting with null item! If you must, use the version of the method with String name")));
        }

        public void register(String name, ItemLighting lighting) {
            if (lighting.provider() instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(lighting));
            } else {
                this.lightings.put(name, lighting);
            }
        }

        public void register(ItemLighting lighting) {
            if (lighting.provider() instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(lighting));
            } else {
                this.lightings.put(this.extractName(lighting), lighting);
            }
        }

        public void register(String name, ItemLighting.Builder ItemLightingBuilder) {
            if (((ItemLightingBuilderAccessor)ItemLightingBuilder).midnight$provider() instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(ItemLightingBuilder));
            } else {
                if (ItemLightingBuilder.hasFailed()) {
                    return;
                }
                this.lightings.put(name, ItemLightingBuilder.build());
            }
        }

        public void register(ItemLighting.Builder ItemLightingBuilder) {
            if (((ItemLightingBuilderAccessor)ItemLightingBuilder).midnight$provider() instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(ItemLightingBuilder));
            } else {
                if (ItemLightingBuilder.hasFailed()) {
                    return;
                }
                this.register(ItemLightingBuilder.build());
            }
        }

        public void register(String name, @Nullable Item entityType, LightLevelProvider<?> lightLevelProvider) {
            if (lightLevelProvider instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(entityType, lightLevelProvider));
                return;
            }
            this.lightings.put(name, ItemLighting.builder().item(entityType).light(lightLevelProvider).build());
        }

        public void register(@Nullable Item entityType, LightLevelProvider<?> lightLevelProvider) {
            if (lightLevelProvider instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(entityType, lightLevelProvider));
                return;
            }
            this.lightings.put(this.extractName(entityType), ItemLighting.builder().item(entityType).light(lightLevelProvider).build());
        }

        public void register(String name, LightLevelProvider<?> lightLevelProvider) {
            if (lightLevelProvider instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(lightLevelProvider));
                return;
            }
            this.lightings.put(name, ItemLighting.builder().item((Item)null).light(lightLevelProvider).build());
        }

        public void register(LightLevelProvider<?> lightLevelProvider) {
            if (lightLevelProvider instanceof LightLevelProvider.Custom) {
                this.registry.ifPresent(r -> r.register(lightLevelProvider));
                return;
            }
            throw new UnsupportedOperationException("Cannot register a non-custom light level provider without a name!");
        }

        public void register(String name, @Nullable Item entityType, int lightLevel) {
            this.lightings.put(name, ItemLighting.builder().item(entityType).light(lightLevel).build());
        }

        public void register(@Nullable Item item, int lightLevel) {
            this.lightings.put(this.extractName(item), ItemLighting.builder().item(item).light(lightLevel).build());
        }
    }

    public final class BlockTextureLightings {
        private final Map<String, EmissiveBlockTexture> lightings = new HashMap<String, EmissiveBlockTexture>();

        private BlockTextureLightings() {
        }

        private String extractName(ResourceLocation id) {
            return "%s%s".formatted(id.m_135827_().equals(MnLucentPlugin.this.ownerModID()) ? "" : id.m_135827_() + "_", id.m_135815_());
        }

        private String extractName(EmissiveBlockTexture lighting) {
            return this.extractName(lighting.texture());
        }

        public void register(String name, EmissiveBlockTexture EmissiveBlockTexture2) {
            this.lightings.put(name, EmissiveBlockTexture2);
        }

        public void register(EmissiveBlockTexture EmissiveBlockTexture2) {
            this.lightings.put(this.extractName(EmissiveBlockTexture2), EmissiveBlockTexture2);
        }

        public void register(String name, ResourceLocation texture, int lightLevel) {
            this.lightings.put(name, new EmissiveBlockTexture(texture, lightLevel));
        }

        public void register(ResourceLocation texture, int lightLevel) {
            this.lightings.put(this.extractName(texture), new EmissiveBlockTexture(texture, lightLevel));
        }

        public void register(String name, String texture, int lightLevel) {
            this.lightings.put(name, new EmissiveBlockTexture(Midnight.id(texture), lightLevel));
        }

        public void register(String texture, int lightLevel) {
            this.lightings.put(texture, new EmissiveBlockTexture(Midnight.id(texture), lightLevel));
        }
    }
}

