/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.audio;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.audio.MnSoundSystem;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import com.crypticmushroom.minecraft.midnight.common.util.MathUtil;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBiomeTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.sound.SoundEngineLoadEvent;
import net.minecraftforge.client.event.sound.SoundEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.EXTEfx;

public final class MnSoundReverb {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Client/SOUND_REVERB").addParents(new Marker[]{MnSoundSystem.MARKER});
    private static final float DEFAULT_REVERB_LEVEL = 0.5f;
    private static final float DEFAULT_DECAY_TIME = 6.0f;
    private boolean available;
    private boolean setup;
    private boolean firstRun;
    private int auxEffectSlot;
    private int reverbEffectSlot;
    private float currentReverbLevel;
    private float currentDecayTime;
    private float newReverbLevel;
    private float newDecayTime;

    public MnSoundReverb() {
        this.reset();
    }

    void onPlaySound(SoundEvent.SoundSourceEvent event) {
        if (!this.setup) {
            this.setup();
            this.setup = true;
        }
        if (event.getSound().m_8070_() == SoundSource.WEATHER) {
            return;
        }
        if (event.getSound() == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (!this.shouldPlayWithEcho(minecraft, event.getSound(), event.getSound().m_7904_())) {
            return;
        }
        this.setEchoLevels(minecraft, event.getSound());
        AL11.alSource3i((int)event.getChannel().f_83642_, (int)131078, (int)this.auxEffectSlot, (int)0, (int)0);
    }

    void onSoundLoad(SoundEngineLoadEvent event) {
        this.reset();
    }

    void tick() {
        if (!this.available || !this.setup) {
            return;
        }
        if (this.currentReverbLevel == this.newReverbLevel && this.currentDecayTime == this.newDecayTime || this.currentReverbLevel <= 0.0f || this.currentReverbLevel > 1.0f || this.currentDecayTime <= 0.0f) {
            return;
        }
        this.currentReverbLevel = MathUtil.moveTowardValue(this.currentReverbLevel, this.newReverbLevel, 0.01f, 0.0f, 1.0f);
        this.currentDecayTime = MathUtil.moveTowardValue(this.currentDecayTime, this.newDecayTime, 0.01f, 0.0f, Float.MAX_VALUE);
        this.setEchoLevels();
    }

    private void reset() {
        Midnight.LOGGER.debug(MARKER, "Resetting the sound reverb system!");
        this.available = false;
        this.setup = false;
        this.firstRun = true;
    }

    private void setup() {
        this.available = AL.getCapabilities().ALC_EXT_EFX;
        if (!this.available) {
            Midnight.LOGGER.warn("Unable to setup reverb effects, AL EFX not supported!");
            return;
        }
        this.auxEffectSlot = EXTEfx.alGenAuxiliaryEffectSlots();
        Midnight.LOGGER.debug(MARKER, "Created a new auxiliary effect slot with stack pointer {}", (Object)this.auxEffectSlot);
        this.reverbEffectSlot = EXTEfx.alGenEffects();
        Midnight.LOGGER.debug(MARKER, "Created a new effects with stack pointer {}", (Object)this.reverbEffectSlot);
        this.setEchoLevels(0.5f, 6.0f);
        this.currentReverbLevel = 0.5f;
        this.currentDecayTime = 6.0f;
        this.newReverbLevel = 0.5f;
        this.newDecayTime = 6.0f;
    }

    private boolean shouldPlayWithEcho(Minecraft minecraft, SoundInstance sound, ResourceLocation id) {
        return this.available && MnDimensions.THE_MIDNIGHT.is((Level)minecraft.f_91073_) && !MnSoundEvents.IGNORING_REVERB.contains(id) && sound.m_8070_() != SoundSource.MUSIC && sound.m_8070_() != SoundSource.RECORDS;
    }

    private void setEchoLevels(Minecraft minecraft, SoundInstance sound) {
        ClientLevel level = minecraft.f_91073_;
        LocalPlayer player = minecraft.f_91074_;
        if (level == null || player == null) {
            return;
        }
        Holder biome = level.m_204166_(player.m_20183_());
        float f = this.newReverbLevel = biome.m_203656_(MnBiomeTags.IS_UNDERGROUND) ? 1.0f : 0.5f;
        if (this.firstRun) {
            this.currentReverbLevel = this.newReverbLevel;
            this.currentDecayTime = this.newDecayTime;
            this.setEchoLevels(this.currentReverbLevel, this.currentDecayTime);
            this.firstRun = false;
        }
    }

    private void setEchoLevels() {
        this.setEchoLevels(this.currentReverbLevel, this.currentDecayTime);
    }

    private void setEchoLevels(float reverbLevel, float decayTime) {
        if (reverbLevel <= 0.0f || reverbLevel > 1.0f || decayTime <= 0.0f) {
            return;
        }
        EXTEfx.alAuxiliaryEffectSloti((int)this.auxEffectSlot, (int)3, (int)1);
        EXTEfx.alAuxiliaryEffectSlotf((int)this.auxEffectSlot, (int)2, (float)reverbLevel);
        EXTEfx.alEffecti((int)this.reverbEffectSlot, (int)32769, (int)32768);
        EXTEfx.alEffectf((int)this.reverbEffectSlot, (int)6, (float)decayTime);
        EXTEfx.alAuxiliaryEffectSloti((int)this.auxEffectSlot, (int)1, (int)this.reverbEffectSlot);
    }
}

