/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.audio;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.audio.MnMusic;
import com.crypticmushroom.minecraft.midnight.client.audio.MnSoundSystem;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.util.MathUtil;
import com.crypticmushroom.minecraft.midnight.coremod.mixin.accessor.AbstractSoundInstanceAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public final class MnMusicTicker {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Client/MUSIC").addParents(new Marker[]{MnSoundSystem.MARKER});
    static final List<Pair<MnMusic, Predicate<Minecraft>>> TRUE_MUSIC_TRACKS = new ArrayList<Pair<MnMusic, Predicate<Minecraft>>>();
    static final List<Pair<MnMusic, Predicate<Minecraft>>> AMBIENT_TRACKS = new ArrayList<Pair<MnMusic, Predicate<Minecraft>>>();
    private RandomSource random = RandomSource.m_216327_();
    private TickableMusicSound ambientMusic;
    private TickableMusicSound trueMusic;
    private int timeUntilNextMusic = this.random.m_188503_(MathUtil.secondsToTicks(2) + 1) + MathUtil.secondsToTicks(3);
    private boolean hasPlayedTrueMusic = false;
    private MnMusic lastMusicPlayed;

    void tick() {
        MnMusic lastPlayed;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || !MnDimensions.THE_MIDNIGHT.is(mc.f_91074_.m_9236_())) {
            this.stopMusic();
            return;
        }
        this.random = mc.f_91074_.m_9236_().f_46441_;
        if (this.trueMusic != null && (((AbstractSoundInstanceAccessor)((Object)this.trueMusic)).midnight$sound() != null || this.trueMusic.m_7769_() <= 0.0f)) {
            Midnight.LOGGER.trace(MARKER, "Unsetting true music since its pitch is at or below 0, or has become inaccessible.");
            this.trueMusic = null;
        }
        if (this.ambientMusic != null && (((AbstractSoundInstanceAccessor)((Object)this.ambientMusic)).midnight$sound() != null || this.ambientMusic.m_7769_() <= 0.0f)) {
            Midnight.LOGGER.trace(MARKER, "Unsetting ambient music since its pitch is at or below 0");
            this.ambientMusic = null;
        }
        if (this.ambientMusic != null && !mc.m_91106_().m_120403_((SoundInstance)this.ambientMusic)) {
            lastPlayed = MnMusic.get(this.ambientMusic.m_7904_());
            Midnight.LOGGER.debug(MARKER, "Unsetting ambient music since it's not playing or has finished");
            this.ambientMusic = null;
            this.setTimeUntilNextMusic(lastPlayed);
            Midnight.LOGGER.debug(MARKER, "Approximate time until next track is played: {} seconds.", (Object)MathUtil.ticksToSeconds(this.timeUntilNextMusic));
        }
        if (this.trueMusic != null && !mc.m_91106_().m_120403_((SoundInstance)this.trueMusic)) {
            lastPlayed = MnMusic.get(this.trueMusic.m_7904_());
            Midnight.LOGGER.debug(MARKER, "Unsetting true music since it's not playing or has finished");
            this.trueMusic = null;
            this.setTimeUntilNextMusic(lastPlayed);
            Midnight.LOGGER.debug(MARKER, "Approximate time until next track is played: {} seconds.", (Object)MathUtil.ticksToSeconds(this.timeUntilNextMusic));
        }
        MnMusic track = Objects.requireNonNullElse(this.getTrueMusicTrack(), this.getAmbientMusicTrack());
        if (this.timeUntilNextMusic > track.maxDelay) {
            this.timeUntilNextMusic = track.maxDelay;
        }
        if (this.trueMusic == null && this.ambientMusic == null && this.timeUntilNextMusic-- <= 0) {
            MnSoundSystem.get().playSound((SoundInstance)this.prepareMusic(track));
        }
    }

    public boolean isPlayingMusic() {
        return this.isPlayingTrueMusic() || this.isPlayingAmbientMusic();
    }

    public boolean isPlayingTrueMusic() {
        return Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)this.trueMusic);
    }

    public boolean isPlayingAmbientMusic() {
        return Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)this.ambientMusic);
    }

    @Nullable
    public SoundEvent getCurrentSoundEvent() {
        if (this.trueMusic == null && this.ambientMusic == null) {
            return null;
        }
        return Objects.requireNonNullElse(this.trueMusic, this.ambientMusic).getSoundEvent();
    }

    private void setTimeUntilNextMusic(@Nullable MnMusic lastPlayed) {
        int minDelay = lastPlayed != null ? lastPlayed.minDelay : 1200;
        int maxDelay = lastPlayed != null ? lastPlayed.maxDelay : 1500;
        this.timeUntilNextMusic = Math.min(Mth.m_216271_((RandomSource)this.random, (int)minDelay, (int)maxDelay), this.timeUntilNextMusic);
    }

    @Nullable
    private MnMusic getTrueMusicTrack() {
        return !this.hasPlayedTrueMusic ? this.getTrack(MnMusic::getTrueMusic) : null;
    }

    private MnMusic getAmbientMusicTrack() {
        return Objects.requireNonNull(this.getTrack(MnMusic::getAmbientMusic), "Failed to get an ambient track! This is not good.");
    }

    @Nullable
    private MnMusic getTrack(Supplier<List<MnMusic>> impl) {
        List<MnMusic> tracks = impl.get();
        tracks.remove(this.lastMusicPlayed);
        tracks.removeIf(track -> !track.shouldPlay.test(Minecraft.m_91087_()));
        return tracks.isEmpty() ? null : tracks.get(this.random.m_188503_(tracks.size()));
    }

    public TickableMusicSound prepareMusic(MnMusic track) {
        return this.prepareMusic(track, Optional.empty(), this.random);
    }

    public TickableMusicSound prepareMusic(MnMusic track, Optional<Float> volume, RandomSource random) {
        return track.isTrue ? this.prepareTrueMusic(track, volume, random) : this.prepareAmbientMusic(track, volume, random);
    }

    private TickableMusicSound prepareTrueMusic(MnMusic track, Optional<Float> volume, RandomSource random) {
        if (this.isPlayingMusic()) {
            this.stopMusic();
        }
        this.trueMusic = new TickableMusicSound(track.getSoundEvent(), SoundSource.MUSIC, false, random);
        volume.ifPresent(this.trueMusic::setVolume);
        this.hasPlayedTrueMusic = true;
        this.lastMusicPlayed = track;
        Midnight.LOGGER.debug(MARKER, "Now playing music track: {}", (Object)track.toString());
        this.timeUntilNextMusic = Integer.MAX_VALUE;
        return this.trueMusic;
    }

    private TickableMusicSound prepareAmbientMusic(MnMusic track, Optional<Float> volume, RandomSource random) {
        if (this.isPlayingMusic()) {
            this.stopMusic();
        }
        this.ambientMusic = new TickableMusicSound(track.getSoundEvent(), SoundSource.MUSIC, false, random);
        volume.ifPresent(this.ambientMusic::setVolume);
        Midnight.LOGGER.debug(MARKER, "Now playing ambient-like music track: {}", (Object)track.toString());
        this.hasPlayedTrueMusic = false;
        this.lastMusicPlayed = track;
        this.timeUntilNextMusic = Integer.MAX_VALUE;
        return this.ambientMusic;
    }

    public void stopMusic() {
        this.stopTrueMusic();
        this.stopAmbientMusic();
    }

    private void stopTrueMusic() {
        if (this.trueMusic != null) {
            Midnight.LOGGER.debug(MARKER, "Stopping true music");
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this.trueMusic);
            this.trueMusic = null;
            this.timeUntilNextMusic = this.random.m_188503_(MathUtil.secondsToTicks(45) + 1) + MathUtil.secondsToTicks(30);
        }
    }

    private void stopAmbientMusic() {
        if (this.ambientMusic != null) {
            Midnight.LOGGER.debug(MARKER, "Stopping ambient music");
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this.ambientMusic);
            this.ambientMusic = null;
            this.timeUntilNextMusic = this.random.m_188503_(MathUtil.secondsToTicks(45) + 1) + MathUtil.secondsToTicks(30);
        }
    }

    public static class TickableMusicSound
    extends AbstractTickableSoundInstance {
        private final SoundEvent soundEvent;

        public TickableMusicSound(SoundEvent soundEvent, SoundSource soundCategory, boolean repeat, RandomSource random) {
            super(soundEvent, soundCategory, random);
            this.soundEvent = soundEvent;
            this.f_119578_ = repeat;
        }

        public void m_7788_() {
        }

        public void setVolume(float volume) {
            this.f_119573_ = volume;
        }

        public SoundEvent getSoundEvent() {
            return this.soundEvent;
        }
    }
}

