/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.audio.MnSoundSystem;
import com.crypticmushroom.minecraft.midnight.client.renderer.MidnightRendering;
import com.crypticmushroom.minecraft.midnight.client.renderer.shader.MnShaders;
import com.crypticmushroom.minecraft.midnight.client.world.environment.MnDimensionEffects;
import com.crypticmushroom.minecraft.midnight.client.world.environment.MnEnvironmentSystem;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBiomes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.registry.MnFluids;
import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import com.crypticmushroom.minecraft.midnight.common.registry.MnParticleTypes;
import com.crypticmushroom.minecraft.midnight.common.world.manager.MidnightBiomeModifierManager;
import com.crypticmushroom.minecraft.midnight.common.world.manager.RiftBridgeManager;
import com.google.common.reflect.Reflection;
import com.mojang.datafixers.util.Either;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class MidnightClient
extends Midnight {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Client/");
    public static final Marker INIT_MARKER = MarkerManager.getMarker((String)"Client/INIT").addParents(new Marker[]{MARKER});
    private final MnSoundSystem soundSystem = new MnSoundSystem();
    private final MnEnvironmentSystem environmentSystem = new MnEnvironmentSystem();
    @Nullable
    private RiftBridgeManager.Client bridgeManager;
    private final MidnightBiomeModifierManager.Client biomeModifierManager = new MidnightBiomeModifierManager.Client();

    @Override
    public void preInit() {
        super.preInit();
    }

    @Override
    public void init() {
        super.init();
        MnFluids.setupRenderers();
        Reflection.initialize((Class[])new Class[]{MnDimensionEffects.class});
    }

    @Override
    public void addEventListeners(IEventBus modBus) {
        super.addEventListeners(modBus);
        LOGGER.debug(INIT_MARKER, "Adding client event listeners");
        modBus.addListener(this::clientSetup);
        MnShaders.addEventListeners(modBus);
        modBus.addListener(MidnightRendering.Entities::setupLayerDefinitions);
        modBus.addListener(MidnightRendering.Entities::setupRenderers);
        modBus.addListener(MidnightRendering.BlockEntities::setupRenderers);
        modBus.addListener(this::onRegisterParticles);
        this.getEnvironmentSystem().addEventListeners(modBus);
        modBus.addListener(this::onRegisterDimensionSpecialEffects);
        modBus.addListener(MnBiomes::registerColorResolvers);
        modBus.addListener(MnBlocks::registerBlockColorHandlers);
        modBus.addListener(MnBlocks::registerItemColorHandlers);
        this.getSoundSystem().addEventListeners(modBus);
        MinecraftForge.EVENT_BUS.addListener(this::onClientPlayerLoggingIn);
        MinecraftForge.EVENT_BUS.addListener(this::onClientPlayerLoggingOut);
        MinecraftForge.EVENT_BUS.addListener(this::fovModify);
        MinecraftForge.EVENT_BUS.addListener(this::computeFogColour);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)MnItems.ROCKSHROOM_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (stack, level, livingEntity, seed) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)MnItems.TENEBRUM_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (stack, level, livingEntity, seed) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)MnItems.DARK_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, level, livingEntity, seed) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return livingEntity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - livingEntity.m_21212_()) / 20.0f;
            });
            ItemProperties.register((Item)((Item)MnItems.DARK_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, level, livingEntity, seed) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)MnItems.TENEBRUM_PICKAXE.get()), (ResourceLocation)Midnight.id("luxed"), (stack, level, livingEntity, seed) -> stack.m_41784_().m_128451_("luxed"));
        });
    }

    private void onRegisterParticles(RegisterParticleProvidersEvent event) {
        MnParticleTypes.setupClient(event);
    }

    public void onRegisterDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(Midnight.id("midnight"), (DimensionSpecialEffects)new MnDimensionEffects());
    }

    private void fovModify(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        ItemStack itemstack = player.m_21211_();
        float f = event.getFovModifier();
        if (player.m_6117_() && itemstack.m_150930_((Item)MnItems.DARK_BOW.get())) {
            int i = player.m_21252_();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewFovModifier(f *= 1.0f - f1 * 0.15f);
        }
    }

    private void onClientPlayerLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        this.bridgeManager = new RiftBridgeManager.Client();
    }

    private void onClientPlayerLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        this.bridgeManager = null;
    }

    public MnSoundSystem getSoundSystem() {
        return this.soundSystem;
    }

    public MnEnvironmentSystem getEnvironmentSystem() {
        return this.environmentSystem;
    }

    public RiftBridgeManager.Client getBridgeManager() {
        return Objects.requireNonNull(this.bridgeManager, "Client must be logged into a world before getting the rift bridge manager");
    }

    public MidnightBiomeModifierManager.Client getBiomeModifierManager() {
        return this.biomeModifierManager;
    }

    public static MidnightClient get() {
        try {
            return (MidnightClient)Midnight.get();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Cannot get the client instance of the Midnight while on the server!", e);
        }
    }

    private void onRenderTooltip(RenderTooltipEvent.GatherComponents event) {
        if (event.getItemStack().m_41782_() && event.getItemStack().m_41783_().m_128441_("Gilded")) {
            event.getTooltipElements().add(1, Either.left((Object)Component.m_237113_((String)"Gilded").m_130940_(ChatFormatting.GOLD)));
        }
    }

    private void computeFogColour(ViewportEvent.ComputeFogColor event) {
        Rift rift;
        LocalPlayer player;
        Minecraft mc = Minecraft.m_91087_();
        if (MnDimensions.THE_MIDNIGHT.is((Level)mc.f_91073_) && (player = mc.f_91074_) != null && (rift = (Rift)MnDimensionEffects.getNearestEntity(mc.f_91073_.m_45976_(Rift.class, player.m_20191_().m_82400_(10.0)), (LivingEntity)player, player.m_20185_(), player.m_20186_(), player.m_20189_())) != null) {
            float dist = Math.min(player.m_20270_((Entity)rift), 10.0f);
            event.setBlue(Mth.m_14179_((float)(1.0f - Math.max(0.0f, (dist - 2.0f) / 8.0f)), (float)event.getBlue(), (float)0.0f));
            event.setGreen(Mth.m_14179_((float)(1.0f - Math.max(0.0f, (dist - 2.0f) / 8.0f)), (float)event.getGreen(), (float)0.0f));
        }
    }
}

