/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.inventory;

import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.inventory.DirtChestSlot;
import com.progwml6.ironchest.common.inventory.IronChestsContainerTypes;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IronChestMenu
extends AbstractContainerMenu {
    private final Container container;
    private final IronChestsTypes chestType;

    private IronChestMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, (Container)new SimpleContainer(IronChestsTypes.WOOD.size), IronChestsTypes.WOOD);
    }

    public static IronChestMenu createIronContainer(int containerId, Inventory playerInventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.IRON_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(IronChestsTypes.IRON.size), IronChestsTypes.IRON);
    }

    public static IronChestMenu createIronContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.IRON_CHEST.get(), containerId, playerInventory, inventory, IronChestsTypes.IRON);
    }

    public static IronChestMenu createGoldContainer(int containerId, Inventory playerInventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.GOLD_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(IronChestsTypes.GOLD.size), IronChestsTypes.GOLD);
    }

    public static IronChestMenu createGoldContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.GOLD_CHEST.get(), containerId, playerInventory, inventory, IronChestsTypes.GOLD);
    }

    public static IronChestMenu createDiamondContainer(int containerId, Inventory playerInventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.DIAMOND_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(IronChestsTypes.DIAMOND.size), IronChestsTypes.DIAMOND);
    }

    public static IronChestMenu createDiamondContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.DIAMOND_CHEST.get(), containerId, playerInventory, inventory, IronChestsTypes.DIAMOND);
    }

    public static IronChestMenu createCrystalContainer(int containerId, Inventory playerInventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.CRYSTAL_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(IronChestsTypes.CRYSTAL.size), IronChestsTypes.CRYSTAL);
    }

    public static IronChestMenu createCrystalContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.CRYSTAL_CHEST.get(), containerId, playerInventory, inventory, IronChestsTypes.CRYSTAL);
    }

    public static IronChestMenu createCopperContainer(int containerId, Inventory playerInventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.COPPER_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(IronChestsTypes.COPPER.size), IronChestsTypes.COPPER);
    }

    public static IronChestMenu createCopperContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.COPPER_CHEST.get(), containerId, playerInventory, inventory, IronChestsTypes.COPPER);
    }

    public static IronChestMenu createObsidianContainer(int containerId, Inventory playerInventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.OBSIDIAN_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(IronChestsTypes.OBSIDIAN.size), IronChestsTypes.OBSIDIAN);
    }

    public static IronChestMenu createObsidianContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.OBSIDIAN_CHEST.get(), containerId, playerInventory, inventory, IronChestsTypes.OBSIDIAN);
    }

    public static IronChestMenu createDirtContainer(int containerId, Inventory playerInventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.DIRT_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(IronChestsTypes.DIRT.size), IronChestsTypes.DIRT);
    }

    public static IronChestMenu createDirtContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new IronChestMenu((MenuType)IronChestsContainerTypes.DIRT_CHEST.get(), containerId, playerInventory, inventory, IronChestsTypes.DIRT);
    }

    protected IronChestMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, Container inventory, IronChestsTypes chestType) {
        super(menuType, containerId);
        IronChestMenu.m_38869_((Container)inventory, (int)chestType.size);
        this.container = inventory;
        this.chestType = chestType;
        inventory.m_5856_(playerInventory.f_35978_);
        if (chestType == IronChestsTypes.DIRT) {
            this.m_38897_(new DirtChestSlot(inventory, 0, 84, 44));
        } else {
            for (int chestRow = 0; chestRow < chestType.getRowCount(); ++chestRow) {
                for (int chestCol = 0; chestCol < chestType.rowLength; ++chestCol) {
                    this.m_38897_(new Slot(inventory, chestCol + chestRow * chestType.rowLength, 12 + chestCol * 18, 18 + chestRow * 18));
                }
            }
        }
        int leftCol = (chestType.xSize - 162) / 2 + 1;
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.m_38897_(new Slot((Container)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, chestType.ySize - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotHarSlot = 0; hotHarSlot < 9; ++hotHarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotHarSlot, leftCol + hotHarSlot * 18, chestType.ySize - 24));
        }
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.chestType.size ? !this.m_38903_(itemstack1, this.chestType.size, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.chestType.size, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.container.m_5785_(playerIn);
    }

    public Container getContainer() {
        return this.container;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IronChestsTypes getChestType() {
        return this.chestType;
    }
}

