/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.blocks.natural.HangingFruitLeavesBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class CrescentFruitTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.dusk_log.m_49966_();
    private static final BlockState LEAF_CANT_GROW = SkiesBlocks.crescent_fruit_leaves.m_49966_();
    private static final BlockState LEAF_CAN_GROW = (BlockState)SkiesBlocks.crescent_fruit_leaves.m_49966_().m_61124_((Property)HangingFruitLeavesBlock.CAN_GROW, (Comparable)Boolean.valueOf(true));

    public CrescentFruitTreeFeature(Codec<TreeConfiguration> config) {
        super(config, true);
    }

    @Override
    public boolean place(WorldGenLevel world, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        int height = rand.m_188503_(3) + ((double)rand.m_188501_() < 0.2 ? 9 : 6);
        if (!this.isAreaOk(world, pos, height, 1, 3, 5)) {
            return false;
        }
        this.setLeaves(changedLeaves, world, rand, pos, height);
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            this.setBlockIfOk(changedLogs, world, pos.m_6630_(yOffset), LOG);
        }
        this.setSideLogs(changedLogs, world, rand, pos);
        return true;
    }

    protected void setLeaves(BiConsumer<BlockPos, BlockState> changedLeaves, WorldGenLevel world, RandomSource rand, BlockPos pos, int height) {
        pos = new BlockPos(pos.m_123341_(), pos.m_123342_() - 1 + height, pos.m_123343_());
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = -3; y <= -1; ++y) {
                    if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                    if (y == -3 && rand.m_188503_(3) == 0) {
                        this.setLeaf(changedLeaves, world, rand, pos.m_7918_(x, y, z));
                    }
                    if (y < -2) continue;
                    this.setLeaf(changedLeaves, world, rand, pos.m_7918_(x, y, z));
                }
            }
        }
        for (int y = 0; y <= 1; ++y) {
            if (y == 0) {
                this.setLeaf(changedLeaves, world, rand, pos.m_7918_(1, y, 1));
                this.setLeaf(changedLeaves, world, rand, pos.m_7918_(1, y, -1));
                this.setLeaf(changedLeaves, world, rand, pos.m_7918_(-1, y, 1));
                this.setLeaf(changedLeaves, world, rand, pos.m_7918_(-1, y, -1));
            }
            this.setLeaf(changedLeaves, world, rand, pos.m_7918_(1, y, 0));
            this.setLeaf(changedLeaves, world, rand, pos.m_7918_(0, y, 1));
            this.setLeaf(changedLeaves, world, rand, pos.m_7918_(0, y, 0));
            this.setLeaf(changedLeaves, world, rand, pos.m_7918_(0, y, -1));
            this.setLeaf(changedLeaves, world, rand, pos.m_7918_(-1, y, 0));
        }
        this.setLeaf(changedLeaves, world, rand, pos.m_7918_(2, 0, 0));
        this.setLeaf(changedLeaves, world, rand, pos.m_7918_(-2, 0, 0));
        this.setLeaf(changedLeaves, world, rand, pos.m_7918_(0, 0, 2));
        this.setLeaf(changedLeaves, world, rand, pos.m_7918_(0, 0, -2));
    }

    protected void setSideLogs(BiConsumer<BlockPos, BlockState> changedLogs, WorldGenLevel world, RandomSource rand, BlockPos pos) {
        pos = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            BlockState state = world.m_8055_(pos.m_121945_(dir).m_7495_());
            if (!state.m_204336_(BlockTags.f_278411_) && !(state.m_60734_() instanceof BushBlock)) continue;
            this.setBlockIfOk(changedLogs, world, pos.m_121945_(dir).m_7495_(), LOG);
        }
        this.setBlockIfOk(changedLogs, world, pos.m_7918_(rand.m_188503_(3) - 1, 0, 0), LOG);
        this.setBlockIfOk(changedLogs, world, pos.m_7918_(0, 0, rand.m_188503_(3) - 1), LOG);
    }

    protected void setLeaf(BiConsumer<BlockPos, BlockState> changedLeaves, WorldGenLevel world, RandomSource rand, BlockPos pos) {
        this.setBlockIfOk(changedLeaves, world, pos, (double)rand.m_188501_() > 0.33 ? LEAF_CANT_GROW : LEAF_CAN_GROW);
    }
}

