/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.block_entity.KeystoneBlockEntity;
import com.legacy.blue_skies.blocks.dungeon.PoisonKeystoneBlock;
import com.legacy.blue_skies.blocks.natural.FruitLeavesBlock;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.util.GeometryHelper;
import com.legacy.blue_skies.util.MLSimplexNoise;
import com.legacy.blue_skies.util.StringUtil;
import com.legacy.blue_skies.world.util.structure_processors.VinesProcessor;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import com.legacy.structure_gel.api.structure.IColoredBoundingBox;
import com.legacy.structure_gel.api.structure.processor.RandomBlockSwapProcessor;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.registries.ForgeRegistries;

public class NatureDungeonPieces {
    private static final ResourceLocation HALL_6 = NatureDungeonPieces.locatePiece("hallways/hallway_6");
    private static final ResourceLocation HALL_7 = NatureDungeonPieces.locatePiece("hallways/hallway_7");
    private static final ResourceLocation HALL_8 = NatureDungeonPieces.locatePiece("hallways/hallway_8");
    private static final ResourceLocation HALL_9 = NatureDungeonPieces.locatePiece("hallways/hallway_9");
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor1Map = NatureDungeonPieces.makeFloorMap(1, 20, 3);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor1EntryMap = NatureDungeonPieces.makeEntryMap(1, 1);
    private static final List<ResourceLocation> floor1Layers = NatureDungeonPieces.makeFloorLayer(1, 12);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor2Map = NatureDungeonPieces.makeFloorMap(2, 20, 4);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor2EntryMap = NatureDungeonPieces.makeEntryMap(2, 1);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor3Map = NatureDungeonPieces.makeFloorMap(3, 18, 4);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor3EntryMap = NatureDungeonPieces.makeEntryMap(3, 1);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor4Map = NatureDungeonPieces.makeFloorMap(4, 18, 4);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor4EntryMap = NatureDungeonPieces.makeEntryMap(4, 1);
    private static final ResourceLocation BOSS_HALL = NatureDungeonPieces.locatePiece("boss/hallway");
    private static final ResourceLocation BOSS_ROOM = NatureDungeonPieces.locatePiece("boss/boss_room");
    private static final ResourceLocation WALL_ENTRY = NatureDungeonPieces.locatePiece("wall/floor_1_entry");
    private static final Wall WALL_1 = new Wall(1);
    private static final Wall WALL_2 = new Wall(2);
    private static final Wall WALL_3 = new Wall(3);
    private static final Wall WALL_4 = new Wall(4);
    private static final ResourceLocation STAIRS = NatureDungeonPieces.locatePiece("entry_stairs");

    private static Map<Room.ConnectionType, List<ResourceLocation>> makeFloorMap(int floor, int width, int variations) {
        HashMap<Room.ConnectionType, List<ResourceLocation>> map = new HashMap<Room.ConnectionType, List<ResourceLocation>>();
        for (Room.ConnectionType type : Room.ConnectionType.values()) {
            ArrayList<ResourceLocation> pieces = new ArrayList<ResourceLocation>();
            switch (type) {
                case EXIT: {
                    pieces.add(NatureDungeonPieces.locatePiece(String.format("exits/floor_%d/exit_%d_0", floor, width)));
                    break;
                }
                default: {
                    for (int i = 0; i < variations; ++i) {
                        pieces.add(NatureDungeonPieces.locatePiece(String.format("rooms/floor_%d/room_%d_%s_%d", floor, width, type.toString(), i)));
                    }
                }
            }
            map.put(type, pieces);
        }
        return map;
    }

    private static Map<Room.ConnectionType, List<ResourceLocation>> makeEntryMap(int floor, int variations) {
        HashMap<Room.ConnectionType, List<ResourceLocation>> map = new HashMap<Room.ConnectionType, List<ResourceLocation>>();
        for (Room.ConnectionType type : new Room.ConnectionType[]{Room.ConnectionType.CROSS, Room.ConnectionType.T, Room.ConnectionType.L, Room.ConnectionType.I, Room.ConnectionType.END}) {
            ArrayList<ResourceLocation> pieces = new ArrayList<ResourceLocation>();
            for (int i = 0; i < variations; ++i) {
                pieces.add(NatureDungeonPieces.locatePiece(String.format("entry/floor_%d/entry_%s_%d", floor, type.toString(), i)));
            }
            map.put(type, pieces);
        }
        return map;
    }

    private static List<ResourceLocation> makeFloorLayer(int floor, int rooms) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < rooms; ++i) {
            list.add(NatureDungeonPieces.locatePiece(String.format("rooms/floor_%d/inside_%d", floor, i)));
        }
        return list;
    }

    public static ResourceLocation locatePiece(String path) {
        return BlueSkies.locate("dungeons/everbright/nature/" + path);
    }

    public static void assemble(StructureTemplateManager templateManager, BlockPos worldPos, Rotation rotation, StructurePiecesBuilder pieces, WorldgenRandom random, ChunkGenerator chunkGen, LevelHeightAccessor level, RandomState randomState) {
        int f1Room = 20;
        int f1Hall = 9;
        int f2Room = 20;
        int f2Hall = 7;
        int f3Room = 18;
        int f3Hall = 8;
        int f4Room = 18;
        int f4Hall = 6;
        worldPos = worldPos.m_7918_(-67, 0, -67);
        FirstFloor floor1 = new FirstFloor(1, f1Room, f1Hall, Floor.potentialExits.get(random.m_188503_(Floor.potentialExits.size())), worldPos, random, HALL_9, floor1Map, floor1EntryMap, floor1Layers, WALL_1);
        Floor floor2 = new Floor(2, f2Room, f2Hall, (Pair<Integer, Integer>)floor1.exitPos, worldPos.m_7918_(4, 15, 4), (RandomSource)random, HALL_7, floor2Map, floor2EntryMap, WALL_2);
        Floor floor3 = new Floor(3, f3Room, f3Hall, floor2.exitPos, worldPos.m_7918_(7, 30, 7), (RandomSource)random, HALL_8, floor3Map, floor3EntryMap, WALL_3);
        Floor floor4 = new Floor(4, f4Room, f4Hall, floor3.exitPos, worldPos.m_7918_(11, 45, 11), (RandomSource)random, HALL_6, floor4Map, floor4EntryMap, WALL_4);
        BossFloor bossFloor = new BossFloor(floor4.exitPos, worldPos.m_7918_(52, 60, 52), (RandomSource)random);
        int fillHeight = 14;
        int f1Stone = f1Room * 5 + f1Hall * 4;
        int f2Stone = f2Room * 5 + f2Hall * 4;
        int f3Stone = f3Room * 5 + f3Hall * 4;
        int f4Stone = f4Room * 5 + f4Hall * 4;
        pieces.m_142679_((StructurePiece)new AirBubblePiece(worldPos.m_7918_(f1Stone / 2, 7, f1Stone / 2).m_5484_(floor1.getEntryDir(), f1Stone / 2 + 5)));
        pieces.m_142679_((StructurePiece)new StoneFillPiece(worldPos, new BlockPos(f1Stone, fillHeight, f1Stone), 0));
        pieces.m_142679_((StructurePiece)new StoneFillPiece(worldPos.m_7918_(4, 15, 4), new BlockPos(f2Stone, fillHeight, f2Stone), 0));
        pieces.m_142679_((StructurePiece)new StoneFillPiece(worldPos.m_7918_(7, 30, 7), new BlockPos(f3Stone, fillHeight, f3Stone), 0));
        pieces.m_142679_((StructurePiece)new StoneFillPiece(worldPos.m_7918_(11, 45, 11), new BlockPos(f4Stone, fillHeight - 3, f4Stone), 0));
        pieces.m_142679_((StructurePiece)new StoneFillPiece(worldPos.m_7918_(-5, -1, -5), new BlockPos(f1Stone + 9, 0, f1Stone + 9), 1));
        pieces.m_142679_((StructurePiece)new GardenPiece(worldPos.m_7918_(11, 56, 11)));
        bossFloor.addPieces(pieces, templateManager);
        floor4.addPieces(pieces, templateManager);
        floor3.addPieces(pieces, templateManager);
        floor2.addPieces(pieces, templateManager);
        floor1.addPieces(pieces, templateManager);
        floor1.addWalls(pieces, templateManager, chunkGen, level, randomState);
        floor2.addWalls(pieces, templateManager, chunkGen, level, randomState);
        floor3.addWalls(pieces, templateManager, chunkGen, level, randomState);
        floor4.addWalls(pieces, templateManager, chunkGen, level, randomState);
    }

    protected static class Room {
        protected boolean north = false;
        protected boolean south = false;
        protected boolean east = false;
        protected boolean west = false;
        protected boolean mainPath = false;
        protected boolean isConnectedToMain = false;
        protected boolean hasKey = false;
        protected Rotation rotation = Rotation.NONE;
        private List<ResourceLocation> structures = new ArrayList<ResourceLocation>();

        public void setPieces(List<ResourceLocation> structures) {
            this.structures.clear();
            this.structures.addAll(structures);
        }

        public ResourceLocation getRandom(RandomSource rand) {
            return this.structures.get(rand.m_188503_(this.structures.size()));
        }

        public boolean isConnected(Direction direction) {
            switch (direction) {
                case NORTH: {
                    return this.north;
                }
                case SOUTH: {
                    return this.south;
                }
                case EAST: {
                    return this.east;
                }
                case WEST: {
                    return this.west;
                }
            }
            return false;
        }

        protected static enum ConnectionType {
            CROSS,
            T,
            L,
            I,
            END,
            EXIT;


            public String toString() {
                return StringUtil.toLower(this.name());
            }
        }
    }

    protected static class FirstFloor
    extends Floor {
        private final List<ResourceLocation> layers;

        public FirstFloor(int floor, int roomWidth, int hallLength, Pair<Integer, Integer> entry, BlockPos worldPos, WorldgenRandom random, ResourceLocation hallway, Map<Room.ConnectionType, List<ResourceLocation>> roomOptions, Map<Room.ConnectionType, List<ResourceLocation>> entryOptions, List<ResourceLocation> layers, Wall wall) {
            super(floor, roomWidth, hallLength, entry, worldPos, (RandomSource)random, hallway, roomOptions, entryOptions, wall);
            this.layers = layers;
        }

        @Override
        public void updateEntry() {
            this.setConnection((Integer)this.entryPos.getFirst(), (Integer)this.entryPos.getSecond(), this.getEntryDir(), true);
        }

        public Direction getEntryDir() {
            if (this.entryPos.equals(Floor.potentialExits.get(0))) {
                return Direction.WEST;
            }
            if (this.entryPos.equals(Floor.potentialExits.get(1))) {
                return Direction.EAST;
            }
            if (this.entryPos.equals(Floor.potentialExits.get(2))) {
                return Direction.NORTH;
            }
            return Direction.SOUTH;
        }

        public void addStairs(Direction entrySide, StructurePiecesBuilder pieces, StructureTemplateManager templateManager, ChunkGenerator chunkGen, LevelHeightAccessor level, RandomState randomState) {
            Rotation rot;
            BlockPos offset = switch (entrySide) {
                case Direction.WEST -> {
                    rot = Rotation.NONE;
                    yield new BlockPos(-9, -3, 65);
                }
                case Direction.EAST -> {
                    rot = Rotation.CLOCKWISE_180;
                    yield new BlockPos(144, -3, 70);
                }
                case Direction.NORTH -> {
                    rot = Rotation.CLOCKWISE_90;
                    yield new BlockPos(70, -3, -9);
                }
                default -> {
                    rot = Rotation.COUNTERCLOCKWISE_90;
                    yield new BlockPos(65, -3, 144);
                }
            };
            for (int i = 0; i < 10; ++i) {
                int xOffset = entrySide.m_122434_() == Direction.Axis.X ? i * 4 * entrySide.m_122421_().m_122540_() : 0;
                int zOffset = entrySide.m_122434_() == Direction.Axis.Z ? i * 4 * entrySide.m_122421_().m_122540_() : 0;
                BlockPos stairPos = this.worldPos.m_121955_((Vec3i)offset.m_7918_(xOffset, i * -4, zOffset));
                pieces.m_142679_((StructurePiece)new Piece(templateManager, stairPos, STAIRS, this.floor, this.rand, rot, 2));
                if (stairPos.m_123342_() < chunkGen.m_214096_(stairPos.m_123341_(), stairPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, level, randomState)) break;
            }
        }

        @Override
        public void addRoom(int x, int z, int roomOffset, int xOffset, int zOffset, Room room, StructureTemplateManager templateManager, StructurePiecesBuilder pieces) {
            super.addRoom(x, z, roomOffset, xOffset, zOffset, room, templateManager, pieces);
            Pair pos = Pair.of((Object)x, (Object)z);
            if (!this.exitPos.equals((Object)pos) && !this.entryPos.equals((Object)pos)) {
                pieces.m_142679_((StructurePiece)new Piece(templateManager, new BlockPos(this.worldPos.m_123341_() + x * roomOffset + xOffset, this.worldPos.m_123342_(), this.worldPos.m_123343_() + z * roomOffset + zOffset), room, this.floor, this.rand, this.layers.get(this.rand.m_188503_(this.layers.size()))));
            }
        }

        @Override
        public ResourceLocation getWallAddStairs(int i, Direction dir, StructurePiecesBuilder pieces, StructureTemplateManager templateManager, ChunkGenerator chunkGen, LevelHeightAccessor level, RandomState randomState) {
            if (i == 2) {
                if (this.entryPos.equals(switch (dir) {
                    case Direction.WEST -> Floor.potentialExits.get(0);
                    case Direction.EAST -> Floor.potentialExits.get(1);
                    case Direction.NORTH -> Floor.potentialExits.get(2);
                    default -> Floor.potentialExits.get(3);
                })) {
                    this.addStairs(dir, pieces, templateManager, chunkGen, level, randomState);
                    return WALL_ENTRY;
                }
            }
            return super.getWallAddStairs(i, dir, pieces, templateManager, chunkGen, level, randomState);
        }
    }

    protected static class Floor {
        protected final List<List<Room>> map;
        protected final Map<Room.ConnectionType, List<ResourceLocation>> roomOptions;
        protected final Map<Room.ConnectionType, List<ResourceLocation>> entryOptions;
        protected final int floor;
        protected final int roomWidth;
        protected final int hallLength;
        protected final BlockPos worldPos;
        protected final RandomSource rand;
        protected final ResourceLocation hallway;
        protected final Wall wall;
        protected Pair<Integer, Integer> entryPos;
        protected Pair<Integer, Integer> exitPos;
        protected static final int size = 5;
        protected static final List<Pair<Integer, Integer>> potentialExits = new ArrayList<Pair<Integer, Integer>>();
        protected static final Direction[] DIRECTIONS;

        public Floor(int floor, int roomWidth, int hallLength, Pair<Integer, Integer> entry, BlockPos worldPos, RandomSource rand, ResourceLocation hallway, Map<Room.ConnectionType, List<ResourceLocation>> roomOptions, Map<Room.ConnectionType, List<ResourceLocation>> entryOptions, Wall wall) {
            this.floor = floor;
            this.roomWidth = roomWidth;
            this.hallLength = hallLength;
            this.entryPos = entry;
            this.worldPos = worldPos;
            this.rand = rand;
            this.hallway = hallway;
            this.roomOptions = roomOptions;
            this.entryOptions = entryOptions;
            this.wall = wall;
            this.map = new ArrayList<List<Room>>(5);
            for (int x = 0; x < 5; ++x) {
                ArrayList<Room> subList = new ArrayList<Room>(5);
                for (int z = 0; z < 5; ++z) {
                    subList.add(new Room());
                }
                this.map.add(subList);
            }
            this.init();
        }

        public void init() {
            int z;
            int x;
            Room room;
            Pair pos;
            int x2;
            int attempts;
            List filteredExitPoses = potentialExits.stream().filter(p -> !p.equals(this.entryPos)).collect(Collectors.toList());
            this.exitPos = (Pair)filteredExitPoses.get(this.rand.m_188503_(filteredExitPoses.size()));
            Pair<Integer, Integer> pointA = this.randomPos();
            if (!this.connectMainPath(this.entryPos, pointA)) {
                this.connectMainPath(pointA, this.exitPos);
            }
            int maxAttempts = 15;
            boolean needsConnections = true;
            for (attempts = 0; needsConnections && attempts < 15; ++attempts) {
                boolean checkAgain = false;
                for (x2 = 0; x2 < 5; ++x2) {
                    for (int z2 = 0; z2 < 5; ++z2) {
                        pos = Pair.of((Object)x2, (Object)z2);
                        room = this.get((Pair<Integer, Integer>)pos).get();
                        if (room.mainPath || room.isConnectedToMain) continue;
                        checkAgain = true;
                        ArrayList connectionOptions = new ArrayList();
                        for (Direction dir : DIRECTIONS) {
                            Pair<Integer, Integer> offsetPos = this.offset(x2, z2, dir);
                            this.get(offsetPos).ifPresent(adjacentRoom -> {
                                if ((adjacentRoom.mainPath || adjacentRoom.isConnectedToMain) && !offsetPos.equals(this.exitPos)) {
                                    connectionOptions.add(dir);
                                }
                            });
                        }
                        if (connectionOptions.isEmpty()) continue;
                        this.setConnection(x2, z2, (Direction)connectionOptions.get(this.rand.m_188503_(connectionOptions.size())), true);
                        room.isConnectedToMain = true;
                    }
                }
                needsConnections = checkAgain;
            }
            if (attempts >= 15) {
                BlueSkies.LOGGER.warn("Nature dungeon could not finish connecting rooms due to reaching max attempts at " + this.worldPos);
            }
            for (x = 0; x < 5; ++x) {
                for (z = 0; z < 5; ++z) {
                    Room room2 = this.get(x, z).get();
                    if (room2.isConnectedToMain || room2.mainPath) continue;
                    BlueSkies.LOGGER.warn("Nature dungeon found invalid room at " + x + ", " + z);
                }
            }
            this.updateEntry();
            for (x = 0; x < 5; ++x) {
                block12: for (z = 0; z < 5; ++z) {
                    Pair pos2 = Pair.of((Object)x, (Object)z);
                    if (!this.get((Pair<Integer, Integer>)pos2).isPresent()) continue;
                    Room room3 = this.get((Pair<Integer, Integer>)pos2).get();
                    List<Direction> conns = this.getSurroundingConnections(x, z);
                    if (this.exitPos.equals((Object)pos2)) {
                        Rotation rot = Rotation.NONE;
                        if (conns.contains(Direction.EAST)) {
                            rot = Rotation.CLOCKWISE_90;
                        } else if (conns.contains(Direction.SOUTH)) {
                            rot = Rotation.CLOCKWISE_180;
                        } else if (conns.contains(Direction.WEST)) {
                            rot = Rotation.COUNTERCLOCKWISE_90;
                        }
                        room3.setPieces(this.roomOptions.get((Object)Room.ConnectionType.EXIT));
                        room3.rotation = rot;
                        continue;
                    }
                    boolean isEntry = this.entryPos.equals((Object)pos2);
                    switch (conns.size()) {
                        case 1: {
                            Rotation rot = Rotation.NONE;
                            if (conns.contains(Direction.EAST)) {
                                rot = Rotation.CLOCKWISE_90;
                            } else if (conns.contains(Direction.SOUTH)) {
                                rot = Rotation.CLOCKWISE_180;
                            } else if (conns.contains(Direction.WEST)) {
                                rot = Rotation.COUNTERCLOCKWISE_90;
                            }
                            room3.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.END) : this.roomOptions.get((Object)Room.ConnectionType.END));
                            room3.rotation = rot;
                            continue block12;
                        }
                        case 2: {
                            if (conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH)) && !conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.EAST, (Object)Direction.WEST))) {
                                room3.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.I) : this.roomOptions.get((Object)Room.ConnectionType.I));
                                room3.rotation = this.rand.m_188499_() ? Rotation.NONE : Rotation.CLOCKWISE_180;
                            } else if (!conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH)) && conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.EAST, (Object)Direction.WEST))) {
                                room3.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.I) : this.roomOptions.get((Object)Room.ConnectionType.I));
                                room3.rotation = this.rand.m_188499_() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
                            }
                            for (Rotation rot : Rotation.values()) {
                                if (!conns.containsAll((Collection<?>)ImmutableList.of((Object)rot.m_55954_(Direction.NORTH), (Object)rot.m_55954_(Direction.WEST)))) continue;
                                room3.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.L) : this.roomOptions.get((Object)Room.ConnectionType.L));
                                room3.rotation = rot;
                                continue block12;
                            }
                            continue block12;
                        }
                        case 3: {
                            Rotation rot = Rotation.NONE;
                            if (!conns.contains(Direction.WEST)) {
                                rot = Rotation.CLOCKWISE_90;
                            } else if (!conns.contains(Direction.NORTH)) {
                                rot = Rotation.CLOCKWISE_180;
                            } else if (!conns.contains(Direction.EAST)) {
                                rot = Rotation.COUNTERCLOCKWISE_90;
                            }
                            room3.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.T) : this.roomOptions.get((Object)Room.ConnectionType.T));
                            room3.rotation = rot;
                            continue block12;
                        }
                        default: {
                            room3.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.CROSS) : this.roomOptions.get((Object)Room.ConnectionType.CROSS));
                            room3.rotation = Rotation.m_221990_((RandomSource)this.rand);
                        }
                    }
                }
            }
            ArrayList<Pair> potentialKeyRooms = new ArrayList<Pair>();
            for (x2 = 0; x2 < 5; ++x2) {
                for (int z3 = 0; z3 < 5; ++z3) {
                    pos = Pair.of((Object)x2, (Object)z3);
                    room = this.get((Pair<Integer, Integer>)pos).get();
                    if (room.mainPath || pos.equals(this.entryPos) || pos.equals(this.exitPos) || !room.isConnectedToMain) continue;
                    potentialKeyRooms.add(pos);
                }
            }
            List potentialKeyDeadEnds = potentialKeyRooms.stream().filter(p -> this.getSurroundingConnections((Integer)p.getFirst(), (Integer)p.getSecond()).size() == 1).collect(Collectors.toList());
            if (!potentialKeyDeadEnds.isEmpty()) {
                this.get((Pair<Integer, Integer>)((Pair)potentialKeyDeadEnds.get((int)this.rand.m_188503_((int)potentialKeyDeadEnds.size())))).get().hasKey = true;
            } else if (potentialKeyRooms.size() > 0) {
                this.get((Pair<Integer, Integer>)((Pair)potentialKeyRooms.get((int)this.rand.m_188503_((int)potentialKeyRooms.size())))).get().hasKey = true;
            } else {
                BlueSkies.LOGGER.error("Nature dungeon at " + this.worldPos + " didn't have any valid key roooms");
            }
        }

        public void updateEntry() {
        }

        public boolean connectMainPath(Pair<Integer, Integer> pointA, Pair<Integer, Integer> pointB) {
            int x = (Integer)pointA.getFirst();
            int z = (Integer)pointA.getSecond();
            int x1 = (Integer)pointB.getFirst();
            int z1 = (Integer)pointB.getSecond();
            ArrayList<Object> path = new ArrayList<Object>();
            path.add(pointA);
            if (this.rand.m_188499_()) {
                while (x != x1) {
                    if (x > x1) {
                        --x;
                    }
                    if (x < x1) {
                        ++x;
                    }
                    path.add(Pair.of((Object)x, (Object)z));
                }
                while (z != z1) {
                    if (z > z1) {
                        --z;
                    }
                    if (z < z1) {
                        ++z;
                    }
                    path.add(Pair.of((Object)x, (Object)z));
                }
            } else {
                while (z != z1) {
                    if (z > z1) {
                        --z;
                    }
                    if (z < z1) {
                        ++z;
                    }
                    path.add(Pair.of((Object)x, (Object)z));
                }
                while (x != x1) {
                    if (x > x1) {
                        --x;
                    }
                    if (x < x1) {
                        ++x;
                    }
                    path.add(Pair.of((Object)x, (Object)z));
                }
            }
            path.add(pointB);
            Pair prev = (Pair)path.get(0);
            for (int i = 0; i < path.size(); ++i) {
                Pair point = (Pair)path.get(i);
                if ((Integer)point.getSecond() < (Integer)prev.getSecond()) {
                    this.setConnection((Integer)point.getFirst(), (Integer)point.getSecond(), Direction.SOUTH, true);
                }
                if ((Integer)point.getSecond() > (Integer)prev.getSecond()) {
                    this.setConnection((Integer)point.getFirst(), (Integer)point.getSecond(), Direction.NORTH, true);
                }
                if ((Integer)point.getFirst() > (Integer)prev.getFirst()) {
                    this.setConnection((Integer)point.getFirst(), (Integer)point.getSecond(), Direction.WEST, true);
                }
                if ((Integer)point.getFirst() < (Integer)prev.getFirst()) {
                    this.setConnection((Integer)point.getFirst(), (Integer)point.getSecond(), Direction.EAST, true);
                }
                this.get((Pair<Integer, Integer>)point).ifPresent(r -> {
                    r.mainPath = true;
                });
                if (point.equals(this.exitPos)) {
                    return true;
                }
                prev = point;
            }
            return false;
        }

        public void setConnection(int x, int z, Direction side, boolean isConnected) {
            Room room = this.get(x, z).get();
            switch (side) {
                case NORTH: {
                    room.north = isConnected;
                    this.get(x, z - 1).ifPresent(r -> {
                        r.south = isConnected;
                    });
                    break;
                }
                case SOUTH: {
                    room.south = isConnected;
                    this.get(x, z + 1).ifPresent(r -> {
                        r.north = isConnected;
                    });
                    break;
                }
                case EAST: {
                    room.east = isConnected;
                    this.get(x + 1, z).ifPresent(r -> {
                        r.west = isConnected;
                    });
                    break;
                }
                default: {
                    room.west = isConnected;
                    this.get(x - 1, z).ifPresent(r -> {
                        r.east = isConnected;
                    });
                }
            }
        }

        public List<Direction> getSurroundingConnections(int x, int z) {
            ArrayList<Direction> list = new ArrayList<Direction>();
            Room room = this.get(x, z).get();
            for (Direction dir : DIRECTIONS) {
                if (!room.isConnected(dir)) continue;
                list.add(dir);
            }
            return list;
        }

        public Pair<Integer, Integer> randomPos() {
            return Pair.of((Object)this.rand.m_188503_(5), (Object)this.rand.m_188503_(5));
        }

        @Nullable
        public Optional<Room> get(int x, int z) {
            if (x >= 0 && x < 5 && z >= 0 && z < 5) {
                return Optional.of(this.map.get(x).get(z));
            }
            return Optional.empty();
        }

        @Nullable
        public Optional<Room> get(Pair<Integer, Integer> pair) {
            return this.get((Integer)pair.getFirst(), (Integer)pair.getSecond());
        }

        @Nullable
        public Optional<Room> get(int x, int z, Direction offset) {
            return this.get(this.offset(x, z, offset));
        }

        public void set(int x, int z, Room segment) {
            this.map.get(x).set(z, segment);
        }

        public Pair<Integer, Integer> offset(int x, int z, Direction direction) {
            return Pair.of((Object)(x + direction.m_122429_()), (Object)(z + direction.m_122431_()));
        }

        public void addPieces(StructurePiecesBuilder piece, StructureTemplateManager templateManager) {
            int roomOffset = this.roomWidth + this.hallLength;
            int hallOffset = this.roomWidth / 2 - 3;
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    Room room = this.get(x, z).get();
                    if (room == null) continue;
                    int xOffset = room.rotation == Rotation.CLOCKWISE_90 || room.rotation == Rotation.CLOCKWISE_180 ? -1 : 0;
                    int zOffset = room.rotation == Rotation.COUNTERCLOCKWISE_90 || room.rotation == Rotation.CLOCKWISE_180 ? -1 : 0;
                    this.addRoom(x, z, roomOffset, xOffset, zOffset, room, templateManager, piece);
                    if ((x * 5 + z) % 2 != 0) continue;
                    switch (this.floor) {
                        case 1: {
                            xOffset = 1;
                            zOffset = -1;
                            break;
                        }
                        case 2: {
                            xOffset = 0;
                            zOffset = 0;
                            break;
                        }
                        case 3: {
                            xOffset = 0;
                            zOffset = -1;
                            break;
                        }
                        default: {
                            xOffset = -1;
                            zOffset = 0;
                        }
                    }
                    if (room.north && this.get(x, z, Direction.NORTH).isPresent()) {
                        piece.m_142679_((StructurePiece)new Piece(templateManager, this.worldPos.m_7918_(x * roomOffset + hallOffset, 0, z * roomOffset - this.hallLength), this.hallway, this.floor, this.rand, Rotation.NONE));
                    }
                    if (room.south && this.get(x, z, Direction.SOUTH).isPresent()) {
                        piece.m_142679_((StructurePiece)new Piece(templateManager, this.worldPos.m_7918_(x * roomOffset + hallOffset, 0, z * roomOffset + this.roomWidth), this.hallway, this.floor, this.rand, Rotation.NONE));
                    }
                    if (room.east && this.get(x, z, Direction.EAST).isPresent()) {
                        piece.m_142679_((StructurePiece)new Piece(templateManager, this.worldPos.m_7918_(x * roomOffset + this.roomWidth + xOffset, 0, z * roomOffset + hallOffset + zOffset), this.hallway, this.floor, this.rand, Rotation.CLOCKWISE_90));
                    }
                    if (!room.west || !this.get(x, z, Direction.WEST).isPresent()) continue;
                    piece.m_142679_((StructurePiece)new Piece(templateManager, this.worldPos.m_7918_(x * roomOffset - this.hallLength + xOffset, 0, z * roomOffset + hallOffset + zOffset), this.hallway, this.floor, this.rand, Rotation.CLOCKWISE_90));
                }
            }
        }

        public void addWalls(StructurePiecesBuilder pieces, StructureTemplateManager templateManager, ChunkGenerator chunkGen, LevelHeightAccessor level, RandomState randomState) {
            int roomOffset = this.roomWidth + this.hallLength;
            int width = this.roomWidth * 5 + this.hallLength * 4;
            for (int i = 0; i < 5; ++i) {
                BlockPos northPos = this.worldPos.m_7918_(i * roomOffset + (this.floor > 2 ? 17 : 19), 0, -5);
                BlockPos southPos = this.worldPos.m_7918_(i * roomOffset, 0, width + 4);
                BlockPos westPos = this.worldPos.m_7918_(-5, 0, i * roomOffset);
                BlockPos eastPos = this.worldPos.m_7918_(width + 4, 0, i * roomOffset + (this.floor > 2 ? 17 : 19));
                pieces.m_142679_((StructurePiece)new Piece(templateManager, northPos, this.getWallAddStairs(i, Direction.NORTH, pieces, templateManager, chunkGen, level, randomState), this.floor, this.rand, Rotation.CLOCKWISE_90, 1));
                pieces.m_142679_((StructurePiece)new Piece(templateManager, southPos, this.getWallAddStairs(i, Direction.SOUTH, pieces, templateManager, chunkGen, level, randomState), this.floor, this.rand, Rotation.COUNTERCLOCKWISE_90, 1));
                pieces.m_142679_((StructurePiece)new Piece(templateManager, westPos, this.getWallAddStairs(i, Direction.WEST, pieces, templateManager, chunkGen, level, randomState), this.floor, this.rand, Rotation.NONE, 1));
                pieces.m_142679_((StructurePiece)new Piece(templateManager, eastPos, this.getWallAddStairs(i, Direction.EAST, pieces, templateManager, chunkGen, level, randomState), this.floor, this.rand, Rotation.CLOCKWISE_180, 1));
                if (i < 4) {
                    pieces.m_142679_((StructurePiece)new Piece(templateManager, northPos.m_7918_(this.hallLength, 0, 0), this.wall.hall, this.floor, this.rand, Rotation.CLOCKWISE_90, 1));
                    pieces.m_142679_((StructurePiece)new Piece(templateManager, southPos.m_7918_(this.roomWidth, 0, 0), this.wall.hall, this.floor, this.rand, Rotation.COUNTERCLOCKWISE_90, 1));
                    pieces.m_142679_((StructurePiece)new Piece(templateManager, westPos.m_7918_(0, 0, this.roomWidth), this.wall.hall, this.floor, this.rand, Rotation.NONE, 1));
                    pieces.m_142679_((StructurePiece)new Piece(templateManager, eastPos.m_7918_(0, 0, this.hallLength), this.wall.hall, this.floor, this.rand, Rotation.CLOCKWISE_180, 1));
                }
                if (i != 0) continue;
                pieces.m_142679_((StructurePiece)new Piece(templateManager, northPos.m_7918_(width - (this.floor > 2 ? 13 : 15), 0, 0), this.wall.corner, this.floor, this.rand, Rotation.CLOCKWISE_90, 1));
                pieces.m_142679_((StructurePiece)new Piece(templateManager, southPos.m_7918_(-5, 0, 0), this.wall.corner, this.floor, this.rand, Rotation.COUNTERCLOCKWISE_90, 1));
                pieces.m_142679_((StructurePiece)new Piece(templateManager, westPos.m_7918_(0, 0, -5), this.wall.corner, this.floor, this.rand, Rotation.NONE, 1));
                pieces.m_142679_((StructurePiece)new Piece(templateManager, eastPos.m_7918_(0, 0, width - (this.floor > 2 ? 13 : 15)), this.wall.corner, this.floor, this.rand, Rotation.CLOCKWISE_180, 1));
            }
        }

        public ResourceLocation getWallAddStairs(int i, Direction dir, StructurePiecesBuilder pieces, StructureTemplateManager templateManager, ChunkGenerator chunkGen, LevelHeightAccessor level, RandomState randomState) {
            return this.wall.room;
        }

        public void addRoom(int x, int z, int roomOffset, int xOffset, int zOffset, Room room, StructureTemplateManager templateManager, StructurePiecesBuilder pieces) {
            pieces.m_142679_((StructurePiece)new Piece(templateManager, this.worldPos.m_7918_(x * roomOffset + xOffset, 0, z * roomOffset + zOffset), room, this.floor, this.rand));
        }

        static {
            potentialExits.add((Pair<Integer, Integer>)Pair.of((Object)0, (Object)2));
            potentialExits.add((Pair<Integer, Integer>)Pair.of((Object)4, (Object)2));
            potentialExits.add((Pair<Integer, Integer>)Pair.of((Object)2, (Object)0));
            potentialExits.add((Pair<Integer, Integer>)Pair.of((Object)2, (Object)4));
            DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        }
    }

    protected static class Wall {
        protected final ResourceLocation room;
        protected final ResourceLocation hall;
        protected final ResourceLocation corner;

        public Wall(int floor) {
            this.room = NatureDungeonPieces.locatePiece("wall/floor_" + floor + "_room");
            this.hall = NatureDungeonPieces.locatePiece("wall/floor_" + floor + "_hall");
            this.corner = NatureDungeonPieces.locatePiece("wall/floor_" + floor + "_corner");
        }
    }

    protected static class BossFloor {
        private final Pair<Integer, Integer> entry;
        private final BlockPos worldPos;
        private final RandomSource rand;

        public BossFloor(Pair<Integer, Integer> entry, BlockPos worldPos, RandomSource random) {
            this.entry = entry;
            this.worldPos = worldPos;
            this.rand = random;
        }

        public void addPieces(StructurePiecesBuilder pieces, StructureTemplateManager templateManager) {
            Rotation rot = this.entry.equals(Floor.potentialExits.get(0)) ? Rotation.COUNTERCLOCKWISE_90 : (this.entry.equals(Floor.potentialExits.get(1)) ? Rotation.CLOCKWISE_90 : (this.entry.equals(Floor.potentialExits.get(2)) ? Rotation.NONE : Rotation.CLOCKWISE_180));
            pieces.m_142679_((StructurePiece)new Piece(templateManager, this.worldPos.m_121955_((Vec3i)(switch (rot) {
                case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(-29, 0, -4);
                case Rotation.CLOCKWISE_90 -> new BlockPos(41, 0, -4);
                case Rotation.NONE -> new BlockPos(6, 0, -39);
                default -> new BlockPos(6, 0, 31);
            })), BOSS_HALL, 5, this.rand, rot));
            Direction.NORTH.m_122427_();
            pieces.m_142679_((StructurePiece)new Piece(templateManager, this.worldPos, BOSS_ROOM, 5, this.rand, rot));
        }
    }

    public static class AirBubblePiece
    extends StructurePiece {
        private static final int BOUND_WIDTH = 15;
        private static final int BOUND_HEIGHT = 25;

        protected AirBubblePiece(BlockPos pos) {
            super((StructurePieceType)SkiesStructures.NATURE_DUNGEON.getPieceType("air_bubble").get(), 0, BoundingBox.m_162375_((Vec3i)pos.m_7918_(-15, -25, -15), (Vec3i)pos.m_7918_(15, 25, 15)));
        }

        public AirBubblePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)SkiesStructures.NATURE_DUNGEON.getPieceType("air_bubble").get(), nbt);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource rand, BoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
            BlockPos center = this.f_73383_.m_162394_();
            for (int x = -15; x < 15; ++x) {
                for (int z = -15; z < 15; ++z) {
                    for (int y = -25; y < 25; ++y) {
                        BlockPos placePos;
                        if (!GeometryHelper.isInEllipsoid(15.0, 25.0, 15.0, x, y, z) || !bounds.m_71051_((Vec3i)(placePos = center.m_7918_(x, y, z)))) continue;
                        world.m_7731_(placePos, Blocks.f_50016_.m_49966_(), 2);
                    }
                }
            }
        }
    }

    public static class StoneFillPiece
    extends StructurePiece {
        protected StoneFillPiece(BlockPos pos, BlockPos size, int componentType) {
            super((StructurePieceType)SkiesStructures.NATURE_DUNGEON.getPieceType("stone_fill").get(), componentType, BoundingBox.m_162375_((Vec3i)pos, (Vec3i)pos.m_121955_((Vec3i)size)));
        }

        public StoneFillPiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)SkiesStructures.NATURE_DUNGEON.getPieceType("stone_fill").get(), nbt);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource rand, BoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
            if (this.f_73384_ == 0) {
                this.m_73441_(world, bounds, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), SkiesBlocks.nature_stone.m_49966_(), SkiesBlocks.nature_stone.m_49966_(), false);
            } else if (this.f_73384_ == 1) {
                for (int x = this.f_73383_.m_162395_(); x <= this.f_73383_.m_162399_(); ++x) {
                    for (int z = this.f_73383_.m_162398_(); z <= this.f_73383_.m_162401_(); ++z) {
                        this.m_73528_(world, SkiesBlocks.nature_stone.m_49966_(), x, this.f_73383_.m_162400_(), z, bounds);
                    }
                }
            }
        }
    }

    public static class GardenPiece
    extends StructurePiece {
        private static int size = 114;

        protected GardenPiece(BlockPos pos) {
            super((StructurePieceType)SkiesStructures.NATURE_DUNGEON.getPieceType("garden").get(), 0, BoundingBox.m_162375_((Vec3i)pos, (Vec3i)pos.m_7918_(size - 1, 21, size - 1)));
        }

        public GardenPiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)SkiesStructures.NATURE_DUNGEON.getPieceType("garden").get(), nbt);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource rand, BoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
            this.m_73441_(world, bounds, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), this.f_73383_.m_162396_() + 2, this.f_73383_.m_162401_(), SkiesBlocks.turquoise_dirt.m_49966_(), SkiesBlocks.turquoise_dirt.m_49966_(), false);
            MLSimplexNoise noise = new MLSimplexNoise(1337L);
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    double h = (noise.m_75464_((double)(this.f_73383_.m_162395_() + x) / 50.0, (double)(this.f_73383_.m_162398_() + z) / 50.0) + 1.0) / 2.0 * 3.0;
                    int border2 = 2;
                    if ((x < border2 - 1 || z < border2 - 1 || x > size - border2 || z > size - border2) && h > 2.0) {
                        h = 1.0;
                    }
                    int y = 0;
                    while ((double)y < h - 1.0) {
                        this.m_73434_(world, SkiesBlocks.turquoise_dirt.m_49966_(), this.f_73383_.m_162395_() + x, this.f_73383_.m_162396_() + 3 + y, this.f_73383_.m_162398_() + z, bounds);
                        ++y;
                    }
                    this.m_73434_(world, SkiesBlocks.turquoise_comet_grass_block.m_49966_(), this.f_73383_.m_162395_() + x, this.f_73383_.m_162396_() + 3 + (int)h, this.f_73383_.m_162398_() + z, bounds);
                    if (!((double)rand.m_188501_() < 0.33)) continue;
                    this.m_73434_(world, ((double)rand.m_188501_() < 0.07 ? SkiesBlocks.blush_blossom : SkiesBlocks.comet_grass).m_49966_(), this.f_73383_.m_162395_() + x, this.f_73383_.m_162396_() + 4 + (int)h, this.f_73383_.m_162398_() + z, bounds);
                }
            }
        }
    }

    public static class Piece
    extends GelTemplateStructurePiece
    implements IColoredBoundingBox {
        private final int floor;
        private final boolean hasKey;
        private final boolean hasChests;
        private final int wallFlags;

        public Piece(StructureTemplateManager templateManager, BlockPos pos, Room room, int floor, RandomSource rand) {
            super((StructurePieceType)SkiesStructures.NATURE_DUNGEON.getPieceType("main").get(), 0, templateManager, room.getRandom(rand), pos);
            this.floor = floor;
            this.hasKey = room.hasKey;
            this.hasChests = room.hasKey || rand.m_188501_() < 0.5f;
            this.wallFlags = 0;
            this.f_73379_ = room.rotation;
            this.setupPlaceSettings(templateManager);
        }

        public Piece(StructureTemplateManager templateManager, BlockPos pos, Room room, int floor, RandomSource rand, ResourceLocation layer) {
            super((StructurePieceType)SkiesStructures.NATURE_DUNGEON.getPieceType("main").get(), 0, templateManager, layer, pos);
            this.floor = floor;
            this.hasKey = room.hasKey;
            this.hasChests = room.hasKey || rand.m_188501_() < 0.5f;
            this.wallFlags = 0;
            this.f_73379_ = room.rotation;
            this.setupPlaceSettings(templateManager);
        }

        public Piece(StructureTemplateManager templateManager, BlockPos pos, ResourceLocation name, int floor, RandomSource rand, Rotation rotation) {
            this(templateManager, pos, name, floor, rand, rotation, 0);
        }

        public Piece(StructureTemplateManager templateManager, BlockPos pos, ResourceLocation name, int floor, RandomSource rand, Rotation rotation, int componentType) {
            super((StructurePieceType)SkiesStructures.NATURE_DUNGEON.getPieceType("main").get(), componentType, templateManager, name, pos);
            this.floor = floor;
            this.hasKey = false;
            this.hasChests = false;
            this.wallFlags = componentType == 1 ? rand.m_188503_(10) : 0;
            this.f_73379_ = rotation;
            this.setupPlaceSettings(templateManager);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)SkiesStructures.NATURE_DUNGEON.getPieceType("main").get(), nbt, context.f_226956_());
            this.floor = nbt.m_128445_("Floor");
            this.hasKey = nbt.m_128471_("HasKey");
            this.hasChests = nbt.m_128471_("HasChests");
            this.wallFlags = nbt.m_128445_("WallFlags");
            this.setupPlaceSettings(context.f_226956_());
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
            super.m_183620_(context, nbt);
            nbt.m_128344_("Floor", (byte)this.floor);
            nbt.m_128379_("HasKey", this.hasKey);
            nbt.m_128379_("HasChests", this.hasChests);
            nbt.m_128344_("WallFlags", (byte)this.wallFlags);
        }

        public StructurePlaceSettings getPlaceSettings(StructureTemplateManager structureManager) {
            Vec3i sizePos = ((StructureTemplate)structureManager.m_230407_(this.m_142415_()).get()).m_163801_();
            BlockPos centerPos = new BlockPos(sizePos.m_123341_() / 2, 0, sizePos.m_123343_() / 2);
            StructurePlaceSettings settings = new StructurePlaceSettings().m_163782_(false).m_74379_(this.f_73379_);
            if (this.f_73384_ == 0) {
                settings.m_74385_(centerPos);
            }
            settings.m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            settings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
            if (this.f_73384_ == 0) {
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.comet_grass, 0.5f, Blocks.f_50016_));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.turquoise_grass, 0.5f, Blocks.f_50016_));
                settings.m_74383_((StructureProcessor)new VinesProcessor());
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stonebrick, 0.1f, SkiesBlocks.glowing_nature_stonebrick));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50075_, SkiesBlocks.nature_stonebrick));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50097_, 0.5f, SkiesBlocks.nature_stone));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50097_, SkiesBlocks.starlit_planks));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50099_, 0.5f, SkiesBlocks.nature_stone));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50099_, SkiesBlocks.nature_stonebrick));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50107_, 0.5f, SkiesBlocks.nature_stone));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50107_, SkiesBlocks.carved_nature_stonebrick));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50100_, 0.5f, SkiesBlocks.nature_stone_slab));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50100_, Blocks.f_50016_));
                if (this.floor == 1 || this.floor == 2) {
                    settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stone, 0.03f, SkiesBlocks.glowing_nature_stone));
                } else if (this.floor == 5) {
                    settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stone, 0.1f, SkiesBlocks.glowing_nature_stone));
                }
            } else if (this.f_73384_ == 1) {
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.turquoise_grass, 0.5f, Blocks.f_50016_));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stone, 0.05f, SkiesBlocks.glowing_nature_stone));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stonebrick, 0.07f, SkiesBlocks.nature_stone));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stonebrick, 0.1f, SkiesBlocks.glowing_nature_stonebrick));
                if (this.wallFlags < 2) {
                    settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50107_, SkiesBlocks.nature_stone));
                } else if (this.wallFlags < 4) {
                    settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50108_, SkiesBlocks.nature_stonebrick));
                } else if (this.wallFlags < 6) {
                    settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50105_, SkiesBlocks.nature_stone));
                } else if (this.wallFlags < 8) {
                    settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50100_, SkiesBlocks.nature_stonebrick));
                }
            }
            return settings;
        }

        @Nullable
        public BlockState modifyState(ServerLevelAccessor world, RandomSource rand, BlockPos pos, BlockState originalState) {
            Block block = originalState.m_60734_();
            if (this.f_73384_ == 0) {
                if (block == Blocks.f_49999_) {
                    if (rand.m_188501_() < 0.5f && originalState.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
                        return (BlockState)SkiesBlocks.nature_stone_pillar.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)originalState.m_61143_((Property)RotatedPillarBlock.f_55923_)));
                    }
                    return SkiesBlocks.nature_stone.m_49966_();
                }
                if (block instanceof LeavesBlock && originalState.m_61138_((Property)LeavesBlock.f_54419_)) {
                    BlockState persistentLeaf = (BlockState)originalState.m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false));
                    if (persistentLeaf.m_61138_(FruitLeavesBlock.GROWTH) && rand.m_188501_() < 0.3f) {
                        persistentLeaf = (BlockState)persistentLeaf.m_61124_(FruitLeavesBlock.GROWTH, (Comparable)((Object)(rand.m_188499_() ? FruitLeavesBlock.Growth.CAN_GROW : FruitLeavesBlock.Growth.GROWN)));
                    }
                    return persistentLeaf;
                }
            } else if (this.f_73384_ == 1) {
                if (block == Blocks.f_50405_) {
                    if (rand.m_188501_() < 0.5f) {
                        return null;
                    }
                    return SkiesBlocks.nature_stone_slab.m_49966_();
                }
                if (block == Blocks.f_50108_ || block == Blocks.f_50100_) {
                    return SkiesBlocks.nature_stone.m_49966_();
                }
                if (block == Blocks.f_50105_ || block == Blocks.f_50107_) {
                    return SkiesBlocks.nature_stonebrick.m_49966_();
                }
            }
            return originalState;
        }

        protected void m_213704_(String key, BlockPos pos, ServerLevelAccessor worldIn, RandomSource rand, BoundingBox sbb) {
            if (key.startsWith("spawner")) {
                if (this.hasChests || (float)rand.m_188502_() < 0.7f) {
                    worldIn.m_7731_(pos, Blocks.f_50085_.m_49966_(), 3);
                    if (worldIn.m_7702_(pos) instanceof SpawnerBlockEntity) {
                        SpawnerBlockEntity tile = (SpawnerBlockEntity)worldIn.m_7702_(pos);
                        tile.m_252803_(SkiesEntityTypes.STONELET, rand);
                    }
                } else {
                    String[] split = key.split("-");
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[1]));
                    if (block != null) {
                        worldIn.m_7731_(pos, block.m_49966_(), 3);
                    }
                }
            }
            if (key.startsWith("chest")) {
                if (this.hasChests) {
                    if (key.endsWith("extra")) {
                        RandomizableContainerBlockEntity.m_222766_((BlockGetter)worldIn, (RandomSource)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)SkiesLootProv.NATURE_CHEST);
                    } else {
                        RandomizableContainerBlockEntity.m_222766_((BlockGetter)worldIn, (RandomSource)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)(this.hasKey ? SkiesLootProv.NATURE_CHEST_KEY : SkiesLootProv.NATURE_CHEST));
                    }
                } else {
                    worldIn.m_7731_(pos.m_7495_(), Blocks.f_50016_.m_49966_(), 3);
                }
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            }
            if ("keystone".equals(key)) {
                worldIn.m_7731_(pos, SkiesBlocks.starlit_planks.m_49966_(), 3);
                BlockEntity tileEntity = worldIn.m_7702_(pos.m_6630_(2));
                if (tileEntity instanceof KeystoneBlockEntity.NatureKeystoneBlockEntity) {
                    KeystoneBlockEntity.NatureKeystoneBlockEntity keystone = (KeystoneBlockEntity.NatureKeystoneBlockEntity)tileEntity;
                    keystone.setTeleportOffset(new BlockPos(0, -1, 0).m_5484_((Direction)worldIn.m_8055_(pos.m_6630_(2)).m_61143_((Property)PoisonKeystoneBlock.FACING), -3));
                    keystone.setSpawnOffset(new BlockPos(0, -1, 0).m_5484_((Direction)worldIn.m_8055_(pos.m_6630_(2)).m_61143_((Property)PoisonKeystoneBlock.FACING), -15));
                }
            }
        }

        public int getBoundingBoxColor() {
            return this.hasKey ? IColoredBoundingBox.RED : IColoredBoundingBox.GREEN;
        }
    }
}

