/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.SkiesSurfaceRuleData;
import com.legacy.blue_skies.world.everbright.EverbrightChunkGenerator;
import com.legacy.blue_skies.world.everdawn.EverdawnChunkGenerator;
import com.legacy.structure_gel.api.dimension.DimensionAccessHelper;
import com.legacy.structure_gel.api.dimension.DimensionTypeBuilder;
import com.legacy.structure_gel.api.registry.registrar.DimensionRegistrar;
import java.util.OptionalLong;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class SkiesDimensions {
    public static final ResourceLocation EVERBRIGHT_ID = BlueSkies.locate("everbright");
    public static final ResourceLocation EVERDAWN_ID = BlueSkies.locate("everdawn");
    public static final DimensionRegistrar EVERBRIGHT = SkiesDimensions.createEverbright();
    public static final DimensionRegistrar EVERDAWN = SkiesDimensions.createEverdawn();

    public static void init() {
    }

    private static DimensionRegistrar createEverbright() {
        Function<BootstapContext, DimensionType> dimType = c -> DimensionTypeBuilder.of().fixedTime(OptionalLong.of(6000L)).minY(0).effects(EVERBRIGHT_ID).build();
        Function<BootstapContext, NoiseGeneratorSettings> noiseSettings = c -> DimensionAccessHelper.newDimensionSettings((NoiseSettings)SkiesDimensions.dummyNoise(), (BlockState)SkiesBlocks.turquoise_stone.m_49966_(), (BlockState)Blocks.f_49990_.m_49966_(), (NoiseRouter)DimensionAccessHelper.noneNoiseRouter(), (SurfaceRules.RuleSource)SkiesSurfaceRuleData.everbright(false, false, true), (int)63, (boolean)false);
        Function<BootstapContext, ChunkGenerator> chunkGen = c -> new EverbrightChunkGenerator((HolderGetter<Biome>)c.m_255420_(Registries.f_256952_), (HolderGetter<NoiseGeneratorSettings>)c.m_255420_(Registries.f_256932_));
        return new DimensionRegistrar(EVERBRIGHT_ID, dimType, noiseSettings, chunkGen);
    }

    private static DimensionRegistrar createEverdawn() {
        Function<BootstapContext, DimensionType> dimType = c -> DimensionTypeBuilder.of().fixedTime(OptionalLong.of(23200L)).minY(0).effects(EVERDAWN_ID).build();
        Function<BootstapContext, NoiseGeneratorSettings> noiseSettings = c -> DimensionAccessHelper.newDimensionSettings((NoiseSettings)SkiesDimensions.dummyNoise(), (BlockState)SkiesBlocks.lunar_stone.m_49966_(), (BlockState)Blocks.f_49990_.m_49966_(), (NoiseRouter)DimensionAccessHelper.noneNoiseRouter(), (SurfaceRules.RuleSource)SkiesSurfaceRuleData.everdawn(false, false, true), (int)63, (boolean)false);
        Function<BootstapContext, ChunkGenerator> chunkGen = c -> new EverdawnChunkGenerator((HolderGetter<Biome>)c.m_255420_(Registries.f_256952_), (HolderGetter<NoiseGeneratorSettings>)c.m_255420_(Registries.f_256932_));
        return new DimensionRegistrar(EVERDAWN_ID, dimType, noiseSettings, chunkGen);
    }

    private static NoiseSettings dummyNoise() {
        return NoiseSettings.m_224525_((int)0, (int)384, (int)1, (int)2);
    }

    public static ResourceKey<Level> everbrightKey() {
        return EVERBRIGHT.getLevelKey();
    }

    public static ResourceKey<Level> everdawnKey() {
        return EVERDAWN.getLevelKey();
    }

    public static boolean inSkyDimension(@Nullable Entity entity) {
        return entity != null && SkiesDimensions.inSkyDimension((ResourceKey<Level>)entity.m_9236_().m_46472_());
    }

    public static boolean inSkyDimension(ResourceKey<Level> levelKey) {
        return levelKey.equals(SkiesDimensions.everbrightKey()) || levelKey.equals(SkiesDimensions.everdawnKey());
    }
}

