/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import com.google.common.collect.Streams;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.tags.SkiesItemTags;
import java.util.EnumMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;

public enum SkiesArmorMaterial implements ArmorMaterial
{
    PYROPE("pyrope", 15, SkiesArmorMaterial.armorValues(1, 4, 5, 2), 12, SoundEvents.f_11677_, 0.0f, () -> Ingredient.m_204132_(SkiesItemTags.PYROPE), true),
    AQUITE("aquite", 15, SkiesArmorMaterial.armorValues(2, 5, 6, 2), 9, SoundEvents.f_11677_, 0.0f, () -> Ingredient.m_204132_(SkiesItemTags.AQUITE), true),
    HORIZONITE("horizonite", 15, SkiesArmorMaterial.armorValues(1, 4, 5, 2), 12, SoundEvents.f_11676_, 0.0f, () -> Ingredient.m_204132_(SkiesItemTags.HORIZONITE), true),
    DIOPSIDE("diopside", 36, SkiesArmorMaterial.armorValues(2, 5, 7, 2), 9, SoundEvents.f_11673_, 4.5f, () -> Ingredient.m_204132_(SkiesItemTags.DIOPSIDE), true),
    CHAROITE("charoite", 33, SkiesArmorMaterial.armorValues(3, 6, 8, 3), 10, SoundEvents.f_11673_, 2.0f, () -> Ingredient.m_204132_(SkiesItemTags.CHAROITE), true),
    SHADOW("shadow", 35, SkiesArmorMaterial.armorValues(3, 6, 8, 3), 10, SoundEvents.f_11673_, 3.0f, () -> Ingredient.m_43938_((Stream)Streams.concat((Stream[])new Stream[]{Stream.of(new Ingredient.TagValue(SkiesItemTags.CHAROITE)), Stream.of(new Ingredient.TagValue(Tags.Items.GEMS_DIAMOND))})), true);

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int maxDamageFactor;
    private final EnumMap<ArmorItem.Type, Integer> damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final boolean compatWithFalsite;
    private final Lazy<Ingredient> repairMaterial;

    private SkiesArmorMaterial(String nameIn, int maxDamage, EnumMap<ArmorItem.Type, Integer> damageReductionArray, int enchantability, SoundEvent equipSound, float toughness, Supplier<Ingredient> repairMaterial, boolean compatWithFalsite) {
        this.name = BlueSkies.find(nameIn);
        this.maxDamageFactor = maxDamage;
        this.damageReductionAmountArray = damageReductionArray;
        this.enchantability = enchantability;
        this.soundEvent = equipSound;
        this.toughness = toughness;
        this.repairMaterial = Lazy.of(repairMaterial);
        this.compatWithFalsite = compatWithFalsite;
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.maxDamageFactor;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.damageReductionAmountArray.get(type);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairMaterial.get();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public boolean isCompatWithFalsite() {
        return this.compatWithFalsite;
    }

    public float m_6649_() {
        return 0.0f;
    }

    public static EnumMap<ArmorItem.Type, Integer> armorValues(int boots, int legs, int chest, int helmet) {
        return (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), material -> {
            material.put(ArmorItem.Type.BOOTS, boots);
            material.put(ArmorItem.Type.LEGGINGS, legs);
            material.put(ArmorItem.Type.CHESTPLATE, chest);
            material.put(ArmorItem.Type.HELMET, helmet);
        });
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = SkiesArmorMaterial.armorValues(13, 15, 16, 11);
    }
}

