/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.buckets;

import com.legacy.blue_skies.entities.passive.fish.JellyDrifterEntity;
import com.legacy.blue_skies.items.buckets.VentiumBucketItem;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VentiumMobBucketItem
extends VentiumBucketItem {
    private final Supplier<? extends EntityType<?>> heldEntityType;
    private final Supplier<? extends SoundEvent> emptySound;

    public VentiumMobBucketItem(Supplier<? extends EntityType<? extends LivingEntity>> heldEntityType, Supplier<? extends SoundEvent> emptySound, Supplier<? extends Fluid> fluid, Item.Properties builder) {
        super(fluid, builder);
        this.heldEntityType = heldEntityType;
        this.emptySound = emptySound;
    }

    public void m_142131_(Player player, Level level, ItemStack stack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            this.spawn((ServerLevel)level, stack, pos);
            level.m_142346_((Entity)player, GameEvent.f_157810_, pos);
        }
    }

    protected void m_7718_(@Nullable Player player, LevelAccessor level, BlockPos pos) {
        level.m_5594_(player, pos, this.getEmptySound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(ServerLevel level, ItemStack bucketStack, BlockPos pos) {
        Entity entity = this.getHeldEntityType().m_20592_(level, bucketStack, (Player)null, pos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            bucketable.m_142278_(bucketStack.m_41784_());
            bucketable.m_27497_(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag compoundnbt;
        if (this.getHeldEntityType() == SkiesEntityTypes.JELLY_DRIFTER && (compoundnbt = stack.m_41783_()) != null && compoundnbt.m_128425_("Color", 99)) {
            byte i = compoundnbt.m_128445_("Color");
            ChatFormatting[] formatting = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
            tooltip.add((Component)Component.m_237115_((String)("entity.blue_skies.jelly_drifter.color." + StringUtil.toLower(JellyDrifterEntity.Colors.byId(i).name()))).m_130944_(formatting));
        }
    }

    protected EntityType<?> getHeldEntityType() {
        return this.heldEntityType.get();
    }

    public SoundEvent getEmptySound() {
        return this.emptySound.get();
    }
}

