/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.capability.entity;

import com.aetherteam.aether.entity.passive.Moa;
import com.legacy.lost_aether.capability.entity.ILCMoa;
import com.legacy.lost_aether.registry.LCMoaTypes;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class LCMoa
implements ILCMoa {
    private Moa moa;
    private float speedMultiplier = 0.0f;
    private float speedMultiplierO;
    private float prevRot;
    private static final String SPEED_MULTIPLIER_KEY = "SpeedMultiplier";

    public LCMoa() {
    }

    public LCMoa(Moa moa) {
        this.moa = moa;
    }

    @Override
    public Capability<ILCMoa> getDefaultInstance() {
        return ILCMoa.INSTANCE;
    }

    @Nullable
    public static ILCMoa get(Moa animal) {
        return LCMoa.getIfPresent(animal, wingedAnimal -> wingedAnimal, () -> null);
    }

    public static <E extends Moa> void ifPresent(E animal, Consumer<ILCMoa> action) {
        Optional optional;
        if (animal != null && (optional = animal.getCapability(ILCMoa.INSTANCE).resolve()).isPresent()) {
            action.accept((ILCMoa)optional.get());
        }
    }

    public static <E extends Moa, R> R getIfPresent(E animal, Function<ILCMoa, R> action, Supplier<R> elseSupplier) {
        Optional optional;
        if (animal != null && (optional = animal.getCapability(ILCMoa.INSTANCE).resolve()).isPresent()) {
            return action.apply((ILCMoa)optional.get());
        }
        return elseSupplier.get();
    }

    @Override
    public void serverTick() {
        LivingEntity rider;
        block12: {
            block11: {
                Entity entity;
                this.speedMultiplierO = this.speedMultiplier;
                if (!this.moa.m_20160_()) {
                    this.speedMultiplier = 0.0f;
                }
                if (!((entity = this.moa.m_146895_()) instanceof LivingEntity)) break block11;
                rider = (LivingEntity)entity;
                if (this.moa.m_9236_().m_5776_()) break block12;
            }
            return;
        }
        if (this.moa.m_20160_() && this.hasSpeedMultiplier()) {
            boolean moving;
            float diff = Math.abs(this.moa.m_6080_() - this.prevRot) * ((float)Math.PI / 180);
            float dist = Mth.m_14154_((float)(this.moa.f_19787_ - this.moa.f_19867_));
            boolean riderMoving = rider.f_20902_ > 0.0f;
            boolean bl = moving = dist >= 0.08f;
            if (this.moa.m_6080_() == this.prevRot && riderMoving && (!this.moa.isEntityOnGround() || moving)) {
                if (this.speedMultiplier < 1.0f) {
                    this.speedMultiplier += (rider.f_20900_ != 0.0f ? 0.003f : 0.005f) * (this.moa.isEntityOnGround() ? 0.2f : 1.0f);
                }
            } else if (this.speedMultiplier > 0.0f) {
                this.speedMultiplier -= 0.6f * (!riderMoving || this.moa.isEntityOnGround() && !moving ? 0.1f : (diff < 0.06f ? 0.02f : diff * 1.2f));
            }
        } else {
            this.speedMultiplier = 0.0f;
        }
        this.speedMultiplier = Mth.m_14036_((float)this.speedMultiplier, (float)0.0f, (float)1.0f);
        this.prevRot = this.moa.m_6080_();
    }

    @Override
    public void modifySpeed(CallbackInfoReturnable<Float> callback) {
        if (!this.getMoa().m_20160_() || !this.hasSpeedMultiplier()) {
            return;
        }
        callback.setReturnValue((Object)Float.valueOf((this.moa.m_6113_() - 0.11f + 0.11f * this.getSpeedMultiplier()) * 0.45f));
    }

    @Override
    public CompoundTag writeAdditional(CompoundTag nbt) {
        nbt.m_128350_(SPEED_MULTIPLIER_KEY, this.speedMultiplier);
        return nbt;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.speedMultiplier = nbt.m_128457_(SPEED_MULTIPLIER_KEY);
    }

    @Override
    public Moa getMoa() {
        return this.moa;
    }

    @Override
    public float getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    @Override
    public float lerpedSpeedMultiplier(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.speedMultiplierO, (float)this.speedMultiplier);
    }

    @Override
    public boolean hasSpeedMultiplier() {
        return this.moa.getMoaType() == LCMoaTypes.ORANGE.get();
    }
}

