/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.collect.Lists;
import com.tom.storagemod.Content;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.PlatformRecipeMenu;
import com.tom.storagemod.tile.StorageTerminalBlockEntity;
import com.tom.storagemod.util.DataSlots;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.StoredItemStack;
import com.tom.storagemod.util.TerminalSyncManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class StorageTerminalMenu
extends PlatformRecipeMenu
implements IDataReceiver,
TerminalSyncManager.InteractHandler {
    protected StorageTerminalBlockEntity te;
    protected int playerSlotsStart;
    protected List<SlotStorage> storageSlotList = new ArrayList<SlotStorage>();
    public List<StoredItemStack> itemList = Lists.newArrayList();
    public List<StoredItemStack> itemListClient = Lists.newArrayList();
    public List<StoredItemStack> itemListClientSorted = Lists.newArrayList();
    public List<SlotData> slotData = new ArrayList<SlotData>();
    public TerminalSyncManager sync = new TerminalSyncManager();
    private int lines;
    protected Inventory pinv;
    public Runnable onPacket;
    public int terminalData;
    public int beaconLvl;
    public String search;
    public boolean noSort;

    public StorageTerminalMenu(int id, Inventory inv, StorageTerminalBlockEntity te) {
        this(Content.storageTerminal.get(), id, inv, te);
        this.addPlayerSlots(inv, 8, 120);
    }

    public StorageTerminalMenu(MenuType<?> type, int id, Inventory inv, StorageTerminalBlockEntity te) {
        super(type, id);
        this.te = te;
        this.pinv = inv;
        this.addStorageSlots();
        this.m_38895_(DataSlots.create(v -> {
            this.terminalData = v;
            if (this.onPacket != null) {
                this.onPacket.run();
            }
        }, () -> te != null ? te.getSorting() : 0));
        this.m_38895_(DataSlots.create(v -> {
            this.beaconLvl = v;
        }, () -> te != null ? te.getBeaconLevel() : 0));
    }

    public StorageTerminalMenu(MenuType<?> type, int id, Inventory inv) {
        this(type, id, inv, null);
    }

    protected void addStorageSlots() {
        this.addStorageSlots(5, 8, 18);
    }

    public StorageTerminalMenu(int id, Inventory inv) {
        this(Content.storageTerminal.get(), id, inv);
        this.addPlayerSlots(inv, 8, 120);
    }

    protected void addPlayerSlots(Inventory playerInventory, int x, int y) {
        int i;
        this.playerSlotsStart = this.f_38839_.size() - 1;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, x + i * 18, y + 58));
        }
    }

    protected Slot m_38897_(Slot slotIn) {
        this.slotData.add(new SlotData(slotIn));
        return super.m_38897_(slotIn);
    }

    public void setOffset(int x, int y) {
        this.slotData.forEach(d -> d.setOffset(x, y));
    }

    public final void addStorageSlots(int lines, int x, int y) {
        this.storageSlotList.clear();
        this.lines = lines;
        for (int i = 0; i < lines; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new SlotStorage(this.te, i * 9 + j, x + j * 18, y + i * 18));
            }
        }
        this.scrollTo(0.0f);
    }

    protected final void addSlotToContainer(SlotStorage slotStorage) {
        this.storageSlotList.add(slotStorage);
    }

    public boolean m_6875_(Player playerIn) {
        return this.te == null || this.te.canInteractWith(playerIn);
    }

    public final void scrollTo(float p_148329_1_) {
        int i = (this.itemListClientSorted.size() + 9 - 1) / 9 - this.lines;
        int j = (int)((double)(p_148329_1_ * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < this.lines; ++k) {
            for (int l = 0; l < 9; ++l) {
                int i1 = l + (k + j) * 9;
                if (i1 >= 0 && i1 < this.itemListClientSorted.size()) {
                    this.setSlotContents(l + k * 9, this.itemListClientSorted.get(i1));
                    continue;
                }
                this.setSlotContents(l + k * 9, null);
            }
        }
    }

    public final void setSlotContents(int id, StoredItemStack stack) {
        this.storageSlotList.get((int)id).stack = stack;
    }

    public final SlotStorage getSlotByID(int id) {
        return this.storageSlotList.get(id);
    }

    public void m_38946_() {
        if (this.te == null) {
            return;
        }
        Map<StoredItemStack, Long> itemsCount = this.te.getStacks();
        this.sync.update(itemsCount, (ServerPlayer)this.pinv.f_35978_, !this.te.getLastSearch().equals(this.search) ? tag -> {
            this.search = this.te.getLastSearch();
            tag.m_128359_("s", this.search);
        } : null);
        super.m_38946_();
    }

    public final void receiveClientNBTPacket(CompoundTag message) {
        if (this.sync.receiveUpdate(message)) {
            this.itemList = this.sync.getAsList();
            if (this.noSort) {
                this.itemListClient.forEach(s -> s.setCount(this.sync.getAmount((StoredItemStack)s)));
            } else {
                this.itemListClient = new ArrayList<StoredItemStack>(this.itemList);
            }
            this.pinv.m_6596_();
        }
        if (message.m_128441_("s")) {
            this.search = message.m_128461_("s");
        }
        if (this.onPacket != null) {
            this.onPacket.run();
        }
    }

    public final ItemStack m_7648_(Player playerIn, int index) {
        if (this.f_38839_.size() > index) {
            if (index > this.playerSlotsStart && this.te != null) {
                if (this.f_38839_.get(index) != null && ((Slot)this.f_38839_.get(index)).m_6657_()) {
                    Slot slot = (Slot)this.f_38839_.get(index);
                    ItemStack slotStack = slot.m_7993_();
                    StoredItemStack c = this.te.pushStack(new StoredItemStack(slotStack, slotStack.m_41613_()));
                    ItemStack itemstack = c != null ? c.getActualStack() : ItemStack.f_41583_;
                    slot.m_5852_(itemstack);
                    if (!playerIn.m_9236_().f_46443_) {
                        this.m_38946_();
                    }
                }
            } else {
                return this.shiftClickItems(playerIn, index);
            }
        }
        return ItemStack.f_41583_;
    }

    protected ItemStack shiftClickItems(Player playerIn, int index) {
        return ItemStack.f_41583_;
    }

    public void m_5816_(StackedContents itemHelperIn) {
    }

    public void m_6650_() {
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> recipeIn) {
        return false;
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return 0;
    }

    public int m_6656_() {
        return 0;
    }

    public int m_6653_() {
        return 0;
    }

    public void sendMessage(CompoundTag compound) {
        NetworkHandler.sendDataToServer(compound);
    }

    @Override
    public void receive(CompoundTag message) {
        if (this.pinv.f_35978_.m_5833_()) {
            return;
        }
        if (message.m_128441_("s")) {
            this.te.setLastSearch(message.m_128461_("s"));
        }
        this.sync.receiveInteract(message, this);
        if (message.m_128441_("c")) {
            CompoundTag d = message.m_128469_("c");
            this.te.setSorting(d.m_128451_("d"));
        }
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int p_150635_) {
        return false;
    }

    @Override
    public void onInteract(StoredItemStack clicked, SlotAction act, boolean mod) {
        ServerPlayer player = (ServerPlayer)this.pinv.f_35978_;
        player.m_9243_();
        if (act == SlotAction.SPACE_CLICK) {
            for (int i = this.playerSlotsStart + 1; i < this.playerSlotsStart + 28; ++i) {
                this.m_7648_((Player)player, i);
            }
        } else if (act == SlotAction.PULL_OR_PUSH_STACK) {
            ItemStack stack = this.m_142621_();
            if (!stack.m_41619_()) {
                StoredItemStack rem = this.te.pushStack(new StoredItemStack(stack));
                ItemStack itemstack = rem == null ? ItemStack.f_41583_ : rem.getActualStack();
                this.m_142503_(itemstack);
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, clicked.getMaxStackSize());
                if (pulled != null) {
                    this.m_142503_(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.PULL_ONE) {
            ItemStack stack = this.m_142621_();
            if (clicked == null) {
                return;
            }
            if (mod) {
                StoredItemStack pulled = this.te.pullStack(clicked, 1L);
                if (pulled != null) {
                    ItemStack itemstack = pulled.getActualStack();
                    this.m_38903_(itemstack, this.playerSlotsStart + 1, this.f_38839_.size(), true);
                    if (itemstack.m_41613_() > 0) {
                        this.te.pushOrDrop(itemstack);
                    }
                    player.m_150109_().m_6596_();
                }
            } else if (!stack.m_41619_()) {
                StoredItemStack pulled;
                if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)clicked.getStack()) && stack.m_41613_() + 1 <= stack.m_41741_() && (pulled = this.te.pullStack(clicked, 1L)) != null) {
                    stack.m_41769_(1);
                }
            } else {
                StoredItemStack pulled = this.te.pullStack(clicked, 1L);
                if (pulled != null) {
                    this.m_142503_(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.GET_HALF) {
            ItemStack stack = this.m_142621_();
            if (!stack.m_41619_()) {
                ItemStack stack1 = stack.m_41620_(Math.max(Math.min(stack.m_41613_(), stack.m_41741_()) / 2, 1));
                ItemStack itemstack = this.te.pushStack(stack1);
                stack.m_41769_(!itemstack.m_41619_() ? itemstack.m_41613_() : 0);
                this.m_142503_(stack);
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, Math.max(Math.min(clicked.getQuantity(), (long)clicked.getMaxStackSize()) / 2L, 1L));
                if (pulled != null) {
                    this.m_142503_(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.GET_QUARTER) {
            ItemStack stack = this.m_142621_();
            if (!stack.m_41619_()) {
                ItemStack stack1 = stack.m_41620_(Math.max(Math.min(stack.m_41613_(), stack.m_41741_()) / 4, 1));
                ItemStack itemstack = this.te.pushStack(stack1);
                stack.m_41769_(!itemstack.m_41619_() ? itemstack.m_41613_() : 0);
                this.m_142503_(stack);
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, Math.max(Math.min(clicked.getQuantity(), (long)clicked.getMaxStackSize()) / 4L, 1L));
                if (pulled != null) {
                    this.m_142503_(pulled.getActualStack());
                }
            }
        } else {
            if (clicked == null) {
                return;
            }
            StoredItemStack pulled = this.te.pullStack(clicked, clicked.getMaxStackSize());
            if (pulled != null) {
                ItemStack itemstack = pulled.getActualStack();
                this.m_38903_(itemstack, this.playerSlotsStart + 1, this.f_38839_.size(), true);
                if (itemstack.m_41613_() > 0) {
                    this.te.pushOrDrop(itemstack);
                }
                player.m_150109_().m_6596_();
            }
        }
    }

    public StorageTerminalBlockEntity getTerminal() {
        return this.te;
    }

    public record SlotData(Slot slot, int x, int y) {
        public SlotData(Slot s) {
            this(s, s.f_40220_, s.f_40221_);
        }

        public void setOffset(int x, int y) {
            this.slot.f_40220_ = this.x + x;
            this.slot.f_40221_ = this.y + y;
        }
    }

    public static class SlotStorage {
        public int xDisplayPosition;
        public int yDisplayPosition;
        private final int slotIndex;
        public final StorageTerminalBlockEntity inventory;
        public StoredItemStack stack;

        public SlotStorage(StorageTerminalBlockEntity inventory, int slotIndex, int xPosition, int yPosition) {
            this.xDisplayPosition = xPosition;
            this.yDisplayPosition = yPosition;
            this.slotIndex = slotIndex;
            this.inventory = inventory;
        }

        public ItemStack pullFromSlot(long max) {
            if (this.stack == null || max < 1L || this.inventory == null) {
                return ItemStack.f_41583_;
            }
            StoredItemStack r = this.inventory.pullStack(this.stack, max);
            if (r != null) {
                return r.getActualStack();
            }
            return ItemStack.f_41583_;
        }

        public ItemStack pushStack(ItemStack pushStack) {
            if (this.inventory == null) {
                return pushStack;
            }
            StoredItemStack r = this.inventory.pushStack(new StoredItemStack(pushStack, pushStack.m_41613_()));
            if (r != null) {
                return r.getActualStack();
            }
            return ItemStack.f_41583_;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }
    }

    public static enum SlotAction {
        PULL_OR_PUSH_STACK,
        PULL_ONE,
        SPACE_CLICK,
        SHIFT_PULL,
        GET_HALF,
        GET_QUARTER;

        public static final SlotAction[] VALUES;

        static {
            VALUES = SlotAction.values();
        }
    }
}

