/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import java.util.Map;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.computer.BaseComputerHelper;
import mekanism.common.integration.computer.ComputerException;
import org.jetbrains.annotations.NotNull;

public class CCComputerHelper
extends BaseComputerHelper {
    private final IArguments arguments;

    public CCComputerHelper(IArguments arguments) {
        this.arguments = arguments;
    }

    @Override
    @NotNull
    public <T extends Enum<T>> T getEnum(int param, Class<T> enumClazz) throws ComputerException {
        try {
            return (T)this.arguments.getEnum(param, enumClazz);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    public boolean getBoolean(int param) throws ComputerException {
        try {
            return this.arguments.getBoolean(param);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    public byte getByte(int param) throws ComputerException {
        try {
            return (byte)this.arguments.getInt(param);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    public short getShort(int param) throws ComputerException {
        try {
            return (short)this.arguments.getInt(param);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    public int getInt(int param) throws ComputerException {
        try {
            return this.arguments.getInt(param);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    public long getLong(int param) throws ComputerException {
        try {
            return this.arguments.getLong(param);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    public char getChar(int param) throws ComputerException {
        try {
            return this.arguments.getString(param).charAt(0);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    public float getFloat(int param) throws ComputerException {
        try {
            return (float)this.arguments.getDouble(param);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    public double getDouble(int param) throws ComputerException {
        try {
            return this.arguments.getDouble(param);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    public FloatingLong getFloatingLong(int param) throws ComputerException {
        try {
            Object opt = this.arguments.get(param);
            if (opt instanceof String) {
                String s = (String)opt;
                return FloatingLong.parseFloatingLong(s);
            }
            double finiteDouble = this.arguments.getFiniteDouble(param);
            if (finiteDouble < 0.0) {
                return FloatingLong.ZERO;
            }
            return FloatingLong.createConst(finiteDouble);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    @NotNull
    public Map<?, ?> getMap(int param) throws ComputerException {
        try {
            return this.arguments.getTable(param);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    @NotNull
    public String getString(int param) throws ComputerException {
        try {
            return this.arguments.getString(param);
        }
        catch (LuaException e) {
            throw new ComputerException((Exception)((Object)e));
        }
    }

    @Override
    public Object voidResult() {
        return MethodResult.of();
    }
}

