/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import mekanism.common.integration.computer.ComputerMethodFactory;
import mekanism.common.integration.computer.MethodHelpData;
import mekanism.common.util.MekCodecs;

public record TableType(String description, String humanName, Map<String, FieldType> fields, Class<?> extendedFrom) {
    public static Codec<TableType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(TableType::description), (App)Codec.STRING.fieldOf("humanName").forGetter(TableType::humanName), (App)Codec.unboundedMap((Codec)Codec.STRING, FieldType.CODEC).optionalFieldOf("fields", Collections.emptyMap()).forGetter(TableType::fields), (App)MekCodecs.CLASS_TO_STRING_CODEC.optionalFieldOf("extends", null).forGetter(TableType::extendedFrom)).apply((Applicative)instance, TableType::new));
    public static Codec<Map<Class<?>, TableType>> TABLE_MAP_CODEC = Codec.unboundedMap(MekCodecs.CLASS_TO_STRING_CODEC, CODEC);

    public static Builder builder(Class<?> clazz, String description) {
        return new Builder(clazz, description);
    }

    public static class Builder {
        private final Class<?> clazz;
        private final String description;
        private final String humanName;
        private final Map<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        private Class<?> extendedFrom = null;

        private Builder(Class<?> clazz, String description) {
            this.clazz = clazz;
            this.description = description;
            this.humanName = MethodHelpData.getHumanType(clazz, ComputerMethodFactory.NO_CLASSES);
        }

        public Builder extendedFrom(Class<?> c) {
            this.extendedFrom = c;
            return this;
        }

        public Builder addField(String name, Class<?> javaType, String description, Class<?> ... javaExtra) {
            if (javaExtra == null) {
                javaExtra = ComputerMethodFactory.NO_CLASSES;
            }
            this.fields.put(name, new FieldType(description, javaType, MethodHelpData.getHumanType(javaType, javaExtra), javaExtra));
            return this;
        }

        public TableType build(Map<Class<?>, TableType> destination) {
            TableType tableType = new TableType(this.description, this.humanName, new LinkedHashMap<String, FieldType>(this.fields), this.extendedFrom);
            destination.put(this.clazz, tableType);
            return tableType;
        }
    }

    public record FieldType(String description, Class<?> javaType, String type, Class<?>[] javaExtra) {
        public static final Codec<FieldType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(FieldType::description), (App)MekCodecs.CLASS_TO_STRING_CODEC.fieldOf("javaType").forGetter(FieldType::javaType), (App)Codec.STRING.fieldOf("type").forGetter(FieldType::type), (App)MekCodecs.optionalClassArrayCodec("javaExtra").forGetter(FieldType::javaExtra)).apply((Applicative)instance, FieldType::new));
    }
}

