/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks;

import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import reliquary.blocks.tile.ApothecaryCauldronBlockEntity;
import reliquary.init.ModBlocks;
import reliquary.items.ICreativeTabItemGenerator;
import reliquary.reference.Settings;
import reliquary.util.BlockEntityHelper;
import reliquary.util.WorldHelper;

public class ApothecaryCauldronBlock
extends Block
implements EntityBlock,
ICreativeTabItemGenerator {
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)3);
    private static final VoxelShape INSIDE = ApothecaryCauldronBlock.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)1.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)1.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)1.0, (double)14.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), Block.m_49796_((double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)13.0, (double)14.0), Block.m_49796_((double)1.0, (double)13.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), Block.m_49796_((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)14.0, (double)2.0), Block.m_49796_((double)1.0, (double)13.0, (double)14.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)14.0, (double)13.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0), Block.m_49796_((double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.m_49796_((double)14.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public ApothecaryCauldronBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(1.5f, 5.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(Settings.COMMON.disable.disablePotions.get())) {
            return;
        }
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEVEL});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return INSIDE;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        ApothecaryCauldronBlockEntity cauldron;
        if (!world.f_46443_ && (cauldron = (ApothecaryCauldronBlockEntity)world.m_7702_(pos)) != null) {
            cauldron.handleCollidingEntity(world, pos, entity);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (world.f_46443_) {
            return !heldItem.m_41619_() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        if (heldItem.m_41619_()) {
            return InteractionResult.CONSUME;
        }
        ApothecaryCauldronBlockEntity cauldron = (ApothecaryCauldronBlockEntity)world.m_7702_(pos);
        if (cauldron != null) {
            return cauldron.handleBlockActivation(world, player, hand, pos);
        }
        return InteractionResult.CONSUME;
    }

    public void m_141997_(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN && level.m_213780_().m_188501_() < 0.05f) {
            WorldHelper.getBlockEntity((BlockGetter)level, pos, ApothecaryCauldronBlockEntity.class).ifPresent(ApothecaryCauldronBlockEntity::fillWithRain);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        ApothecaryCauldronBlockEntity cauldron = (ApothecaryCauldronBlockEntity)world.m_7702_(pos);
        if (cauldron != null) {
            return cauldron.getLiquidLevel();
        }
        return 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ApothecaryCauldronBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BlockEntityHelper.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.APOTHECARY_CAULDRON_TILE_TYPE.get(), (l, p, s, be) -> be.serverTick(l, p));
    }
}

