/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.behaviors.ContainerItemContext;
import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.config.Actionable;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.block.networking.EnergyCellBlockItem;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.hooks.AEToolItem;
import appeng.items.contents.PortableCellMenuHost;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.PlayerSource;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPortableCell
extends AEBasePoweredItem
implements ICellWorkbenchItem,
IMenuItem,
AEToolItem,
DyeableLeatherItem {
    private final MenuType<?> menuType;
    private final int defaultColor;

    public AbstractPortableCell(MenuType<?> menuType, Item.Properties props, int defaultColor) {
        super(AEConfig.instance().getPortableCellBattery(), props);
        this.menuType = menuType;
        this.defaultColor = defaultColor;
    }

    public abstract ResourceLocation getRecipeId();

    @Override
    public abstract double getChargeRate(ItemStack var1);

    public boolean openFromInventory(Player player, int inventorySlot) {
        return this.openFromInventory(player, inventorySlot, false);
    }

    protected boolean openFromInventory(Player player, int inventorySlot, boolean returningFromSubmenu) {
        ItemStack is = player.m_150109_().m_8020_(inventorySlot);
        if (is.m_41720_() == this) {
            return MenuOpener.open(this.menuType, player, MenuLocators.forInventorySlot(inventorySlot), returningFromSubmenu);
        }
        return false;
    }

    @Override
    @Nullable
    public PortableCellMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, @Nullable BlockPos pos) {
        return new PortableCellMenuHost(player, inventorySlot, this, stack, (p, sm) -> this.openFromInventory((Player)p, inventorySlot, true));
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41737_("display");
        if (compoundTag != null && compoundTag.m_128425_("color", 99)) {
            return compoundTag.m_128451_("color");
        }
        return this.defaultColor;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return context.m_7078_() && this.disassembleDrive(stack, context.m_43725_(), context.m_43723_()) ? InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_()) : InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!(InteractionUtil.isInAlternateUseMode(player) && this.disassembleDrive(player.m_21120_(hand), level, player) || level.m_5776_())) {
            MenuOpener.open(this.menuType, player, MenuLocators.forHand(player, hand));
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)player.m_21120_(hand));
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (!AEConfig.instance().isPortableCellDisassemblyEnabled()) {
            return false;
        }
        Recipe recipe = level.m_7465_().m_44043_(this.getRecipeId()).orElse(null);
        if (!(recipe instanceof CraftingRecipe)) {
            AELog.debug("Cannot disassemble portable cell because it's crafting recipe doesn't exist: %s", this.getRecipeId());
            return false;
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
        if (level.m_5776_()) {
            return true;
        }
        Inventory playerInventory = player.m_150109_();
        if (playerInventory.m_36056_() != stack) {
            return false;
        }
        StorageCell inv = StorageCells.getCellInventory(stack, null);
        if (inv == null) {
            return false;
        }
        if (inv.getAvailableStacks().isEmpty()) {
            playerInventory.m_6836_(playerInventory.f_35977_, ItemStack.f_41583_);
            double remainingEnergy = this.getAECurrentPower(stack);
            for (Ingredient ingredient : craftingRecipe.m_7527_()) {
                Item item;
                ItemStack ingredientStack = ingredient.m_43908_()[0].m_41777_();
                if (remainingEnergy > 0.0 && (item = ingredientStack.m_41720_()) instanceof EnergyCellBlockItem) {
                    EnergyCellBlockItem energyCell = (EnergyCellBlockItem)item;
                    remainingEnergy = energyCell.injectAEPower(ingredientStack, remainingEnergy, Actionable.MODULATE);
                }
                playerInventory.m_150079_(ingredientStack);
            }
            for (ItemStack upgrade : this.getUpgrades(stack)) {
                playerInventory.m_150079_(upgrade);
            }
        } else {
            player.m_5661_((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
        }
        return true;
    }

    @Override
    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem(is, 2, this::onUpgradesChanged);
    }

    public void onUpgradesChanged(ItemStack stack, IUpgradeInventory upgrades) {
        this.setAEMaxPowerMultiplier(stack, 1 + Upgrades.getEnergyCardMultiplier(upgrades) * 8);
    }

    public long insert(Player player, ItemStack stack, AEKey what, @Nullable AEKeyType allowed, long amount, Actionable mode) {
        if (allowed != null && allowed.tryCast(what) == null) {
            return 0L;
        }
        PortableCellMenuHost host = this.getMenuHost(player, -1, stack, null);
        if (host == null) {
            return 0L;
        }
        MEStorage inv = host.getInventory();
        if (inv != null) {
            return StorageHelper.poweredInsert(host, inv, what, amount, new PlayerSource(player), mode);
        }
        return 0L;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        ItemStack other = slot.m_7993_();
        if (other.m_41619_()) {
            return true;
        }
        this.tryInsertFromPlayerOwnedItem(player, stack, other);
        return true;
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (other.m_41619_()) {
            return false;
        }
        this.tryInsertFromPlayerOwnedItem(player, stack, other);
        return true;
    }

    protected boolean tryInsertFromPlayerOwnedItem(Player player, ItemStack cellStack, ItemStack otherStack) {
        for (AEKeyType keyType : ContainerItemStrategies.getSupportedKeyTypes()) {
            if (!this.tryInsertFromPlayerOwnedItem(player, cellStack, otherStack, keyType)) continue;
            return true;
        }
        AEItemKey key = AEItemKey.of(otherStack);
        int inserted = (int)this.insert(player, cellStack, key, AEKeyType.items(), otherStack.m_41613_(), Actionable.MODULATE);
        if (inserted > 0) {
            otherStack.m_41774_(inserted);
            return true;
        }
        return false;
    }

    protected boolean tryInsertFromPlayerOwnedItem(Player player, ItemStack cellStack, ItemStack otherStack, AEKeyType keyType) {
        long extracted;
        GenericStack containedStack;
        ContainerItemContext context = ContainerItemStrategies.findOwnedItemContext(keyType, player, otherStack);
        if (context != null && (containedStack = context.getExtractableContent()) != null && this.insert(player, cellStack, containedStack.what(), keyType, containedStack.amount(), Actionable.SIMULATE) == containedStack.amount() && (extracted = context.extract(containedStack.what(), containedStack.amount(), Actionable.MODULATE)) > 0L) {
            this.insert(player, cellStack, containedStack.what(), keyType, extracted, Actionable.MODULATE);
            context.playEmptySound(player, containedStack.what());
            return true;
        }
        return false;
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        Item item;
        if (tintIndex == 1 && (item = stack.m_41720_()) instanceof AbstractPortableCell) {
            AbstractPortableCell portableCell = (AbstractPortableCell)item;
            if (portableCell.getAECurrentPower(stack) <= 0.0) {
                return CellState.ABSENT.getStateColor();
            }
            StorageCell cellInv = StorageCells.getCellInventory(stack, null);
            CellState cellStatus = cellInv != null ? cellInv.getStatus() : CellState.EMPTY;
            return cellStatus.getStateColor();
        }
        if (tintIndex == 2 && (item = stack.m_41720_()) instanceof AbstractPortableCell) {
            AbstractPortableCell portableCell = (AbstractPortableCell)item;
            return portableCell.m_41121_(stack);
        }
        return 0xFFFFFF;
    }
}

