/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.Setting;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ConfigValuePacket
extends BasePacket {
    private final String name;
    private final String value;

    public ConfigValuePacket(FriendlyByteBuf stream) {
        this.name = stream.m_130277_();
        this.value = stream.m_130277_();
    }

    private ConfigValuePacket(String name, String value) {
        this.name = name;
        this.value = value;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.m_130070_(name);
        data.m_130070_(value);
        this.configureWrite(data);
    }

    public <T extends Enum<T>> ConfigValuePacket(Setting<T> setting, T value) {
        this(setting.getName(), value.name());
        if (!setting.getValues().contains(value)) {
            throw new IllegalStateException(value + " not a valid value for " + setting);
        }
    }

    public <T extends Enum<T>> ConfigValuePacket(Setting<T> setting, IConfigManager configManager) {
        this(setting, setting.getValue(configManager));
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        AbstractContainerMenu c = player.f_36096_;
        if (c instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)c;
            this.loadSetting(configurableObject);
        }
    }

    @Override
    public void clientPacketData(Player player) {
        AbstractContainerMenu c = player.f_36096_;
        if (c instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)c;
            this.loadSetting(configurableObject);
        }
    }

    private void loadSetting(IConfigurableObject configurableObject) {
        IConfigManager cm = configurableObject.getConfigManager();
        for (Setting<?> setting : cm.getSettings()) {
            if (!setting.getName().equals(this.name)) continue;
            setting.setFromString(cm, this.value);
            break;
        }
    }
}

