/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.annotation;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.ConstantColor;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.LytErrorSink;
import appeng.client.guidebook.scene.annotation.AnnotationTagCompiler;
import appeng.client.guidebook.scene.annotation.InWorldLineAnnotation;
import appeng.client.guidebook.scene.annotation.SceneAnnotation;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LineAnnotationElementCompiler
extends AnnotationTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("LineAnnotation");
    }

    @Override
    @Nullable
    protected SceneAnnotation createAnnotation(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        Vector3f from = MdxAttrs.getVector3(compiler, errorSink, el, "from", (Vector3fc)new Vector3f());
        Vector3f to = MdxAttrs.getVector3(compiler, errorSink, el, "to", (Vector3fc)new Vector3f());
        ColorValue color = MdxAttrs.getColor(compiler, errorSink, el, "color", ConstantColor.WHITE);
        float thickness = MdxAttrs.getFloat(compiler, errorSink, el, "thickness", 0.03125f);
        boolean alwaysOnTop = MdxAttrs.getBoolean(compiler, errorSink, el, "alwaysOnTop", false);
        InWorldLineAnnotation annotation = new InWorldLineAnnotation(from, to, color, thickness);
        annotation.setAlwaysOnTop(alwaysOnTop);
        return annotation;
    }
}

