/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.registries;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.builders.AetherStructureBuilders;
import com.aetherteam.aether.data.resources.registries.AetherConfiguredFeatures;
import com.aetherteam.aether.data.resources.registries.AetherPlacedFeatures;
import com.aetherteam.aether.world.structure.BronzeDungeonStructure;
import com.aetherteam.aether.world.structure.GoldDungeonStructure;
import com.aetherteam.aether.world.structure.LargeAercloudStructure;
import com.aetherteam.aether.world.structure.SilverDungeonStructure;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;

public class AetherStructures {
    public static final ResourceKey<Structure> LARGE_AERCLOUD = AetherStructures.createKey("large_aercloud");
    public static final ResourceKey<Structure> BRONZE_DUNGEON = AetherStructures.createKey("bronze_dungeon");
    public static final ResourceKey<Structure> SILVER_DUNGEON = AetherStructures.createKey("silver_dungeon");
    public static final ResourceKey<Structure> GOLD_DUNGEON = AetherStructures.createKey("gold_dungeon");

    private static ResourceKey<Structure> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("aether", name));
    }

    public static void bootstrap(BootstapContext<Structure> context) {
        Map<MobCategory, StructureSpawnOverride> mobSpawnsBox = Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146332_())));
        Map<MobCategory, StructureSpawnOverride> mobSpawnsPiece = Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146332_())));
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        HolderGetter placements = context.m_255420_(Registries.f_256988_);
        HolderGetter configurations = context.m_255420_(Registries.f_256911_);
        context.m_255272_(LARGE_AERCLOUD, (Object)new LargeAercloudStructure(AetherStructureBuilders.structure((HolderSet<Biome>)biomes.m_254956_(AetherTags.Biomes.HAS_LARGE_AERCLOUD), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)AetherBlocks.COLD_AERCLOUD.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)))), 3, 32));
        context.m_255272_(BRONZE_DUNGEON, (Object)new BronzeDungeonStructure(AetherStructureBuilders.structure((HolderSet<Biome>)biomes.m_254956_(AetherTags.Biomes.HAS_BRONZE_DUNGEON), mobSpawnsPiece, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, TerrainAdjustment.NONE), 8, 32, 24));
        context.m_255272_(SILVER_DUNGEON, (Object)new SilverDungeonStructure(AetherStructureBuilders.structure((HolderSet<Biome>)biomes.m_254956_(AetherTags.Biomes.HAS_SILVER_DUNGEON), mobSpawnsBox, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), 128, 2, 18, 35, 70));
        context.m_255272_(GOLD_DUNGEON, (Object)new GoldDungeonStructure(AetherStructureBuilders.structure((HolderSet<Biome>)biomes.m_254956_(AetherTags.Biomes.HAS_GOLD_DUNGEON), mobSpawnsBox, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), 8, 20, 40, 60, (Holder<PlacedFeature>)placements.m_255043_(AetherPlacedFeatures.GOLD_DUNGEON_ISLAND_FOLIAGE), (Holder<PlacedFeature>)PlacementUtils.m_206506_((Holder)configurations.m_255043_(AetherConfiguredFeatures.GOLDEN_OAK_TREE_CONFIGURATION), (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)64)})));
    }
}

