/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.common.inventory.ContainerMenuCoFH;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.common.inventory.SlotFalseCopy;
import cofh.lib.common.network.packet.IPacketServer;
import cofh.lib.common.network.packet.PacketBase;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GhostItemPacket
extends PacketBase
implements IPacketServer {
    protected int slotNumber;
    protected ItemStack stack;
    protected int count;

    public GhostItemPacket() {
        super(21, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        ContainerMenuCoFH container;
        Slot slot;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ContainerMenuCoFH && (slot = (container = (ContainerMenuCoFH)abstractContainerMenu).m_38853_(this.slotNumber)) instanceof SlotFalseCopy) {
            slot.m_5852_(ItemHelper.cloneStack(this.stack, this.count));
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.slotNumber);
        buf.writeItemStack(this.stack, false);
        buf.writeInt(this.count);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.slotNumber = buf.readInt();
        this.stack = buf.m_130267_();
        this.count = buf.readInt();
    }

    public static void sendToServer(int slotNumber, ItemStack stack) {
        GhostItemPacket.sendToServer(slotNumber, stack, 1);
    }

    public static void sendToServer(int slotNumber, ItemStack stack, int count) {
        if (slotNumber < 0 || stack.m_41619_() || count < 0) {
            return;
        }
        GhostItemPacket packet = new GhostItemPacket();
        packet.slotNumber = slotNumber;
        packet.stack = stack;
        packet.count = count;
        packet.sendToServer();
    }
}

