/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.plugin;

import com.legacy.lucent.api.EntityBrightness;
import com.legacy.lucent.api.EntityBrightnessMap;
import com.legacy.lucent.api.data.objects.EmissiveArmorTrimTexture;
import com.legacy.lucent.api.data.objects.EntityLighting;
import com.legacy.lucent.api.data.objects.ItemLighting;
import com.legacy.lucent.api.plugin.ILucentPlugin;
import com.legacy.lucent.api.plugin.LucentPlugin;
import com.legacy.lucent.api.registry.ArmorTrimLightingRegistry;
import com.legacy.lucent.api.registry.BlockTextureLightingRegistry;
import com.legacy.lucent.api.registry.EntityLightSourcePosRegistry;
import com.legacy.lucent.api.registry.EntityLightingRegistry;
import com.legacy.lucent.api.registry.ItemLightingRegistry;
import com.legacy.lucent.core.LucentConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@LucentPlugin
public final class InternalLucentPlugin
implements ILucentPlugin {
    @Override
    public void registerItemLightings(ItemLightingRegistry registry) {
        if (((Boolean)LucentConfig.CLIENT.vanillaDynamicLighting.get()).booleanValue()) {
            registry.register(Items.f_42585_, 11);
            registry.register(Items.f_42686_, 15);
            registry.register(Items.f_42696_, 9);
            registry.register(Items.f_42737_, 5);
            registry.register(Items.f_42525_, 10);
            registry.register(Items.f_151079_, 9);
            registry.register(Items.f_151056_, 5);
            registry.register(Items.f_151063_, 2);
            registry.register(Items.f_151025_, 7);
            if (((Boolean)LucentConfig.CLIENT.torchesDoNothingInWater.get()).booleanValue()) {
                for (Item i : BuiltInRegistries.f_257033_) {
                    Block b;
                    int l;
                    if (!(i instanceof BlockItem) || (l = (b = ((BlockItem)i).m_40614_()).m_49966_().m_60791_()) <= 0 || !(b instanceof TorchBlock) && !(b instanceof CampfireBlock) && !(b instanceof CarvedPumpkinBlock) && !(b instanceof FireBlock)) continue;
                    registry.register(ItemLighting.builder().item(i).light(l).worksUnderwater(false));
                }
            }
        }
    }

    @Override
    public void registerEntityLightings(EntityLightingRegistry registry) {
        if (((Boolean)LucentConfig.CLIENT.vanillaDynamicLighting.get()).booleanValue()) {
            registry.register(EntityType.f_20551_, 9);
            registry.register(EntityType.f_20478_, 5);
            registry.register(EntityType.f_20561_, 11);
            registry.register(EntityLighting.builder().entity(EntityType.f_20468_).light(magmaCube -> (magmaCube.m_33632_() + 1) * 2));
            registry.register(EntityLighting.builder().entity(EntityType.f_147034_).light(glowSquid -> (int)Mth.m_144920_((float)0.0f, (float)7.0f, (float)(1.0f - (float)glowSquid.m_147128_() / 10.0f))));
        }
    }

    @Override
    public void registerBlockTextureLightings(BlockTextureLightingRegistry registery) {
        int soulLight = 14;
        registery.register("block/end_portal_frame_eye", 12);
        registery.register("block/soul_lantern", soulLight);
        registery.register("block/soul_campfire_fire", soulLight);
        registery.register("block/soul_fire_0", soulLight);
        registery.register("block/soul_fire_1", soulLight);
        registery.register("block/soul_torch", soulLight);
    }

    @Override
    public void registerEntityLightSourcePositionGetter(EntityLightSourcePosRegistry registry) {
        registry.register(EntityType.f_20548_, Entity::m_20182_);
        registry.register(EntityType.f_20478_, Entity::m_20182_);
    }

    @Override
    public void getEntityLightLevel(EntityBrightness entityBrightness) {
        Entity entity = entityBrightness.getEntity();
        if (entity.m_5833_()) {
            return;
        }
        entityBrightness.setLightLevel(EntityLightingRegistry.get(entity));
        if (((Boolean)LucentConfig.CLIENT.vanillaDynamicLighting.get()).booleanValue()) {
            if (((Boolean)LucentConfig.CLIENT.burningEntitiesGlow.get()).booleanValue() && entity.m_6060_()) {
                entityBrightness.setLightLevel((Integer)LucentConfig.CLIENT.burningEntityLightLevel.get());
            }
            if (((Boolean)LucentConfig.CLIENT.glowingEntitiesGlow.get()).booleanValue() && entity.m_142038_()) {
                entityBrightness.setLightLevel((Integer)LucentConfig.CLIENT.glowingEntityLightLevel.get());
            }
        }
        if (((Boolean)LucentConfig.CLIENT.itemEntitiesGlow.get()).booleanValue() && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            entityBrightness.setLightLevel(ItemLightingRegistry.get(itemEntity.m_32055_()));
        }
        if (((Boolean)LucentConfig.CLIENT.heldItemsGlow.get()).booleanValue() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int light = 0;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                light = Math.max(light, ItemLightingRegistry.get(livingEntity.m_6844_(slot)));
            }
            entityBrightness.setLightLevel(light);
        }
        if (((Boolean)LucentConfig.CLIENT.itemFramesGlow.get()).booleanValue() && entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            entityBrightness.setLightLevel(ItemLightingRegistry.get(itemFrame.m_31822_()));
        }
        if (((Boolean)LucentConfig.CLIENT.creepersGlow.get()).booleanValue() && entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            entityBrightness.setLightLevel((int)(10.0f * creeper.m_32320_(0.0f)));
        }
    }

    @Override
    public void getAdditionalEntityLightLevels(EntityBrightnessMap map) {
    }

    @Override
    public void registerArmorTrimTextureLightings(ArmorTrimLightingRegistry registry) {
        registry.register(new EmissiveArmorTrimTexture((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, 5));
    }

    @Override
    public String ownerModID() {
        return "lucent";
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

