/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.managers.machine.PressRecipeManager;
import cofh.thermal.core.util.recipes.machine.PressRecipe;
import cofh.thermal.expansion.client.gui.machine.MachinePressScreen;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class PressRecipeCategory
extends ThermalRecipeCategory<PressRecipe> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public PressRecipeCategory(IGuiHelper guiHelper, ItemStack icon, RecipeType<PressRecipe> type) {
        super(guiHelper, icon, type);
        this.energyMod = () -> Float.valueOf(PressRecipeManager.instance().getDefaultScale());
        this.background = guiHelper.drawableBuilder(MachinePressScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)((Block)ThermalCore.BLOCKS.get("machine_press")).m_7705_());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(1);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(2);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(1), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(2), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public RecipeType<PressRecipe> getRecipeType() {
        return this.type;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PressRecipe recipe, IFocusGroup focuses) {
        List inputs = recipe.getInputItems();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(recipe.getOutputItems().size());
        List outputFluids = recipe.getOutputFluids();
        for (ItemStack stack : recipe.getOutputItems()) {
            outputs.add(ItemHelper.cloneStack((ItemStack)stack));
        }
        for (int i = 0; i < outputs.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            ((ItemStack)outputs.get(i)).m_41764_((int)chance);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 6).addIngredients((Ingredient)inputs.get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 42).addIngredients(inputs.size() < 2 ? Ingredient.f_43901_ : (Ingredient)inputs.get(1));
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 106, 24);
        if (!outputs.isEmpty()) {
            ((IRecipeSlotBuilder)outputSlot.addItemStack((ItemStack)outputs.get(0))).addTooltipCallback(TCoreJeiPlugin.defaultOutputTooltip((float)((Float)recipe.getOutputItemChances().get(0)).floatValue()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 141, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, outputFluids.isEmpty() ? Collections.emptyList() : List.of((FluidStack)outputFluids.get(0)))).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)4000), false, 16, 40).setOverlay((IDrawable)this.tankOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
    }

    public void draw(PressRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.progressBackground.draw(guiGraphics, 69, 24);
        this.tankBackground.draw(guiGraphics, 140, 10);
        this.speedBackground.draw(guiGraphics, 43, 24);
        if (!recipe.getOutputFluids().isEmpty()) {
            RenderHelper.drawFluid((GuiGraphics)guiGraphics, (int)69, (int)24, (FluidStack)((FluidStack)recipe.getOutputFluids().get(0)), (int)24, (int)16);
            this.progressFluidBackground.draw(guiGraphics, 69, 24);
            this.progressFluid.draw(guiGraphics, 69, 24);
        } else {
            this.progress.draw(guiGraphics, 69, 24);
        }
        this.speed.draw(guiGraphics, 43, 24);
    }
}

