/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.helpers;

import auviotre.enigmatic.addon.contents.brewing.AddonBrewingRecipe;
import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import auviotre.enigmatic.addon.helpers.PotionAddonHelper;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.items.IAdvancedPotionItem;
import com.aizistral.enigmaticlegacy.brewing.AbstractBrewingRecipe;
import com.aizistral.enigmaticlegacy.brewing.ComplexBrewingRecipe;
import com.aizistral.enigmaticlegacy.brewing.SpecialBrewingRecipe;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.helpers.PotionHelper;
import com.aizistral.enigmaticlegacy.objects.AdvancedPotion;
import com.aizistral.enigmaticlegacy.registries.EnigmaticBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIBrewingHelper {
    public static List<IJeiBrewingRecipe> getBrewingRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        List brewingRecipes = BrewingRecipeRegistry.getRecipes();
        Objects.requireNonNull(AbstractBrewingRecipe.class);
        HashSet<Object> recipes = new HashSet<Object>();
        if (OmniconfigAddonHandler.isItemEnabled((Object)EnigmaticAddonItems.ASTRAL_POTION)) {
            AstralRecipe astralRecipe = new AstralRecipe(null);
            recipes.add(astralRecipe);
        }
        for (IBrewingRecipe iBrewingRecipe : brewingRecipes) {
            SpecialBrewingRecipe special;
            ItemStack[] ingredients;
            EnigmaticRecipe recipe;
            ResourceLocation location;
            List<ItemStack> inputs;
            ItemStack[] ingredient;
            ItemStack output;
            Set<Object> potions;
            HashMap<Ingredient, Ingredient> processingMappings;
            if (!(iBrewingRecipe instanceof AbstractBrewingRecipe)) continue;
            AbstractBrewingRecipe brewingRecipe = (AbstractBrewingRecipe)iBrewingRecipe;
            if (brewingRecipe instanceof ComplexBrewingRecipe) {
                ComplexBrewingRecipe complex = (ComplexBrewingRecipe)brewingRecipe;
                processingMappings = complex.getProcessingMappings();
                potions = processingMappings.keySet();
                if (potions.isEmpty()) continue;
                output = complex.getOutput();
                for (Ingredient potion : potions) {
                    ingredient = processingMappings.get(potion).m_43908_();
                    inputs = Arrays.stream(potion.m_43908_()).filter(stack -> !stack.m_41619_()).toList();
                    if (output.m_41619_() || inputs.isEmpty()) continue;
                    location = new ResourceLocation("enigmaticlegacy", ItemNBTHelper.getString((ItemStack)output, (String)"EnigmaticPotion", (String)"unknown"));
                    recipe = new EnigmaticRecipe(List.of(ingredient), inputs, output, location, vanillaRecipeFactory);
                    recipes.add(recipe);
                }
                continue;
            }
            if (brewingRecipe instanceof AddonBrewingRecipe) {
                AddonBrewingRecipe addon = (AddonBrewingRecipe)brewingRecipe;
                processingMappings = addon.getProcessingMappings();
                potions = processingMappings.keySet();
                if (potions.isEmpty()) continue;
                output = addon.getOutput();
                for (Ingredient potion : potions) {
                    ingredient = processingMappings.get(potion).m_43908_();
                    inputs = Arrays.stream(potion.m_43908_()).filter(stack -> !stack.m_41619_()).toList();
                    if (output.m_41619_() || inputs.isEmpty()) continue;
                    location = new ResourceLocation("enigmaticaddons", ItemNBTHelper.getString((ItemStack)output, (String)"EnigmaticPotion", (String)"unknown"));
                    recipe = new EnigmaticRecipe(List.of(ingredient), inputs, output, location, vanillaRecipeFactory);
                    recipes.add(recipe);
                }
                continue;
            }
            if (!(brewingRecipe instanceof SpecialBrewingRecipe) || (ingredients = (special = (SpecialBrewingRecipe)brewingRecipe).getIngredient().m_43908_()).length <= 0) continue;
            Ingredient inputIngredient = special.getInput();
            output = special.getOutput();
            List<ItemStack> inputs2 = Arrays.stream(inputIngredient.m_43908_()).filter(stack -> !stack.m_41619_()).toList();
            if (output.m_41619_() || inputs2.isEmpty()) continue;
            IJeiBrewingRecipe recipe2 = vanillaRecipeFactory.createBrewingRecipe(List.of(ingredients), inputs2, output, ForgeRegistries.ITEMS.getKey((Object)output.m_41720_()));
            recipes.add(recipe2);
        }
        return new ArrayList<IJeiBrewingRecipe>(recipes);
    }

    public static class AstralRecipe
    implements IJeiBrewingRecipe {
        private final int hashCode;
        private final ResourceLocation uid;

        public AstralRecipe(ResourceLocation uid) {
            this.uid = uid;
            this.hashCode = uid != null ? uid.hashCode() : Objects.hash(new Object[]{List.of(EnigmaticBlocks.ASTRAL_BLOCK), List.of(Items.f_42787_), EnigmaticAddonItems.ASTRAL_POTION});
        }

        public List<ItemStack> getPotionInputs() {
            return List.of(new ItemStack((ItemLike)Items.f_42787_));
        }

        public List<ItemStack> getIngredients() {
            return List.of(new ItemStack((ItemLike)EnigmaticBlocks.ASTRAL_BLOCK));
        }

        public ItemStack getPotionOutput() {
            return new ItemStack((ItemLike)EnigmaticAddonItems.ASTRAL_POTION);
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Nullable
        public ResourceLocation getUid() {
            return this.uid;
        }

        public int getBrewingSteps() {
            return 1;
        }

        public String toString() {
            return "astral_addon_brewing_recipe";
        }
    }

    public static class EnigmaticRecipe
    implements IJeiBrewingRecipe {
        private final List<ItemStack> ingredients;
        private final List<ItemStack> potionInputs;
        private final ItemStack potionOutput;
        private final int hashCode;
        private final ResourceLocation uid;
        private final IJeiBrewingRecipe vanillaRecipe;

        public EnigmaticRecipe(List<ItemStack> ingredients, List<ItemStack> potionInputs, ItemStack potionOutput, ResourceLocation uid, IVanillaRecipeFactory factory) {
            this.ingredients = List.copyOf(ingredients);
            this.potionInputs = List.copyOf(potionInputs);
            this.potionOutput = potionOutput;
            this.uid = uid;
            this.vanillaRecipe = factory.createBrewingRecipe(ingredients, potionInputs, potionOutput, uid);
            this.hashCode = uid != null ? uid.hashCode() : Objects.hash(ingredients.stream().map(ItemStack::m_41720_).toList(), potionInputs.stream().map(ItemStack::m_41720_).toList(), potionOutput.m_41720_());
        }

        private static boolean arePotionsNotEqual(ItemStack potion1, ItemStack potion2) {
            Item item2;
            Item item1 = potion1.m_41720_();
            if (item1 != (item2 = potion2.m_41720_())) {
                return true;
            }
            Potion type1 = PotionUtils.m_43579_((ItemStack)potion1);
            Potion type2 = PotionUtils.m_43579_((ItemStack)potion2);
            if (item1 instanceof IAdvancedPotionItem) {
                IAdvancedPotionItem advancedPotion1 = (IAdvancedPotionItem)item1;
                IAdvancedPotionItem advancedPotion2 = (IAdvancedPotionItem)item2;
                if (advancedPotion1.getPotionType() != advancedPotion2.getPotionType()) {
                    return true;
                }
                if (PotionHelper.getAdvancedPotion((ItemStack)potion1) != PotionHelper.getAdvancedPotion((ItemStack)potion2)) {
                    return true;
                }
                return PotionAddonHelper.getAdvancedPotion(potion1) != PotionAddonHelper.getAdvancedPotion(potion2);
            }
            return !Objects.equals(type2, type1);
        }

        public List<ItemStack> getPotionInputs() {
            return this.potionInputs;
        }

        public List<ItemStack> getIngredients() {
            return this.ingredients;
        }

        public ItemStack getPotionOutput() {
            return this.potionOutput;
        }

        public int getBrewingSteps() {
            return this.vanillaRecipe.getBrewingSteps();
        }

        public boolean equals(Object obj) {
            if (obj instanceof EnigmaticRecipe) {
                int i;
                EnigmaticRecipe other = (EnigmaticRecipe)obj;
                for (i = 0; i < this.potionInputs.size(); ++i) {
                    ItemStack otherPotionInput;
                    ItemStack potionInput = this.potionInputs.get(i);
                    if (!EnigmaticRecipe.arePotionsNotEqual(potionInput, otherPotionInput = other.potionInputs.get(i))) continue;
                    return false;
                }
                if (EnigmaticRecipe.arePotionsNotEqual(other.potionOutput, this.potionOutput)) {
                    return false;
                }
                if (this.ingredients.size() != other.ingredients.size()) {
                    return false;
                }
                for (i = 0; i < this.ingredients.size(); ++i) {
                    if (ItemStack.m_41728_((ItemStack)this.ingredients.get(i), (ItemStack)other.ingredients.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Nullable
        public ResourceLocation getUid() {
            return this.uid;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            Potion inputType = PotionUtils.m_43579_((ItemStack)this.potionInputs.get(0));
            Potion outputType = PotionUtils.m_43579_((ItemStack)this.potionOutput);
            return this.ingredients + " + [" + this.potionInputs.get(0).m_41720_() + " " + inputType.m_43492_("") + "] = [" + this.potionOutput + " " + outputType.m_43492_("") + "]";
        }
    }

    public static class SubtypeInterpreter
    implements IIngredientSubtypeInterpreter<ItemStack> {
        public static final SubtypeInterpreter LEGACY_INSTANCE = new SubtypeInterpreter(true);
        public static final SubtypeInterpreter ADDON_INSTANCE = new SubtypeInterpreter(false);
        private final boolean legacy;

        private SubtypeInterpreter(boolean legacy) {
            this.legacy = legacy;
        }

        public String apply(@NotNull ItemStack itemStack, UidContext context) {
            if (!itemStack.m_41782_() || !(itemStack.m_41720_() instanceof IAdvancedPotionItem)) {
                return "";
            }
            IAdvancedPotionItem.PotionType potionType = ((IAdvancedPotionItem)itemStack.m_41720_()).getPotionType();
            AdvancedPotion advancedPotion = this.legacy ? PotionHelper.getAdvancedPotion((ItemStack)itemStack) : PotionAddonHelper.getAdvancedPotion(itemStack);
            StringBuilder stringBuilder = new StringBuilder(advancedPotion.getId()).append(";").append(potionType.toString());
            for (MobEffectInstance effect : advancedPotion.getEffects()) {
                stringBuilder.append(";").append(effect);
            }
            return stringBuilder.toString();
        }
    }
}

