/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.BerserkEmblem;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SanguinaryHandbook
extends ItemBase
implements ICursed {
    public static Omniconfig.DoubleParameter DamageMultiplier;

    public SanguinaryHandbook() {
        super(SanguinaryHandbook.getDefaultProperties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("SanguinaryHuntingHandbook");
        DamageMultiplier = builder.comment("The damage boost on pet of Sanguinary Hunting Handbook.").min(0.0).getDouble("DamageMultiplier", 0.25);
        builder.popPrefix();
    }

    public static Multimap<Attribute, AttributeModifier> createAttributeMap(Player player) {
        HashMultimap attributesDefault = HashMultimap.create();
        float missingHealthPool = SuperpositionHandler.getMissingHealthPool((Player)player);
        attributesDefault.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("f4ece564-d299-40d2-a96a-dc68b493137c"), "enigmaticlegacy:speed_modifier", (double)missingHealthPool * BerserkEmblem.movementSpeed.getValue() * 1.25, AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.sanguinaryHandbook1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.sanguinaryHandbook2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + DamageMultiplier.getValue() * 100.0 + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.sanguinaryHandbook3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.sanguinaryHandbook4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.sanguinaryHandbook5");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }
}

