/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.EnigmaticAddons;
import auviotre.enigmatic.addon.contents.entities.DisasterChaos;
import auviotre.enigmatic.addon.packets.clients.PacketDisasterParry;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class DisasterSword
extends ItemBase
implements Vanishable {
    public static Omniconfig.DoubleParameter badOmenBoost;
    public static Omniconfig.DoubleParameter counterattackBoost;
    public static Omniconfig.DoubleParameter critBoost;
    public static Omniconfig.DoubleParameter rangeAttackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public DisasterSword() {
        super(ItemBase.getDefaultProperties().m_41486_().m_41497_(Rarity.EPIC).m_41503_(2400));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 9.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.3f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("DisasterBroadsword");
        badOmenBoost = builder.comment("The damage modifier when you has the Bad Omen effect.").max(100.0).min(0.0).getDouble("BadOmenDamageBoost", 0.15);
        counterattackBoost = builder.comment("The damage modifier after you parried with Disaster Broadsword successfully.").max(100.0).min(0.0).getDouble("CounterattackBoost", 0.5);
        critBoost = builder.comment("The crit damage modifier after you parried with Disaster Broadsword successfully.").max(100.0).min(0.0).getDouble("CritBoost", 1.5);
        rangeAttackDamage = builder.comment("The damage of range attack after you parried the projectiles with Disaster Broadsword successfully.").max(100.0).min(0.0).getDouble("RangeAttackDamage", 10.0);
    }

    public static void parry(Level level, Player blocker, DamageSource source, float damage) {
        LivingEntity living;
        if (!level.m_5776_()) {
            EnigmaticAddons.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(blocker.m_20185_(), blocker.m_20186_(), blocker.m_20189_(), 64.0, level.m_46472_())), (Object)new PacketDisasterParry(blocker.m_20185_(), blocker.m_20186_(), blocker.m_20189_(), 1));
        }
        Entity directEntity = source.m_7640_();
        ItemStack useItem = blocker.m_21211_();
        useItem.m_41622_(Mth.m_14143_((float)(damage / 2.0f)), (LivingEntity)blocker, user -> user.m_21190_(blocker.m_7655_()));
        blocker.m_36335_().m_41527_(useItem.m_41720_());
        blocker.m_5810_();
        blocker.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 2, 0, true, false));
        blocker.m_6674_(blocker.m_7655_());
        if (directEntity instanceof LivingEntity && blocker != (living = (LivingEntity)directEntity)) {
            List entities = level.m_45976_(LivingEntity.class, blocker.m_20191_().m_82400_(3.2));
            for (LivingEntity entity : entities) {
                if (entity == blocker) continue;
                Vec3 delta = entity.m_20182_().m_82546_(blocker.m_20182_()).m_82541_().m_82490_(0.5);
                float modifier = Math.min(1.0f, 0.8f / entity.m_20270_((Entity)blocker));
                Vec3 vec = new Vec3(delta.f_82479_, 0.0, delta.f_82481_).m_82541_().m_82490_((double)modifier);
                entity.m_246865_(new Vec3(vec.f_82479_, entity.m_20096_() ? (double)(1.2f * modifier) : 0.0, vec.f_82481_));
                entity.getPersistentData().m_128405_("DisasterCurse", 30);
                entity.m_6469_(entity.m_269291_().m_269333_((LivingEntity)blocker), 4.0f);
                entity.f_19802_ = 5;
            }
            blocker.m_36335_().m_41524_(useItem.m_41720_(), 24);
            SuperpositionHandler.setPersistentInteger((Player)blocker, (String)"DisasterCounterattack", (int)40);
        } else if (directEntity instanceof Projectile) {
            blocker.m_36335_().m_41524_(useItem.m_41720_(), 8);
            SuperpositionHandler.setPersistentInteger((Player)blocker, (String)"DisasterCounterRange", (int)25);
        }
    }

    public static void tick(Player player) {
        int counterattack = SuperpositionHandler.getPersistentInteger((Player)player, (String)"DisasterCounterattack", (int)0);
        if (counterattack > 0) {
            SuperpositionHandler.setPersistentInteger((Player)player, (String)"DisasterCounterattack", (int)(counterattack - 1));
        } else {
            SuperpositionHandler.removePersistentTag((Player)player, (String)"DisasterCounterattack");
        }
        int counterRange = SuperpositionHandler.getPersistentInteger((Player)player, (String)"DisasterCounterRange", (int)0);
        if (counterRange > 0) {
            SuperpositionHandler.setPersistentInteger((Player)player, (String)"DisasterCounterRange", (int)(counterRange - 1));
        } else {
            SuperpositionHandler.removePersistentTag((Player)player, (String)"DisasterCounterRange");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.disasterSword1", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + String.format("%.0f", 100.0 * badOmenBoost.getValue()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.disasterSword2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.disasterSword3");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.disasterSword1_alt");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        if (stack.m_41793_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (SuperpositionHandler.getPersistentInteger((Player)player, (String)"DisasterCounterRange", (int)0) > 0) {
            if (!level.f_46443_) {
                DisasterChaos chaos = new DisasterChaos(level, (LivingEntity)player);
                chaos.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.2f, 1.0f);
                level.m_7967_((Entity)chaos);
                player.m_36335_().m_41524_(itemInHand.m_41720_(), 20);
                EnigmaticAddons.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 16.0, level.m_46472_())), (Object)new PacketDisasterParry(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0));
            }
            player.m_6674_(hand);
        } else {
            player.m_6672_(hand);
            player.m_36335_().m_41524_(itemInHand.m_41720_(), 80);
        }
        return InteractionResultHolder.m_19096_((Object)itemInHand);
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        if (SuperpositionHandler.getPersistentInteger((Player)player, (String)"DisasterCounterattack", (int)0) > 0) {
            return target.m_20191_().m_82377_(10.0, 0.3, 10.0);
        }
        return super.getSweepHitBox(stack, player, target);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(2, entity, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean m_6832_(ItemStack self, ItemStack stack) {
        return stack.m_150930_(Items.f_42418_) || super.m_6832_(self, stack);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 15;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(Items.f_42393_.m_7968_(), enchantment);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }
}

