/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.EnigmaticAddons;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.packets.clients.PacketDescendingChaos;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.addon.registries.EnigmaticAddonParticles;
import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.IBindable;
import com.aizistral.enigmaticlegacy.api.items.IEldritch;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.objects.TransientPlayerData;
import com.aizistral.enigmaticlegacy.objects.Vector3;
import com.aizistral.enigmaticlegacy.packets.server.PacketUpdateElytraBoosting;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ChaosElytra
extends ItemBaseCurio
implements IBindable,
IEldritch {
    private static final AttributeModifier ELYTRA_MODIFIER = new AttributeModifier(UUID.fromString("446f9584-38bb-4fc0-bbed-16d126e377a7"), "enigmaticaddons:elytra_modifier", 1.0, AttributeModifier.Operation.ADDITION);
    @OnlyIn(value=Dist.CLIENT)
    private static boolean isBoosting;
    public static Omniconfig.DoubleParameter flyingSpeedModifier;
    public static Omniconfig.DoubleParameter descendingPowerModifier;
    public static Omniconfig.IntParameter descendingCooldown;
    public static Omniconfig.PerhapsParameter damageResistance;
    private Vec3 lastMovement = Vec3.f_82478_;

    public ChaosElytra() {
        super(ItemBaseCurio.getDefaultProperties().m_41503_(3600).m_41486_().m_41497_(Rarity.EPIC));
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("TheArroganceofChaos");
        flyingSpeedModifier = builder.comment("The flying speed modifier when elytra boost.").max(10.0).min(1.0).getDouble("FlyingSpeedModifier", 1.6);
        descendingPowerModifier = builder.comment("The damage modifier when hit the ground with elytra boost.").max(10.0).min(1.0).getDouble("DescendingPowerModifier", 1.6);
        descendingCooldown = builder.comment("The cooldown of special descending skill of The Arrogance of Chaos.").max(2400.0).min(200.0).getInt("DescendingCooldown", 500);
        damageResistance = builder.comment("The special damage resistance of The Arrogance of Chaos. Measured in percentage.").max(100.0).min(0.0).getPerhaps("DamageResistance", 80);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.enigmaticElytra1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.enigmaticElytra2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.enigmaticElytra3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.chaosElytra1", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{damageResistance + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.chaosElytra2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.chaosElytra3");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateWorthyOnesOnly(list);
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)livingEntity;
        return SuperpositionHandler.isTheWorthyOne((Player)player) && super.canEquip(context, stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int id, boolean selected) {
        Player player;
        if (entity instanceof Player && !SuperpositionHandler.isTheWorthyOne((Player)(player = (Player)entity))) {
            ItemStack itemStack = player.m_6844_(EquipmentSlot.CHEST);
            ItemStack copy = itemStack.m_41777_();
            if (itemStack.m_150930_((Item)this)) {
                Block.m_49840_((Level)level, (BlockPos)player.m_20183_(), (ItemStack)itemStack);
                player.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            }
        }
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity;
        int ticks;
        LivingEntity livingEntity2 = context.entity();
        if (livingEntity2 instanceof Player) {
            Player player = (Player)livingEntity2;
            if (player.m_9236_().f_46443_) {
                this.handleBoosting(player);
            }
        }
        if ((ticks = (livingEntity = context.entity()).m_21256_()) > 0 && livingEntity.m_21255_()) {
            stack.elytraFlightTick(livingEntity, ticks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleBoosting(Player player) {
        if (Minecraft.m_91087_().f_91074_ == player) {
            if (Minecraft.m_91087_().f_91066_.f_92089_.m_90857_() && this.boostPlayer(player)) {
                if (!isBoosting) {
                    PacketDistributor.PacketTarget target = PacketDistributor.SERVER.noArg();
                    isBoosting = true;
                    EnigmaticLegacy.packetInstance.send(target, (Object)new PacketUpdateElytraBoosting(true));
                }
            } else if (isBoosting) {
                PacketDistributor.PacketTarget target = PacketDistributor.SERVER.noArg();
                isBoosting = false;
                EnigmaticLegacy.packetInstance.send(target, (Object)new PacketUpdateElytraBoosting(false));
            }
        }
    }

    private boolean boostPlayer(Player player) {
        if (player.m_21255_()) {
            Vec3 look = player.m_20154_().m_82490_(flyingSpeedModifier.getValue());
            Vec3 move = player.m_20184_();
            player.m_20256_(move.m_82520_(look.f_82479_ * 0.1 + (look.f_82479_ * 1.5 - move.f_82479_) * 0.5, look.f_82480_ * 0.1 + (look.f_82480_ * 1.5 - move.f_82480_) * 0.5, look.f_82481_ * 0.1 + (look.f_82481_ * 1.5 - move.f_82481_) * 0.5));
            return true;
        }
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        return HashMultimap.create();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        EquipmentSlot slotForItem = Mob.m_147233_((ItemStack)itemInHand);
        ItemStack itemBySlot = player.m_6844_(slotForItem);
        if (itemBySlot.m_41619_()) {
            player.m_8061_(slotForItem, itemInHand.m_41777_());
            if (!level.m_5776_()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            itemInHand.m_41764_(0);
            return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemInHand);
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        Player player;
        return entity instanceof Player && SuperpositionHandler.isTheWorthyOne((Player)(player = (Player)entity)) && ElytraItem.m_41140_((ItemStack)stack);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!entity.m_9236_().f_46443_) {
                int nextFlightTick = flightTicks + 1;
                if (nextFlightTick % 10 == 0) {
                    if (nextFlightTick % 20 == 0) {
                        stack.m_41622_(1, entity, living -> living.m_21166_(EquipmentSlot.CHEST));
                    }
                    entity.m_146850_(GameEvent.f_223705_);
                }
            } else {
                this.handleBoosting(player);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Player player2;
            ItemStack stack = null;
            AttributeInstance attribute = event.player.m_21051_(CaelusApi.getInstance().getFlightAttribute());
            attribute.m_22130_(ELYTRA_MODIFIER);
            if (!attribute.m_22109_(ELYTRA_MODIFIER) && (stack = SuperAddonHandler.getChaosElytra((LivingEntity)event.player)) != null && stack.m_150930_((Item)this) && ElytraItem.m_41140_((ItemStack)stack)) {
                attribute.m_22118_(ELYTRA_MODIFIER);
            }
            if ((player2 = event.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                if (serverPlayer.f_19797_ % 4 == 0) {
                    this.lastMovement = serverPlayer.m_21255_() ? serverPlayer.m_20184_() : Vec3.f_82478_;
                }
                if (TransientPlayerData.get((Player)serverPlayer).isElytraBoosting()) {
                    int flightTicks;
                    int nextFlightTick;
                    this.boostPlayer((Player)serverPlayer);
                    if (stack != null && stack.m_150930_((Item)this) && (nextFlightTick = (flightTicks = serverPlayer.m_21256_()) + 1) % 5 == 0) {
                        stack.m_41622_(1, (LivingEntity)serverPlayer, player -> player.m_21166_(EquipmentSlot.CHEST));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onFall(PlayerFlyableFallEvent event) {
        Player player;
        Player victim = event.getEntity();
        if (!(victim instanceof Player) || !SuperpositionHandler.isTheWorthyOne((Player)(player = victim))) {
            return;
        }
        if (SuperpositionHandler.getFullEquipment((Player)player).stream().noneMatch(itemStack -> itemStack.m_150930_((Item)EnigmaticAddonItems.CHAOS_ELYTRA))) {
            return;
        }
        if (TransientPlayerData.get((Player)player).isElytraBoosting()) {
            this.chaosDescending(player);
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        Player player;
        LivingEntity victim = event.getEntity();
        if (!(victim instanceof Player) || !SuperpositionHandler.isTheWorthyOne((Player)(player = (Player)victim))) {
            return;
        }
        if (SuperpositionHandler.getFullEquipment((Player)player).stream().noneMatch(itemStack -> itemStack.m_150930_((Item)EnigmaticAddonItems.CHAOS_ELYTRA))) {
            return;
        }
        if (TransientPlayerData.get((Player)player).isElytraBoosting()) {
            event.setCanceled(true);
            this.chaosDescending(player);
        }
    }

    private void chaosDescending(Player player) {
        if (player.m_20252_((float)0.0f).f_82480_ < -0.95 && !player.m_36335_().m_41519_((Item)this)) {
            if (!player.m_150110_().f_35937_) {
                player.m_36335_().m_41524_((Item)this, descendingCooldown.getValue());
            }
            if (!player.m_9236_().m_5776_()) {
                EnigmaticAddons.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 64.0, player.m_9236_().m_46472_())), (Object)new PacketDescendingChaos(player.m_20185_(), player.m_20186_(), player.m_20189_()));
            }
            List entities = player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(3.5 + this.lastMovement.m_82553_()));
            for (LivingEntity entity : entities) {
                if (entity == player) continue;
                Vec3 delta = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(0.5);
                float modifier = Math.min(1.0f, 1.2f / entity.m_20270_((Entity)player));
                Vec3 vec = new Vec3(delta.f_82479_, 0.0, delta.f_82481_).m_82541_().m_82490_((double)modifier);
                entity.m_246865_(new Vec3(vec.f_82479_, entity.m_20096_() ? (double)(1.2f * modifier) : 0.0, vec.f_82481_));
                entity.m_6469_(entity.m_269291_().m_269333_((LivingEntity)player), (float)(player.m_21051_(Attributes.f_22281_).m_22135_() * Math.pow(descendingPowerModifier.getValue(), Math.abs(this.lastMovement.f_82480_))));
            }
        }
    }

    @SubscribeEvent
    public void onHurt(LivingDamageEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player) || !SuperpositionHandler.isTheWorthyOne((Player)(player = (Player)entity))) {
            return;
        }
        if (SuperpositionHandler.getFullEquipment((Player)player).stream().noneMatch(itemStack -> itemStack.m_150930_((Item)EnigmaticAddonItems.CHAOS_ELYTRA))) {
            return;
        }
        DamageSource source = event.getSource();
        if (!source.m_276093_(DamageTypes.f_268671_) && !source.m_276093_(DamageTypes.f_268576_)) {
            Entity directEntity = event.getSource().m_7640_();
            if (directEntity != null && directEntity.m_20182_().m_82546_(player.m_20182_()).m_82526_(player.m_20156_()) < 0.0) {
                event.setAmount(event.getAmount() * damageResistance.getValue().asModifierInverted());
            }
        } else {
            event.setAmount(event.getAmount() * damageResistance.getValue().asModifierInverted());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerTickClient(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.m_9236_().m_5776_()) {
            Player player = event.player;
            if (!SuperpositionHandler.isTheWorthyOne((Player)player)) {
                return;
            }
            if (SuperpositionHandler.getFullEquipment((Player)player).stream().noneMatch(itemStack -> itemStack.m_150930_((Item)EnigmaticAddonItems.CHAOS_ELYTRA))) {
                return;
            }
            if (TransientPlayerData.get((Player)player).isElytraBoosting() && player.m_21255_()) {
                int amount = 3;
                double rangeModifier = 0.1;
                for (int counter = 0; counter <= amount; ++counter) {
                    Vector3 vec = Vector3.fromEntityCenter((Entity)player);
                    vec = vec.add(Math.random() - 0.5, -1.0 + Math.random() - 0.5, Math.random() - 0.5);
                    player.m_9236_().m_6493_((ParticleOptions)EnigmaticAddonParticles.ABYSS_CHAOS, true, vec.x, vec.y, vec.z, (Math.random() - 0.5) * 2.0 * rangeModifier, (Math.random() - 0.5) * 2.0 * rangeModifier, (Math.random() - 0.5) * 2.0 * rangeModifier);
                }
            }
        }
    }
}

