/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.entities;

import auviotre.enigmatic.addon.EnigmaticAddons;
import auviotre.enigmatic.addon.client.particles.StarDustParticle;
import auviotre.enigmatic.addon.contents.entities.AbstractSpear;
import auviotre.enigmatic.addon.contents.items.AstralSpear;
import auviotre.enigmatic.addon.packets.clients.PacketStarParticles;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEntities;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class ThrownAstralSpear
extends AbstractSpear {
    private static final EntityDataAccessor<Byte> ID_SHARPNESS = SynchedEntityData.m_135353_(ThrownAstralSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownAstralSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ID_TARGET = SynchedEntityData.m_135353_(ThrownAstralSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ID_POWERED = SynchedEntityData.m_135353_(ThrownAstralSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final double seekDistance = 4.0;
    private static final double seekAngle = 0.20943951023931953;
    private static final double seekThreshold = 0.5;
    public int clientReturnTickCount;
    private boolean dealtDamage;
    private ItemStack spearItem = new ItemStack((ItemLike)EnigmaticAddonItems.ASTRAL_SPEAR);
    @Nullable
    private IntOpenHashSet ignoreEntityIds;

    public ThrownAstralSpear(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world, (Item)EnigmaticAddonItems.ASTRAL_SPEAR);
        this.m_36781_(12.0);
    }

    public ThrownAstralSpear(LivingEntity entity, Level world, ItemStack itemStack) {
        super(EnigmaticAddonEntities.ASTRAL_SPEAR, entity, world, (Item)EnigmaticAddonItems.ASTRAL_SPEAR);
        this.spearItem = itemStack.m_41777_();
        this.f_19804_.m_135381_(ID_SHARPNESS, (Object)((byte)itemStack.getEnchantmentLevel(Enchantments.f_44977_)));
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)itemStack)));
        this.m_36767_((byte)itemStack.getEnchantmentLevel(Enchantments.f_44961_));
        this.m_36781_(12.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SHARPNESS, (Object)0);
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_TARGET, (Object)-1);
        this.f_19804_.m_135372_(ID_POWERED, (Object)false);
    }

    public void m_8119_() {
        byte loyalty;
        super.m_8119_();
        if (this.f_36704_ > 3) {
            this.dealtDamage = true;
        }
        Entity owner = this.m_19749_();
        if (this.isPowered() && !this.dealtDamage && owner != null) {
            if (this.m_20270_(this.m_19749_()) > 64.0f) {
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_20256_(this.m_20184_().m_82490_(1.25));
            }
        }
        if ((loyalty = ((Byte)this.f_19804_.m_135370_(ID_LOYALTY)).byteValue()) > 0 && (this.dealtDamage || this.m_36797_()) && owner != null) {
            if (!this.isAcceptableReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 delta = owner.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + delta.f_82480_ * 0.015 * (double)loyalty, this.m_20189_());
                double scale = 0.2 * (double)loyalty;
                this.m_20256_(this.m_20184_().m_82490_(0.8).m_82549_(delta.m_82541_().m_82490_(scale)));
                if (this.clientReturnTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.5f);
                }
                ++this.clientReturnTickCount;
            }
        }
        if (!this.dealtDamage && !this.f_36703_) {
            this.updateTarget();
            Entity target = this.getTarget();
            if (target != null) {
                Vec3 targetVec = this.getVectorToTarget(target);
                Vec3 courseVec = this.m_20184_();
                double courseLen = courseVec.m_82553_();
                double targetLen = targetVec.m_82553_();
                double dotProduct = courseVec.m_82526_(targetVec) / (courseLen * targetLen);
                if (dotProduct > 0.5) {
                    double factor = (double)this.m_36796_() * 0.03 + 0.2;
                    factor = Mth.m_14008_((double)factor, (double)0.2, (double)0.35) * (this.isPowered() ? 0.5 : 1.0);
                    Vec3 newMotion = courseVec.m_82490_(1.0 - factor).m_82549_(targetVec.m_82490_(courseLen / targetLen * factor));
                    this.m_20256_(newMotion.m_82520_(0.0, (double)0.01f, 0.0));
                    this.f_19812_ = true;
                } else {
                    this.setTarget(null);
                }
            }
        }
        if (!this.f_36703_ && this.m_9236_().m_5776_()) {
            Vec3 vec3 = this.m_20184_();
            double dx = vec3.f_82479_;
            double dy = vec3.f_82480_;
            double dz = vec3.f_82481_;
            double length = vec3.m_82553_() * 1.44;
            int i = 0;
            while ((double)i < length + 1.0) {
                this.m_9236_().m_7106_(StarDustParticle.get(this.f_19796_), this.m_20208_(0.1f) + dx * (double)i / length, this.m_20187_() + dy * (double)i / length, this.m_20262_(0.1f) + dz * (double)i / length, -dx * 0.1, -dy * 0.1, -dz * 0.1);
                if (this.f_36703_) break;
                ++i;
            }
        }
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 vec1, Vec3 vec2) {
        return this.dealtDamage ? null : super.m_6351_(vec1, vec2);
    }

    private void m_36723_() {
        if (this.ignoreEntityIds != null) {
            this.ignoreEntityIds.clear();
        }
    }

    private void stop() {
        this.dealtDamage = true;
        this.m_20256_(this.m_20184_().m_82542_(-0.02, -0.1, -0.02));
        if (this.isPowered()) {
            this.m_20256_(this.m_20184_().m_82490_(0.2));
        }
        this.f_19812_ = true;
    }

    protected void m_5790_(EntityHitResult hitResult) {
        DamageSource damageSource;
        Entity entity = hitResult.m_82443_();
        Entity owner = this.m_19749_();
        if (!this.isPowered() && this.m_36796_() > 0 && entity.m_6084_()) {
            if (this.ignoreEntityIds == null) {
                this.ignoreEntityIds = new IntOpenHashSet(9);
            }
            Vec3 movement = this.m_20184_().m_82490_(0.9);
            AABB box = this.m_20191_().m_82383_(movement).m_82377_(movement.f_82479_, movement.f_82480_, movement.f_82481_);
            boolean predictNoTarget = true;
            for (int i = 0; i < 5 && predictNoTarget; ++i) {
                List entityList = this.m_9236_().m_45976_(LivingEntity.class, box);
                box = box.m_82383_(movement.m_82520_(0.0, -0.2, 0.0));
                for (LivingEntity living : entityList) {
                    if (living.m_7306_(entity) || !this.m_5603_((Entity)living) || living == this.m_19749_()) continue;
                    predictNoTarget = false;
                }
            }
            if (this.ignoreEntityIds.size() >= this.m_36796_() || predictNoTarget) {
                this.stop();
            }
            this.ignoreEntityIds.add(entity.m_19879_());
        } else {
            this.stop();
        }
        double damage = this.m_36789_() + (double)((Byte)this.f_19804_.m_135370_(ID_SHARPNESS) > 0 ? (Byte)this.f_19804_.m_135370_(ID_SHARPNESS) : (byte)0);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            damage += (double)EnchantmentHelper.m_44833_((ItemStack)this.spearItem, (MobType)livingEntity.m_6336_());
        }
        if (entity.m_6469_(damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner)), (float)damage)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (!this.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)living, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)living);
                }
                this.m_7761_(living);
            }
        }
        if (this.isPowered()) {
            this.areaAttack(this.m_9236_(), (HitResult)hitResult, damageSource, (float)damage);
            this.setPowered(false);
            this.stop();
        }
        this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
    }

    protected void m_8060_(BlockHitResult hitResult) {
        if (this.isPowered() && !this.dealtDamage) {
            Entity owner = this.m_19749_();
            double damage = this.m_36789_() + (double)((Byte)this.f_19804_.m_135370_(ID_SHARPNESS) > 0 ? (Byte)this.f_19804_.m_135370_(ID_SHARPNESS) : (byte)0);
            DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
            this.areaAttack(this.m_9236_(), (HitResult)hitResult, damageSource, (float)damage);
            this.setPowered(false);
            this.dealtDamage = true;
        }
        super.m_8060_(hitResult);
        this.m_36723_();
    }

    protected void areaAttack(Level level, HitResult result, DamageSource source, float damage) {
        damage *= (float)AstralSpear.poweredModifier.getValue();
        Vec3 location = result.m_82450_();
        if (result instanceof EntityHitResult) {
            EntityHitResult hitResult = (EntityHitResult)result;
            location.m_82520_(0.0, (double)hitResult.m_82443_().m_20206_() * 0.75, 0.0);
        }
        if (!level.f_46443_) {
            EnigmaticAddons.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(location.f_82479_, location.f_82480_, location.f_82481_, 64.0, level.m_46472_())), (Object)new PacketStarParticles(location.f_82479_, location.f_82480_, location.f_82481_, 160, 0));
        }
        ThrownAstralSpear owner = this.m_19749_() == null ? this : this.m_19749_();
        List entities = level.m_45933_((Entity)this, this.m_20191_().m_82383_(location.m_82546_(this.m_20182_())).m_82400_(5.0));
        for (Entity target : entities) {
            if (!(target instanceof LivingEntity) || !target.m_6084_() || target == owner || target == this) continue;
            target.m_6469_(source, damage);
        }
        this.m_5496_(SoundEvents.f_12515_, 2.0f, 0.0f);
        this.m_36723_();
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && (this.ignoreEntityIds == null || !this.ignoreEntityIds.contains(entity.m_19879_()));
    }

    private boolean isAcceptableReturnOwner() {
        Entity owner = this.m_19749_();
        if (owner != null && owner.m_6084_()) {
            return !(owner instanceof ServerPlayer) || !owner.m_5833_();
        }
        return false;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("AstralSpear", 10)) {
            this.spearItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("AstralSpear"));
        }
        this.dealtDamage = tag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.spearItem)));
        this.f_19804_.m_135381_(ID_SHARPNESS, (Object)((byte)this.spearItem.getEnchantmentLevel(Enchantments.f_44977_)));
        this.setPowered(tag.m_128471_("IsPowered"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("AstralSpear", (Tag)this.spearItem.m_41739_(new CompoundTag()));
        tag.m_128379_("DealtDamage", this.dealtDamage);
        tag.m_128379_("IsPowered", this.isPowered());
    }

    @Override
    public ItemStack getItem() {
        return this.spearItem.m_41777_();
    }

    protected ItemStack m_7941_() {
        return this.spearItem.m_41777_();
    }

    public void m_6901_() {
        byte loyalty = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || loyalty <= 0) {
            super.m_6901_();
        }
    }

    private void updateTarget() {
        Entity target = this.getTarget();
        if (target != null && !target.m_6084_()) {
            target = null;
            this.setTarget(null);
        }
        if (target == null) {
            AABB positionBB;
            AABB targetBB = positionBB = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            Vec3 courseVec = this.m_20184_().m_82490_(4.0).m_82524_(0.20943952f);
            targetBB = targetBB.m_82367_(positionBB.m_82383_(courseVec));
            courseVec = this.m_20184_().m_82490_(4.0).m_82524_(-0.20943952f);
            targetBB = targetBB.m_82367_(positionBB.m_82383_(courseVec));
            targetBB = targetBB.m_82377_(0.0, 2.0, 0.0);
            double closestDot = -1.0;
            LivingEntity closestTarget = null;
            List entityList = this.m_9236_().m_45976_(LivingEntity.class, targetBB);
            List<LivingEntity> monsters = entityList.stream().filter(living -> living instanceof Monster).toList();
            if (!monsters.isEmpty()) {
                for (LivingEntity monster : monsters) {
                    if (((Monster)monster).m_5448_() != this.m_19749_() || !this.m_5603_((Entity)monster)) continue;
                    this.setTarget((Entity)monster);
                    return;
                }
                for (LivingEntity monster : monsters) {
                    if (monster instanceof NeutralMob || !monster.m_142582_((Entity)this) || !this.m_5603_((Entity)monster)) continue;
                    this.setTarget((Entity)monster);
                    return;
                }
            }
            for (LivingEntity living2 : entityList) {
                Vec3 targetVec;
                Vec3 motionVec;
                double dot;
                TamableAnimal animal;
                if (!living2.m_142582_((Entity)this) || living2 == this.m_19749_() || this.m_19749_() != null && living2 instanceof TamableAnimal && (animal = (TamableAnimal)living2).m_269323_() == this.m_19749_() || !this.m_5603_((Entity)living2) || !((dot = (motionVec = this.m_20184_().m_82541_()).m_82526_(targetVec = this.getVectorToTarget((Entity)living2).m_82541_())) > Math.max(closestDot, 0.5))) continue;
                closestDot = dot;
                closestTarget = living2;
            }
            if (closestTarget != null) {
                this.setTarget((Entity)closestTarget);
            }
        }
    }

    private Vec3 getVectorToTarget(Entity target) {
        return new Vec3(target.m_20185_() - this.m_20185_(), target.m_20227_((double)0.81f) - this.m_20186_(), target.m_20189_() - this.m_20189_());
    }

    @Nullable
    private Entity getTarget() {
        return this.m_9236_().m_6815_(((Integer)this.m_20088_().m_135370_(ID_TARGET)).intValue());
    }

    private void setTarget(@Nullable Entity entity) {
        this.m_20088_().m_135381_(ID_TARGET, (Object)(entity == null ? -1 : entity.m_19879_()));
    }

    public boolean isPowered() {
        return (Boolean)this.f_19804_.m_135370_(ID_POWERED);
    }

    public void setPowered(boolean isPowered) {
        this.f_19804_.m_135381_(ID_POWERED, (Object)isPowered);
    }
}

