/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.recipes.ban;

import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.ban.AbstractPlacementBanRecipe;
import com.aetherteam.aether.recipe.serializer.PlacementBanRecipeSerializer;
import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class ItemBanRecipe
extends AbstractPlacementBanRecipe<class_1799, class_1856> {
    public ItemBanRecipe(class_2960 id, @Nullable class_5321<class_1959> biomeKey, @Nullable class_6862<class_1959> biomeTag, BlockStateIngredient bypassBlock, class_1856 ingredient) {
        super((class_3956)AetherRecipeTypes.ITEM_PLACEMENT_BAN.get(), id, biomeKey, biomeTag, bypassBlock, ingredient);
    }

    public ItemBanRecipe(class_2960 id, @Nullable class_5321<class_1959> biomeKey, @Nullable class_6862<class_1959> biomeTag, BlockStateIngredient bypassBlock) {
        this(id, biomeKey, biomeTag, bypassBlock, class_1856.field_9017);
    }

    public boolean banItem(class_1937 level, class_2338 pos, class_2350 direction, class_1799 stack, boolean spawnParticles) {
        if (this.matches(level, pos, stack) && AetherEventDispatch.isItemPlacementBanned((class_1936)level, pos, stack)) {
            if (spawnParticles) {
                AetherEventDispatch.onPlacementSpawnParticles((class_1936)level, pos, direction, stack, null);
            }
            return true;
        }
        return false;
    }

    public class_1865<?> method_8119() {
        return (class_1865)AetherRecipeSerializers.ITEM_PLACEMENT_BAN.get();
    }

    public static class Serializer
    extends PlacementBanRecipeSerializer<class_1799, class_1856, ItemBanRecipe> {
        public Serializer() {
            super(ItemBanRecipe::new);
        }

        @Override
        public ItemBanRecipe fromJson(class_2960 id, JsonObject json) {
            ItemBanRecipe recipe = (ItemBanRecipe)super.fromJson(id, json);
            if (!json.has("ingredient")) {
                throw new JsonSyntaxException("Missing ingredient, expected to find an object or array");
            }
            JsonArray jsonElement = class_3518.method_15264((JsonObject)json, (String)"ingredient") ? class_3518.method_15261((JsonObject)json, (String)"ingredient") : class_3518.method_15296((JsonObject)json, (String)"ingredient");
            class_1856 ingredient = class_1856.method_52177((JsonElement)jsonElement);
            return new ItemBanRecipe(id, recipe.getBiomeKey(), recipe.getBiomeTag(), recipe.getBypassBlock(), ingredient);
        }

        @Override
        @Nullable
        public ItemBanRecipe fromNetwork(class_2960 id, class_2540 buffer) {
            class_5321 biomeKey = BlockStateRecipeUtil.readBiomeKey((class_2540)buffer);
            class_6862 biomeTag = BlockStateRecipeUtil.readBiomeTag((class_2540)buffer);
            BlockStateIngredient bypassBlock = BlockStateIngredient.fromNetwork((class_2540)buffer);
            class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
            return new ItemBanRecipe(id, (class_5321<class_1959>)biomeKey, (class_6862<class_1959>)biomeTag, bypassBlock, ingredient);
        }

        @Override
        public void toNetwork(class_2540 buffer, ItemBanRecipe recipe) {
            super.toNetwork(buffer, recipe);
            ((class_1856)recipe.getIngredient()).method_8088(buffer);
        }
    }
}

