/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners.abilities;

import com.aetherteam.aether.event.hooks.AbilityHooks;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityStruckByLightningEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.ProjectileImpactEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingDamageEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1676;
import net.minecraft.class_239;

public class WeaponAbilityListener {
    public static void onDartHurt(LivingHurtEvent event) {
        class_1309 livingEntity = event.getEntity();
        class_1282 damageSource = event.getSource();
        if (!event.isCanceled()) {
            AbilityHooks.WeaponHooks.stickDart(livingEntity, damageSource);
        }
    }

    public static void onArrowHit(ProjectileImpactEvent event) {
        class_239 hitResult = event.getRayTraceResult();
        class_1676 projectile = event.getProjectile();
        if (!event.isCanceled()) {
            AbilityHooks.WeaponHooks.phoenixArrowHit(hitResult, projectile);
        }
    }

    public static void onLightningStrike(EntityStruckByLightningEvent event) {
        class_1297 entity = event.getEntity();
        class_1538 lightningBolt = event.getLightning();
        if (!event.isCanceled() && AbilityHooks.WeaponHooks.lightningTracking(entity, lightningBolt)) {
            event.setCanceled(true);
        }
    }

    public static void onEntityDamage(LivingDamageEvent event) {
        class_1309 targetEntity = event.getEntity();
        class_1282 damageSource = event.getSource();
        class_1297 sourceEntity = damageSource.method_5526();
        event.setAmount(AbilityHooks.WeaponHooks.reduceWeaponEffectiveness(targetEntity, sourceEntity, event.getAmount()));
        event.setAmount(AbilityHooks.WeaponHooks.reduceArmorEffectiveness(targetEntity, sourceEntity, event.getAmount()));
    }

    public static void init() {
        LivingHurtEvent.HURT.register(WeaponAbilityListener::onDartHurt);
        EntityEvents.ENTITY_STRUCK_BY_LIGHTING.register(WeaponAbilityListener::onLightningStrike);
        ProjectileImpactEvent.PROJECTILE_IMPACT.register(WeaponAbilityListener::onArrowHit);
        LivingDamageEvent.DAMAGE.register(WeaponAbilityListener::onEntityDamage);
    }
}

