/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners.abilities;

import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aether.item.combat.abilities.armor.GravititeArmor;
import com.aetherteam.aether.item.combat.abilities.armor.NeptuneArmor;
import com.aetherteam.aether.item.combat.abilities.armor.PhoenixArmor;
import com.aetherteam.aether.item.combat.abilities.armor.ValkyrieArmor;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingAttackEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1309;

public class ArmorAbilityListener {
    public static void onEntityUpdate(LivingEntityEvents.LivingTickEvent event) {
        class_1309 livingEntity = event.getEntity();
        if (!event.isCanceled()) {
            ValkyrieArmor.handleFlight(livingEntity);
            NeptuneArmor.boostWaterSwimming(livingEntity);
            PhoenixArmor.boostLavaSwimming(livingEntity);
            PhoenixArmor.damageArmor(livingEntity);
        }
    }

    public static void onEntityJump(LivingEntityEvents.LivingJumpEvent event) {
        class_1309 livingEntity = event.getEntity();
        GravititeArmor.boostedJump(livingEntity);
    }

    public static void onEntityFall(LivingEntityEvents.Fall.FallEvent event) {
        class_1309 livingEntity = (class_1309)event.getEntity();
        if (!event.isCanceled()) {
            event.setCanceled(AbilityHooks.ArmorHooks.fallCancellation(livingEntity));
        }
    }

    public static void onEntityAttack(LivingAttackEvent event) {
        class_1309 livingEntity = event.getEntity();
        class_1282 damageSource = event.getSource();
        if (!event.isCanceled()) {
            event.setCanceled(PhoenixArmor.extinguishUser(livingEntity, damageSource));
        }
    }

    public static void init() {
        LivingEntityEvents.LivingTickEvent.TICK.register(ArmorAbilityListener::onEntityUpdate);
        LivingEntityEvents.LivingJumpEvent.JUMP.register(ArmorAbilityListener::onEntityJump);
        LivingEntityEvents.FALL.register(ArmorAbilityListener::onEntityFall);
        LivingAttackEvent.ATTACK.register(ArmorAbilityListener::onEntityAttack);
    }
}

