/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.listeners;

import com.aetherteam.aether.client.event.hooks.WorldPreviewHooks;
import io.github.fabricators_of_create.porting_lib.event.client.CameraSetupCallback;
import io.github.fabricators_of_create.porting_lib.event.client.LivingEntityRenderEvents;
import io.github.fabricators_of_create.porting_lib.event.client.RenderPlayerEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_922;

public class WorldPreviewListener {
    public static void onGuiOpenLowest(class_437 newScreen) {
        WorldPreviewHooks.setupWorldPreview(newScreen);
    }

    public static boolean onScreenRender(class_437 screen) {
        return WorldPreviewHooks.hideScreen(screen);
    }

    public static void onRenderLevelLast(WorldRenderContext context) {
        WorldPreviewHooks.renderMenuWithWorld();
    }

    public static void onClientTick(class_310 client) {
        WorldPreviewHooks.tickMenuWhenPaused();
    }

    public static boolean onCameraView(CameraSetupCallback.CameraInfo info) {
        WorldPreviewHooks.angleCamera();
        return false;
    }

    public static boolean onRenderPlayer(class_1657 player, class_1007 renderer, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight) {
        boolean hide = WorldPreviewHooks.shouldHidePlayer();
        boolean canceled = false;
        if (hide) {
            canceled = true;
        }
        WorldPreviewHooks.adjustShadow(renderer, hide);
        return canceled;
    }

    public static <T extends class_1309, M extends class_583<T>> boolean onRenderEntity(class_1309 entity, class_922<?, ?> renderer, float partialRenderTick, class_4587 matrixStack, class_4597 buffers, int light) {
        boolean hide = WorldPreviewHooks.shouldHideEntity((class_1297)entity);
        boolean canceled = false;
        if (hide) {
            canceled = true;
        }
        WorldPreviewHooks.adjustShadow(renderer, hide);
        return canceled;
    }

    public static void init() {
        WorldRenderEvents.LAST.register(WorldPreviewListener::onRenderLevelLast);
        ClientTickEvents.END_CLIENT_TICK.register(WorldPreviewListener::onClientTick);
        LivingEntityRenderEvents.PRE.register(WorldPreviewListener::onRenderEntity);
        CameraSetupCallback.EVENT.register(WorldPreviewListener::onCameraView);
        RenderPlayerEvents.PRE.register(WorldPreviewListener::onRenderPlayer);
    }
}

