/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.portal;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.portal.AetherPortalBlock;
import com.aetherteam.aether.mixin.mixins.common.accessor.EntityAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.clientbound.PortalTravelSoundPacket;
import com.aetherteam.aether.world.AetherPoi;
import com.aetherteam.aether.world.LevelUtil;
import com.aetherteam.nitrogen.network.BasePacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import io.github.fabricators_of_create.porting_lib.entity.ITeleporter;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import me.pepperbell.simplenetworking.SimpleChannel;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2424;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_4538;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import org.jetbrains.annotations.Nullable;

public class AetherPortalForcer
implements ITeleporter {
    private final class_3218 level;
    private final boolean hasFrame;
    private final boolean isStartup;

    public AetherPortalForcer(class_3218 level, boolean hasFrame) {
        this.level = level;
        this.hasFrame = hasFrame;
        this.isStartup = false;
    }

    public AetherPortalForcer(class_3218 level, boolean hasFrame, boolean isStartup) {
        this.level = level;
        this.hasFrame = hasFrame;
        this.isStartup = isStartup;
    }

    public boolean playTeleportSound(class_3222 player, class_3218 sourceLevel, class_3218 destinationLevel) {
        if (this.hasFrame) {
            PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new PortalTravelSoundPacket(), (class_3222)player);
        }
        return false;
    }

    @Nullable
    public class_5454 getPortalInfo(class_1297 entity, class_3218 destinationLevel, Function<class_3218, class_5454> defaultPortalInfo) {
        boolean isAether;
        EntityAccessor entityAccessor = (EntityAccessor)entity;
        boolean bl = isAether = destinationLevel.method_27983() == LevelUtil.destinationDimension();
        if (entity.method_37908().method_27983() != LevelUtil.destinationDimension() && !isAether) {
            return null;
        }
        if (this.isStartup) {
            return new class_5454(this.checkPositionsForInitialSpawn((class_1937)destinationLevel, entity.method_24515()).method_46558(), class_243.field_1353, entity.method_36454(), entity.method_36455());
        }
        if (!this.hasFrame) {
            return new class_5454(new class_243(entity.method_23317(), (double)destinationLevel.method_31600(), entity.method_23321()), class_243.field_1353, entity.method_36454(), entity.method_36455());
        }
        class_2784 worldBorder = destinationLevel.method_8621();
        double scale = class_2874.method_31109((class_2874)this.level.method_8597(), (class_2874)destinationLevel.method_8597());
        class_2338 scaledEntityPos = worldBorder.method_39538(entity.method_23317() * scale, entity.method_23318(), entity.method_23321() * scale);
        return this.getExitPortal(entity, scaledEntityPos, worldBorder).map(rectangle -> {
            class_243 vec3;
            class_2350.class_2351 axis;
            class_2680 blockState = this.level.method_8320(entityAccessor.aether$getPortalEntrancePos());
            if (blockState.method_28498((class_2769)class_2741.field_12529)) {
                axis = (class_2350.class_2351)blockState.method_11654((class_2769)class_2741.field_12529);
                class_5459.class_5460 foundRectangle = class_5459.method_30574((class_2338)entityAccessor.aether$getPortalEntrancePos(), (class_2350.class_2351)axis, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, blockPos -> this.level.method_8320(blockPos) == blockState);
                vec3 = entityAccessor.callGetRelativePortalPosition(axis, foundRectangle);
            } else {
                axis = class_2350.class_2351.field_11048;
                vec3 = new class_243(0.5, 0.0, 0.0);
            }
            return class_2424.method_30484((class_3218)destinationLevel, (class_5459.class_5460)rectangle, (class_2350.class_2351)axis, (class_243)vec3, (class_1297)entity, (class_243)entity.method_18798(), (float)entity.method_36454(), (float)entity.method_36455());
        }).orElse(null);
    }

    private Optional<class_5459.class_5460> getExitPortal(class_1297 entity, class_2338 findFrom, class_2784 worldBorder) {
        EntityAccessor entityAccessor = (EntityAccessor)entity;
        if (entity instanceof class_3222) {
            Optional<class_5459.class_5460> optional = this.findPortalAround(findFrom, worldBorder);
            if (optional.isPresent()) {
                return optional;
            }
            class_2350.class_2351 direction$axis = this.level.method_8320(entityAccessor.aether$getPortalEntrancePos()).method_28500(AetherPortalBlock.AXIS).orElse(class_2350.class_2351.field_11048);
            Optional<class_5459.class_5460> portalOptional = this.createPortal(findFrom, direction$axis);
            if (portalOptional.isEmpty()) {
                Aether.LOGGER.error("Unable to create an Aether Portal, likely target out of worldborder");
            }
            return portalOptional;
        }
        return this.findPortalAround(findFrom, worldBorder);
    }

    private Optional<class_5459.class_5460> findPortalAround(class_2338 pos, class_2784 worldBorder) {
        class_4153 poiManager = this.level.method_19494();
        poiManager.method_22439((class_4538)this.level, pos, 128);
        Optional<class_4156> optionalPoi = poiManager.method_22383(poiType -> ((class_4158)poiType.comp_349()).equals((Object)AetherPoi.AETHER_PORTAL), pos, 128, class_4153.class_4155.field_18489).filter(poiRecord -> worldBorder.method_11952(poiRecord.method_19141())).sorted(Comparator.comparingDouble(poiRecord -> poiRecord.method_19141().method_10262((class_2382)pos)).thenComparingInt(poiRecord -> poiRecord.method_19141().method_10264())).filter(poiRecord -> this.level.method_8320(poiRecord.method_19141()).method_28498((class_2769)class_2741.field_12529)).findFirst();
        return optionalPoi.map(poiRecord -> {
            class_2338 poiPos = poiRecord.method_19141();
            this.level.method_14178().method_17297(class_3230.field_19280, new class_1923(poiPos), 3, (Object)poiPos);
            class_2680 blockstate = this.level.method_8320(poiPos);
            return class_5459.method_30574((class_2338)poiPos, (class_2350.class_2351)((class_2350.class_2351)blockstate.method_11654((class_2769)class_2741.field_12529)), (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, blockPos -> this.level.method_8320(blockPos) == blockstate);
        });
    }

    public Optional<class_5459.class_5460> createPortal(class_2338 pos, class_2350.class_2351 axis) {
        class_2350 direction = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        double d0 = -1.0;
        class_2338 blockPos = null;
        double d1 = -1.0;
        class_2338 blockPos1 = null;
        class_2784 worldBorder = this.level.method_8621();
        int i = Math.min(this.level.method_31600(), this.level.method_31607() + this.level.method_32819()) - 1;
        class_2338.class_2339 mutablePos = pos.method_25503();
        for (class_2338.class_2339 mutablePos1 : class_2338.method_30512((class_2338)pos, (int)16, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
            int j = Math.min(i, this.level.method_8624(class_2902.class_2903.field_13197, mutablePos1.method_10263(), mutablePos1.method_10260()));
            if (!worldBorder.method_11952((class_2338)mutablePos1) || !worldBorder.method_11952((class_2338)mutablePos1.method_10104(direction, 1))) continue;
            mutablePos1.method_10104(direction.method_10153(), 1);
            for (int l = j; l >= this.level.method_31607(); --l) {
                int j1;
                mutablePos1.method_33098(l);
                if (!this.level.method_22347((class_2338)mutablePos1)) continue;
                int i1 = l;
                while (l > this.level.method_31607() && this.level.method_22347((class_2338)mutablePos1.method_10098(class_2350.field_11033))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                mutablePos1.method_33098(l);
                if (!this.canHostFrame((class_2338)mutablePos1, mutablePos, direction, 0)) continue;
                double d2 = pos.method_10262((class_2382)mutablePos1);
                if (this.canHostFrame((class_2338)mutablePos1, mutablePos, direction, -1) && this.canHostFrame((class_2338)mutablePos1, mutablePos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockPos = mutablePos1.method_10062();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockPos1 = mutablePos1.method_10062();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockPos = blockPos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            int i2 = i - 9;
            int k1 = Math.max(this.level.method_31607() + 1, 70);
            if (i2 < k1) {
                return Optional.empty();
            }
            blockPos = new class_2338(pos.method_10263(), class_3532.method_15340((int)pos.method_10264(), (int)k1, (int)i2), pos.method_10260()).method_10062();
            class_2350 direction1 = direction.method_10170();
            if (!worldBorder.method_11952(blockPos)) {
                return Optional.empty();
            }
            for (int i3 = -1; i3 < 2; ++i3) {
                for (int j3 = 0; j3 < 2; ++j3) {
                    for (int k3 = -1; k3 < 3; ++k3) {
                        class_2680 blockState1 = k3 < 0 ? class_2246.field_10171.method_9564() : class_2246.field_10124.method_9564();
                        mutablePos.method_25504((class_2382)blockPos, j3 * direction.method_10148() + i3 * direction1.method_10148(), k3, j3 * direction.method_10165() + i3 * direction1.method_10165());
                        this.level.method_8501((class_2338)mutablePos, blockState1);
                    }
                }
            }
        }
        for (int l1 = -1; l1 < 3; ++l1) {
            for (int j2 = -1; j2 < 4; ++j2) {
                if (l1 != -1 && l1 != 2 && j2 != -1 && j2 != 3) continue;
                mutablePos.method_25504(blockPos, l1 * direction.method_10148(), j2, l1 * direction.method_10165());
                this.level.method_8652((class_2338)mutablePos, class_2246.field_10171.method_9564(), 3);
            }
        }
        class_2680 blockState = (class_2680)((AetherPortalBlock)((Object)AetherBlocks.AETHER_PORTAL.get())).method_9564().method_11657(AetherPortalBlock.AXIS, (Comparable)axis);
        for (int k2 = 0; k2 < 2; ++k2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                mutablePos.method_25504((class_2382)blockPos, k2 * direction.method_10148(), l2, k2 * direction.method_10165());
                this.level.method_8652((class_2338)mutablePos, blockState, 18);
            }
        }
        return Optional.of(new class_5459.class_5460(blockPos.method_10062(), 2, 3));
    }

    private boolean canHostFrame(class_2338 originalPos, class_2338.class_2339 offsetPos, class_2350 direction, int offsetScale) {
        class_2350 clockWiseDirection = direction.method_10170();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.method_25504((class_2382)originalPos, direction.method_10148() * i + clockWiseDirection.method_10148() * offsetScale, j, direction.method_10165() * i + clockWiseDirection.method_10165() * offsetScale);
                class_2680 blockState = this.level.method_8320((class_2338)offsetPos);
                if (j < 0 && (!blockState.method_51367() || blockState.method_26164(AetherTags.Blocks.AETHER_PORTAL_BLACKLIST))) {
                    return false;
                }
                if (j < 0 || this.level.method_22347((class_2338)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    private class_2338 checkPositionsForInitialSpawn(class_1937 level, class_2338 origin) {
        if (!this.isSafe(level, origin)) {
            for (int i = 0; i <= 750; i += 5) {
                for (class_2350 facing : class_2350.class_2353.field_11062) {
                    class_2338 offsetPosition = origin.method_10081(facing.method_10163().method_35862(i));
                    if (this.isSafeAround(level, offsetPosition)) {
                        return offsetPosition;
                    }
                    class_2338 heightmapPosition = level.method_8598(class_2902.class_2903.field_13197, offsetPosition);
                    if (!this.isSafeAround(level, heightmapPosition)) continue;
                    return heightmapPosition;
                }
            }
        }
        return origin;
    }

    public boolean isSafeAround(class_1937 level, class_2338 pos) {
        class_2338 belowPos = pos.method_10074();
        if (!this.isSafe(level, belowPos)) {
            return false;
        }
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            if (this.isSafe(level, belowPos.method_10079(facing, 2))) continue;
            return false;
        }
        return true;
    }

    private boolean isSafe(class_1937 level, class_2338 pos) {
        return level.method_8621().method_11952(pos) && level.method_8320(pos).method_26164(AetherTags.Blocks.AETHER_DIRT) && level.method_8320(pos.method_10084()).method_26215() && level.method_8320(pos.method_10086(2)).method_26215();
    }
}

