/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.systems;

import earth.terrarium.adastra.api.events.AdAstraEvents;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.handlers.PlanetHandler;
import earth.terrarium.adastra.mixins.common.LivingEntityAccessor;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_8144;

public class GravityApiImpl
implements GravityApi {
    @Override
    public float getGravity(class_1937 level) {
        return this.getGravity((class_5321<class_1937>)level.method_27983());
    }

    @Override
    public float getGravity(class_5321<class_1937> level) {
        return ((Float)class_8144.method_49078((Object)PlanetApi.API.getPlanet(level), Planet::gravity, (Object)Float.valueOf(9.807f))).floatValue() / 9.807f;
    }

    @Override
    public float getGravity(class_1937 level, class_2338 pos) {
        if (!(level instanceof class_3218)) {
            return this.getGravity(level);
        }
        class_3218 serverLevel = (class_3218)level;
        return PlanetHandler.getGravity(serverLevel, pos);
    }

    @Override
    public float getGravity(class_1297 entity) {
        if (AdAstraConfig.disableGravity) {
            return 1.0f;
        }
        float gravity = this.getGravity(entity.method_37908(), class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23320(), (double)entity.method_23321()));
        return AdAstraEvents.EntityGravityEvent.fire(entity, gravity);
    }

    @Override
    public void setGravity(class_1937 level, class_2338 pos, float gravity) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        PlanetHandler.setGravity(serverLevel, pos, gravity);
    }

    @Override
    public void setGravity(class_1937 level, Collection<class_2338> positions, float gravity) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        PlanetHandler.setGravity(serverLevel, positions, gravity);
    }

    @Override
    public void removeGravity(class_1937 level, class_2338 pos) {
        this.setGravity(level, pos, this.getGravity(level));
    }

    @Override
    public void removeGravity(class_1937 level, Collection<class_2338> positions) {
        this.setGravity(level, positions, this.getGravity(level));
    }

    @Override
    public void entityTick(class_1937 level, class_1309 entity, class_243 travelVector, class_2338 movementAffectingPos) {
        if (AdAstraConfig.disableGravity) {
            return;
        }
        if (!entity.method_5787()) {
            return;
        }
        boolean touchingSomething = false;
        for (class_2350 direction : class_2350.values()) {
            class_2338 pos = movementAffectingPos.method_10093(direction);
            if (level.method_8320(pos).method_26215()) continue;
            touchingSomething = true;
            break;
        }
        float ySpeed = 0.0f;
        if ((touchingSomething || level.method_8510() % 10L == 0L) && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_5715()) {
                ySpeed = -0.01f;
            } else if (((LivingEntityAccessor)player).isJumping()) {
                ySpeed = 0.01f;
            }
        }
        if (!touchingSomething) {
            travelVector = travelVector.method_1021((double)0.12f);
        }
        float friction = level.method_8320(movementAffectingPos).method_26204().method_9499();
        float speed = touchingSomething ? (entity.method_24828() ? friction * 0.91f : 0.91f) : (entity.method_24828() ? friction * 0.999f : 0.999f);
        class_243 movementVector = entity.method_26318(travelVector, friction);
        double downSpeed = movementVector.field_1351;
        if (entity.method_37908().method_8608() && !entity.method_37908().method_22340(movementAffectingPos)) {
            downSpeed = entity.method_23318() > (double)entity.method_37908().method_31607() ? -0.1 : 0.0;
        }
        downSpeed += (double)ySpeed;
        if (entity.method_35053()) {
            entity.method_18800(movementVector.field_1352, downSpeed, movementVector.field_1350);
        } else {
            entity.method_18800(movementVector.field_1352 * (double)speed, downSpeed * 0.98, movementVector.field_1350 * (double)speed);
        }
        entity.method_29242(this instanceof class_1432);
    }
}

