/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.handlers;

import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.PlanetData;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_3218;

public class PlanetHandler
extends SaveHandler {
    private final Map<class_2338, PlanetData> planetData = new HashMap<class_2338, PlanetData>();
    private final class_3218 level;

    public PlanetHandler(class_3218 level) {
        this.level = level;
    }

    public void loadData(class_2487 tag) {
        int[] data = tag.method_10561("");
        if (data.length % 3 != 0) {
            throw new RuntimeException("Invalid data length");
        }
        for (int i = 0; i < data.length; i += 3) {
            int firstPos = data[i];
            int secondPos = data[i + 1];
            this.planetData.put(class_2338.method_10092((long)((long)firstPos << 32 | (long)secondPos & 0xFFFFFFFFL)), PlanetData.unpack(data[i + 2]));
        }
    }

    public void saveData(class_2487 tag) {
        boolean defaultOxygen = OxygenApi.API.hasOxygen((class_1937)this.level);
        short defaultTemperature = TemperatureApi.API.getTemperature((class_1937)this.level);
        float defaultGravity = GravityApi.API.getGravity((class_1937)this.level);
        IntArrayList dataArray = new IntArrayList(this.planetData.size() * 3);
        Set<Map.Entry<class_2338, PlanetData>> entries = this.planetData.entrySet();
        for (Map.Entry<class_2338, PlanetData> entry : entries) {
            PlanetData data = entry.getValue();
            if (data.oxygen() == defaultOxygen && data.temperature() == defaultTemperature && data.gravity() == defaultGravity) continue;
            long pos = entry.getKey().method_10063();
            dataArray.add((int)(pos >> 32));
            dataArray.add((int)pos);
            dataArray.add(entry.getValue().pack());
        }
        tag.method_10539("", dataArray.toIntArray());
    }

    public static PlanetHandler read(class_3218 level) {
        return (PlanetHandler)PlanetHandler.read((class_26)level.method_17983(), () -> new PlanetHandler(level), (String)"adastra_planet_data");
    }

    public static boolean hasOxygen(class_3218 level, class_2338 pos) {
        PlanetData data = PlanetHandler.read((class_3218)level).planetData.get(pos);
        return data == null ? OxygenApi.API.hasOxygen((class_1937)level) : data.oxygen();
    }

    public static short getTemperature(class_3218 level, class_2338 pos) {
        PlanetData data = PlanetHandler.read((class_3218)level).planetData.get(pos);
        return data == null ? TemperatureApi.API.getTemperature((class_1937)level) : data.temperature();
    }

    public static float getGravity(class_3218 level, class_2338 pos) {
        PlanetData data = PlanetHandler.read((class_3218)level).planetData.get(pos);
        return data == null ? GravityApi.API.getGravity((class_1937)level) : data.gravity();
    }

    public static void setOxygen(class_3218 level, class_2338 pos, boolean oxygen) {
        PlanetHandler data = PlanetHandler.read(level);
        data.planetData.computeIfAbsent(pos, p -> new PlanetData(oxygen, PlanetHandler.getTemperature(level, p), PlanetHandler.getGravity(level, p))).setOxygen(oxygen);
    }

    public static void setTemperature(class_3218 level, class_2338 pos, short temperature) {
        PlanetHandler data = PlanetHandler.read(level);
        data.planetData.computeIfAbsent(pos, p -> new PlanetData(PlanetHandler.hasOxygen(level, p), temperature, PlanetHandler.getGravity(level, p))).setTemperature(temperature);
    }

    public static void setGravity(class_3218 level, class_2338 pos, float gravity) {
        PlanetHandler data = PlanetHandler.read(level);
        data.planetData.computeIfAbsent(pos, p -> new PlanetData(PlanetHandler.hasOxygen(level, p), PlanetHandler.getTemperature(level, p), gravity)).setGravity(gravity);
    }

    public static void setOxygen(class_3218 level, Collection<class_2338> positions, boolean oxygen) {
        PlanetHandler data = PlanetHandler.read(level);
        for (class_2338 pos : positions) {
            data.planetData.computeIfAbsent(pos, p -> new PlanetData(oxygen, PlanetHandler.getTemperature(level, p), PlanetHandler.getGravity(level, p))).setOxygen(oxygen);
        }
    }

    public static void setTemperature(class_3218 level, Collection<class_2338> positions, short temperature) {
        PlanetHandler data = PlanetHandler.read(level);
        for (class_2338 pos : positions) {
            data.planetData.computeIfAbsent(pos, p -> new PlanetData(PlanetHandler.hasOxygen(level, p), temperature, PlanetHandler.getGravity(level, p))).setTemperature(temperature);
        }
    }

    public static void setGravity(class_3218 level, Collection<class_2338> positions, float gravity) {
        PlanetHandler data = PlanetHandler.read(level);
        for (class_2338 pos : positions) {
            data.planetData.computeIfAbsent(pos, p -> new PlanetData(PlanetHandler.hasOxygen(level, p), PlanetHandler.getTemperature(level, p), gravity)).setGravity(gravity);
        }
    }

    public boolean method_79() {
        return true;
    }
}

