/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.CoalGeneratorMenu;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.ExtractOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.util.CommonHooks;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class CoalGeneratorBlockEntity
extends EnergyContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.PUSH, ConstantComponents.SIDE_CONFIG_ENERGY));
    protected int cookTime;
    protected int cookTimeTotal;

    public CoalGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 2);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new CoalGeneratorMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new ExtractOnlyEnergyContainer(MachineConfig.ironTierEnergyCapacity, MachineConfig.ironTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.cookTime = tag.method_10550("CookTime");
        this.cookTimeTotal = tag.method_10550("CookTimeTotal");
    }

    @Override
    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("CookTime", this.cookTime);
        tag.method_10569("CookTimeTotal", this.cookTimeTotal);
    }

    @Override
    public EnergyContainerMachineBlockEntity.ChargeSlotType getChargeSlotType() {
        return EnergyContainerMachineBlockEntity.ChargeSlotType.POWER_ITEM;
    }

    @Override
    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        if (!this.canFunction()) {
            if (time % 10L == 0L) {
                this.setLit(false);
            }
            return;
        }
        class_1799 input = this.method_5438(1);
        if (this.getEnergyStorage().internalInsert(MachineConfig.coalGeneratorEnergyGenerationPerTick, true) == 0L) {
            if (time % 10L == 0L) {
                this.setLit(false);
            }
            return;
        }
        if (this.cookTime > 0) {
            --this.cookTime;
            this.getEnergyStorage().internalInsert(MachineConfig.coalGeneratorEnergyGenerationPerTick, false);
            if (time % 10L == 0L) {
                this.setLit(true);
            }
        } else if (!input.method_7960() && !(input.method_7909() instanceof class_1755)) {
            int burnTime = Math.min(20000, CommonHooks.getBurnTime((class_1799)input));
            if (burnTime > 0) {
                input.method_7934(1);
                this.cookTimeTotal = burnTime;
                this.cookTime = burnTime;
            }
        } else if (time % 10L == 0L) {
            this.setLit(false);
        }
    }

    @Override
    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pushItemsNearby(this, pos, new int[]{1}, sideConfig.get(0), filter);
        TransferUtils.pullItemsNearby(this, pos, new int[]{1}, sideConfig.get(0), filter);
        TransferUtils.pushEnergyNearby(this, pos, this.getEnergyStorage().maxExtract(), sideConfig.get(1), filter);
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int cookTime() {
        return this.cookTime;
    }

    public int cookTimeTotal() {
        return this.cookTimeTotal;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return new int[]{1};
    }
}

